/*
 *      VMSTAR.H - holds all the definitions needed to handle a tar file.
 */
#ifndef LOADED_VMSTAR_H
#define LOADED_VMSTAR_H

#include <descrip.h>
#include <dvidef.h>

#ifndef DVI$C_ACP_F11V5
# define DVI$C_ACP_F11V5 11             /* FILES-11 STRUCTURE LEVEL 5 */
#endif

#if !defined(__DECC) || __VMS_VER < 70000000
# define bzero(__x,__y) memset(__x, 0, __y)
#endif

#if !defined(__VAX) && defined(__CRTL_VER) && __CRTL_VER >= 70301000
# ifndef NO_SYMLINKS
#   define SYMLINKS
# endif
#endif

#if !defined(__VAX) && __CRTL_VER >= 70301000
# define STAT lstat
#else
# define STAT stat
#endif


#define ERROR1          -1
#define ISDIRE          1
#define ISFILE          0
#define ISSLNK          2
#define NAMSIZE         100
#define BUFFERFACTOR    32      /* Buffer size multiplier */
#define RECSIZE         512     /* Data block size */
#if 0
# define BLKSIZE        10240   /* Block size */
#else
# define BLKSIZE        ((RECSIZE) * (block_factor))    /* Block size */
#endif
#define BUFFERSIZE      (RECSIZE * BUFFERFACTOR)

#define T_NAM_LEN 32767         /* Miscellaneous name storage size. */

#define DEFAULT_NAME    "*.*;"

/* BADCHARS defines which characters are not permitted in a VMS file name.
   TRANSLATE defines what character should be used instead.
   Beware! The position of the character in TRANSLATE must correspond to
   the position of the bad character in BADCHARS.
*/

#define BADCHARS_ODS2   "!@#%^&*()+=|~`[]{}':;<>,? \\\""
#define TRANSLATE_ODS2  "__$______X____________________"

#define BADCHARS_ODS5   "*|:<>?\\\""
#define TRANSLATE_ODS5  "__________"

struct tarhdr                   /* A tar header */
{
    char title[NAMSIZE];
    char protection[8];
    char uid[8];                /* this is the user id */
    char gid[8];                /* this is the group id */
    char count[12];             /* was 11 in error */
    char time[12];              /* UNIX format date  */
    char chksum[8];             /* header checksum */
    char linkflag;              /* hope this is right */
    char linkname[NAMSIZE];     /* Space for the name of the link */
    char dummy[255];            /* and the rest */
};

/* GNU tar extract. */

/* The linkflag defines the type of file.  */
#define LF_OLDNORMAL    '\0'    /* normal disk file, Unix compat */
#define LF_NORMAL       '0'     /* normal disk file */
#define LF_LINK         '1'     /* link to previously dumped file */
#define LF_SYMLINK      '2'     /* symbolic link */
#define LF_CHR          '3'     /* character special file */
#define LF_BLK          '4'     /* block special file */
#define LF_DIR          '5'     /* directory */
#define LF_FIFO         '6'     /* FIFO special file */
#define LF_CONTIG       '7'     /* contiguous file */
/* Further link types may be defined later.  */

/* Note that the standards committee allows only capital A through
   capital Z for user-defined expansion.  This means that defining
   something as, say '8' is a *bad* idea.  */

/* This is a dir entry that contains the names of files that were in the
   dir at the time the dump was made.  */
#define LF_DUMPDIR      'D'

/* Identifies the NEXT file on the tape as having a long linkname.  */
#define LF_LONGLINK     'K'

/* Identifies the NEXT file on the tape as having a long name.  */
#define LF_LONGNAME     'L'

/* This is the continuation of a file that began on another volume.  */
#define LF_MULTIVOL     'M'

/* For storing filenames that didn't fit in 100 characters.  */
#define LF_NAMES        'N'

/* This is for sparse files.  */
#define LF_SPARSE       'S'

/* This file is a tape/volume header.  Ignore it on extraction.  */
#define LF_VOLHDR       'V'


/* Common function prototypes. */

int cleanup_dire( char *string);

int tar2vms( int argc, char **argv);

int vms2tar( int argc, char **argv);


#endif /* LOADED_VMSTAR_H */
