Q 	OPTIONS		/EXTEND_SOURCE				! Allow up to 132 characters per line in this module.    	PROGRAM		XMAIL    ************************************************************************************************************************************ *																   *  *  Create a unique environment in which extended MAIL utilities may be run.  This file contains these utilities as subroutines.	   * *																   * b *  This program should be installed, as the subroutines require privilege as shown below:					   *, *	CHECK_MAIL				Bypass, Sysprv.									   *( *	CLEAN_VMSMAIL				Bypass.										   *$ *	NORMAL_EXIT				None.										   * *	HELP					None.										   *3 *	NUMBER_OF_NEWMAIL_MESSAGES		Bypass.										   * ( *	RESET_NEWMAIL				Bypass.										   */ *	COUNT_NEWMAIL				Bypass, Sysprv.									   * ( *	SMAIL					Bypass, Exquota.								   * *																   *  *  In addition, a list of designated users is identified for each routine.  The process username is checked against this list	   * *  at the beginning of each routine.  Therefore, users do not need VMS privilege to select these options, although they must be	   *f *  "known" to the subroutine.  Each subroutine may have a different list of designated users.					   * *																   *  *  This version of Xmail works on VMS V4 and V5 operating systems.  The current version is checked, and if it is not 4 or 5, a	   * O *  message is written to the terminal screen and the program exits.								   *  *																   * & *  Revision history:														   *7 *  1.0	Nov, 1988	Initial implementation.											   *  *																   * y *  2.0 June, 1989	Update routines as necessary to run under either VMS 4 or 5.  Fix minor bugs.  Enhance algorithms.	   * V *			 1.  Check operating system version for V4 or V5; exit if neither 4 nor 5.				   *\ *			 2.  Update comments in this program to reflect correctly on VMS Version 4 and 5.			   *g *			 3.  External Help file and DCL-level Help file updated to reflect correctly on VMS V4 and 5.		   * E *			 4.  Refined some of the run-time diagnostic messages.							   * m *			 5.  Process the system mail file records in a subroutine.  This simplifies handling the differences	   * N *			     between the V4 system mail file and the V5 system mail file.					   *b *			 6.  Process the system mail file and user mail files for VMS 5 using TLD field format.			   *L *			 7.  Process user mail files for VMS 4 using TLD field format.						   *R *			 8.  Provide a missing argument in calls to STR$FIND_FIRST_SUBSTRING.					   *p *			 9.  Change NUM_MESSAGES, the variable containing the number of newmail messages recorded in system mail   *, *			     file to a word value.										   *p *			10.  In routine RESET_NEWMAIL, if an entry does not exist in the system mail file for a particular user,   *p *			     and if that user has no new mail messages, this version of Xmail will not add an entry to the system  *p *			     mail file.  The reason for this is that when the new user receives a mail message, then VMS Mail will *p *			     add the entry.  However, if the user's UAF entry is deleted before any mail is received, having added *l *			     an entry to the system mail file would require running Xmail option CLEAN_VMSMAIL to purge it.	   *U *			11.  Add consideration of the "cc" field in routine CHECK_MAIL for VMS 5.				   * p *			12.  Routine SMAIL no longer attempts to send a system-wide message to users for whom the UAF flag NOMAIL  *  *			     is set.												   * *																   * ; *  Alan MacArthur, The Boeing Company, 1988.											   *  *																   *  ************************************************************************************************************************************   	IMPLICIT	INTEGER (A-Z)   _ 	CHARACTER	COMMAND_LINE*80				! Command line entered by the user while this program is running. I 	CHARACTER	CHAR_VERSION*8				! VMS version number returned by LIB$GETSYI.   ? 	EXTERNAL	SYI$_VERSION				! Item to be retrieved by LIB$GETSYI. X 	EXTERNAL	LIB$GET_INPUT				! Address of routine to get required parameters not supplied.6 	EXTERNAL	XMAIL_COMMANDS				! Command Definition File.   C  End of declarations.   = C  Determine the current version of the VMS operating system.   4 	STATUS=LIB$GETSYI(%LOC(SYI$_VERSION),,CHAR_VERSION)   	I=INDEX(CHAR_VERSION,'.'). 	READ(CHAR_VERSION(2:I-1),*,IOSTAT=IOS)VERSION  % 	IF(VERSION.LT.4.OR.VERSION.GT.5)THEN B 	  TYPE '(/X,A)','This program will only operate on VMS V4 or V5.' 	  CALL EXIT 	END IF    C  If a command was entered as a parameter when activating this program, attempt to parse it, and call the appropriate routine.  If  C  no command was entered, or if it could not be parsed, enter a loop in which the user is prompted for commands, and those commandsP C  are dispatched.  Continue until the user requests EXIT, or presses Control-Z.  % 	STATUS=LIB$GET_FOREIGN(COMMAND_LINE) Y 	IF(COMMAND_LINE.NE.' '.AND.CLI$DCL_PARSE(COMMAND_LINE,XMAIL_COMMANDS,LIB$GET_INPUT))THEN  	  STATUS=CLI$DISPATCH(VERSION) S 	  CALL EXIT						! Only perform one command.  Used for CHECK option, for instance.  	END IF   F 	DO WHILE(.TRUE.)					! Infinite loop for continued program operation.< 	  TYPE '(/A)','$X-mail> '				! The prompt for this program.E 	  READ(5,'(A)',IOSTAT=IOS)COMMAND_LINE			! Read what the user typed. A 	  IF(IOS.EQ.-1)CALL NORMAL_EXIT				! All done with this program. Y 	  IF(CLI$DCL_PARSE(COMMAND_LINE,XMAIL_COMMANDS,LIB$GET_INPUT))CALL CLI$DISPATCH(VERSION)  	END DO    	END  Q 	OPTIONS		/EXTEND_SOURCE				! Allow up to 132 characters per line in this module.    	SUBROUTINE	CHECK_MAIL(VERSION)    ************************************************************************************************************************************ *																   *  *  This subroutine checks to see if another user has read the mail you sent.  You will get a list of time received and subject for * *  any messages you sent that have not been read.  Designated users are able to get information about all un-read messages for the *$ *  specified user.														   * *																   *  *  Symbolic offsets into records in MAIL.MAI are not be available as of this writing.  All offsets are hard-coded into this	   *_ *  subroutine, and all relationships between fields have been empirically determined.						   *  *																   * = *  This subroutine must be linked with UAIDEF.											   *  *																   *  ************************************************************************************************************************************   	IMPLICIT INTEGER (A-Z)    C  The following symbols are used by DEC in VMS MAIL, and are included here to facilitate program revisions in the event the symbol  C  values are changed.  There is no such module as MAILDEF, and DEC reserves the right to modify the structure of MAIL.MAI when theyK C  so choose.  Other symbols are defined, but are not used in this program.    	PARAMETER	MMH_C_FROM=0  	PARAMETER	MMH_C_SUBJ=2  	PARAMETER	MMH_C_CC=3    	PARAMETER	MMH_M_EXTMSG=8    	INTEGER*2	MMH_W_FLAGS   	STRUCTURE	/ITEM_LIST_DEF/K 	  STRUCTURE	/FORM_OF_ITEM_REQUEST/	BLOCK(2)	! Two items in this item list. 7 	    INTEGER*2	BUFFER_LENGTH				! Length of the buffer. - 	    INTEGER*2	ITEM_CODE				! Item requested. ] 	    INTEGER*4	BUFFER_ADDRESS				! Buffer from which data is read, or to which it is written. H 	    INTEGER*4	RETURN_LENGTH_ADDRESS			! Length of returned information. 	  END STRUCTURED 	  INTEGER*4	%FILL					! Longword with zero terminates the itemlist. 	END STRUCTURE! 	RECORD		/ITEM_LIST_DEF/ITEM_LIST   H 	CHARACTER	ASCII_TIME*23				! Time at which a mail message was received.B 	CHARACTER	CURRENT_USER*12				! Name of user running this routine.: 	CHARACTER	DEFDEV*16				! Mail recipient's default device.= 	CHARACTER	DEFDIR*64				! Mail recipient's default directory. f 	CHARACTER	EXTERNAL_MAIL_FILENAME*25		! External VMS file containing mail message and forwarding info.P 	CHARACTER	FORWARDING_ADDRESS*80			! Forwarding address set in the MAIL utility.I 	CHARACTER	FROM*255				! In MAIL.MAI; username who sent the mail message. R 	CHARACTER	LINE*80					! Contains equal signs (=) for delimitter between messages.T 	CHARACTER	MAIL_FILENAME*132/' '/			! Complete filename of the recipients mail file.O 	CHARACTER	RECIPIENT*12				! Username of person who has received mail messages. E 	CHARACTER	SUBDIR*80				! Mail sub-directory set in the MAIL utility. ? 	CHARACTER	USERMAIL_TEXT*2048			! Text of the user's mail file. = 	CHARACTER	VMSMAIL_TEXT*132			! Text of the system mail file.   O 	INTEGER*2	SUBDIR_LEN				! Number of characters in the mail sub-directory name. . 	INTEGER*2	L1					! Word argument to STR$TRIM.  V 	INTEGER*4	NUMERIC_MAIL_FILENAME(2)		! The numeric portion of external mail filenames.  S 	LOGICAL		DESIGNATED_USER				! Set TRUE when the current user is a designated user. Q 	LOGICAL		FOUND					! Set TRUE if some messages that you sent have not been read.   = 	INCLUDE		'($FORIOSDEF)'				! FORTRAN I/O Status Definitions.   E 	EXTERNAL	JPI$_USERNAME				! Used to get the current user's username. * 	EXTERNAL	UAI$_DEFDEV				! Default device.- 	EXTERNAL	UAI$_DEFDIR				! Default directory.   \ C  Make a string of 80 dash characters that will be used to separage portions of the output.  ( 	STATUS=STR$DUPL_CHAR(LINE,80,%REF('='))   C  End of declarations.   [ C  Determine if the current user is one of the designated users identified in this routine.   R 	STATUS=LIB$GETJPI(%LOC(JPI$_USERNAME),,,,CURRENT_USER)	! Current user's username.q 	IF(STR$FIND_FIRST_SUBSTRING(CURRENT_USER,SRC_STR_INDEX,SUB_STR_INDEX,'SYSTEM','ALAN'))THEN	! Modify as required.  	  DESIGNATED_USER=.TRUE.  	ELSE  	  DESIGNATED_USER=.FALSE. 	END IF*  8 C  Determine the user whose mail file you want to check.  @ 	STATUS=CLI$GET_VALUE('RECIPIENT',RECIPIENT,LENGTH_OF_RECIPIENT)  } C  Invoke the GETUAI system service to return the default device and directory for that user.  Begin by filling the itemlist.s  h 	ITEM_LIST.BLOCK(1).BUFFER_LENGTH=16			! Default device; first byte is number of significant characters./ 	ITEM_LIST.BLOCK(1).ITEM_CODE=%LOC(UAI$_DEFDEV)	/ 	ITEM_LIST.BLOCK(1).BUFFER_ADDRESS=%LOC(DEFDEV)	+ 	ITEM_LIST.BLOCK(1).RETURN_LENGTH_ADDRESS=0.  k 	ITEM_LIST.BLOCK(2).BUFFER_LENGTH=64			! Default directory; first byte is number of significant characters.E/ 	ITEM_LIST.BLOCK(2).ITEM_CODE=%LOC(UAI$_DEFDIR)	/ 	ITEM_LIST.BLOCK(2).BUFFER_ADDRESS=%LOC(DEFDIR)s+ 	ITEM_LIST.BLOCK(2).RETURN_LENGTH_ADDRESS=0   S 	STATUS=SYS$GETUAI(,,RECIPIENT,ITEM_LIST,,,)		! Get user authorization information.s  , 	IF(.NOT.STATUS)THEN					! Invalid username.$ 	  TYPE '(/X,A)','Invalid username.'2 	  RETURN						! Return to the command dispatcher. 	END IFo  d 	DEFDEV_LENGTH=ICHAR(DEFDEV(1:1))			! Number of significant characters in the default device string.g 	DEFDIR_LENGTH=ICHAR(DEFDIR(1:1))			! Number of significant characters in the default directory string.p  > C  Complete the mail filename by checking for a sub-directory.   	STATUS=LIB$GET_LUN(LUN1)i 	IF(VERSION.EQ.4)THENas 	  OPEN(UNIT=LUN1,FILE='SYS$SYSTEM:VMSMAIL.DAT',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',SHARED,READONLY)  	ELSE IF(VERSION.EQ.5)THEN| 	  OPEN(UNIT=LUN1,FILE='SYS$SYSTEM:VMSMAIL_PROFILE.DATA',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',SHARED,READONLY) 	END IF    	VMSMAIL_TEXT=' ' : 	READ(LUN1,KEYID=0,KEYEQ=RECIPIENT,IOSTAT=IOS)VMSMAIL_TEXT 	CLOSE(UNIT=LUN1)   N 	CALL PROCESS_SYSTEM_MAIL_FILE(VERSION,VMSMAIL_TEXT,SUBDIR,FORWARDING_ADDRESS)  A 	IF(SUBDIR.EQ.' ')THEN					! No sub-directory has been specified. Q 	  MAIL_FILENAME=DEFDEV(2:DEFDEV_LENGTH+1)//DEFDIR(2:DEFDIR_LENGTH+1)//'MAIL.MAI' 1 	ELSE							! A sub-directory has been specified. , 	  STATUS=STR$TRIM(SUBDIR,SUBDIR,SUBDIR_LEN)e 	  MAIL_FILENAME=DEFDEV(2:DEFDEV_LENGTH+1)//DEFDIR(2:DEFDIR_LENGTH)//SUBDIR(1:SUBDIR_LEN)//'MAIL.MAI'  	END IF   ~ C  Open the recipient's mail file.  If it cannot be opened, issue an appropriate message and return to the command dispatcher.  Z 	OPEN(UNIT=LUN1,FILE=MAIL_FILENAME,ACCESS='KEYED',STATUS='OLD',SHARED,READONLY,IOSTAT=IOS)5 	IF(IOS.NE.0)THEN					! Could not open the mail file. * 	  STATUS=STR$TRIM(RECIPIENT,RECIPIENT,L1)Y 	  TYPE '(/X,2A)',RECIPIENT(1:L1),'''s mail file does not exist, or could not be opened.'  	  STATUS=LIB$FREE_LUN(LUN1)2 	  RETURN						! Return to the command dispatcher. 	END IF    C  Open the recipient's mail file a second time with a separate logical unit.  This is necessary to track the forwarding history of  C  "short" mail messages (those stored in MAIL.MAI as opposed to external message files) without corrupting the NEWMAIL next-record  C  pointer.    	STATUS=LIB$GET_LUN(LUN2) Z 	OPEN(UNIT=LUN2,FILE=MAIL_FILENAME,ACCESS='KEYED',STATUS='OLD',SHARED,READONLY,IOSTAT=IOS)  } C  Read the mail file.  Only display information about messages that the current user has sent.  Designated users may see all  C  messages sent to all users.  CURRENT_USER is the current user's username.  Depending upon the length of the Mail text, either one C  or two records exist within MAIL.MAI for each message.  The first record (the Mail Message Header, or MMH) contains "NEWMAIL" in  C  the primary key position (byte position 10:16), the fields "To, From, CC, and Subject", the key value to reference the second C  record (the Mail Message Descriptor Block, or MMB) or the external message file, and the number of records required to display  C  this mail message.  For "short" messages, the second record contains the forwarding history and the message text.  For "long" C  messages, the second record will not exist; instead, bytes 57:64 of the first record indicate the name of the external file in M C  which the mail message text and forwarding information (if any) is stored.  C + C  The format of the first record (MMH) is: J C    Bytes 1:8 are the quadword system time when the message was received. C    Bytes 49:50 is a flags word-mask that indicates (among other things) if the message is stored in an external message file. k C    Bytes 57:64 contain the primary key value to reference the second record or the external message file. 7 C    Beginning in byte 65, a repeating sequence exists: p C      a word (2 bytes) indicating the type of field that follows (From, To, cc, Subject, message record count),; C      a word (2 bytes) indicating the length of the field,  C      the text of the field.  C , C  The format of the second record (MMB) is:7 C    Beginning in byte 49, a repeating sequence exists: ; C      a word (2 bytes) indicating the length of the field,  C      the text of the field. t C    The only way to determine forwarding information is if the field begins with "From:", "To:", "CC:", or "Subj:". C  C  The external message file is a sequential file.  The forwarding history precedes the text, and each line of it begins with either% C  "From:", "To:", "CC:", or "Subj:".   - 	FOUND=.FALSE.						! Initialize this symbol. 	 	FROM=' '  	USERMAIL_TEXT=' 'l 	READ(LUN1,KEYID=1,KEYEQ='NEWMAIL',IOSTAT=IOS)USERMAIL_TEXT	! Read the first NEWMAIL message (if any exist).W 	DO WHILE((IOS.EQ.0.OR.IOS.EQ.FOR$IOS_INPSTAREQ).AND.USERMAIL_TEXT(10:16).EQ.'NEWMAIL') v 	  STATUS=LIB$MOVC3(2,%REF(USERMAIL_TEXT(49:50)),MMH_W_FLAGS)	! MMH_W_FLAGS will be checked to see if message is in anE   									! external message file.  Required for forwarding history. 2 	  POS=65						! Beginning of the first TLD field.A 	  STATUS=LIB$MOVC3(2,%REF(USERMAIL_TEXT(POS:POS+1)),PACKET_TYPE) B 	  STATUS=LIB$MOVC3(2,%REF(USERMAIL_TEXT(POS+2:POS+3)),PACKET_LEN)  ] 	  IF(PACKET_TYPE.EQ.MMH_C_FROM)THEN			! Determine if the message is "From" the current user. / 	    FROM=USERMAIL_TEXT(POS+4:POS+PACKET_LEN+3) T 	    J=INDEX(FROM,'::')					! If DECnet is running, locate the end of the node name.f 	    IF(J.NE.0)FROM=FROM(J+2:)				! This is the username only, without the node name or personal name.	 	  END IF   \ 	  IF(FROM.EQ.CURRENT_USER.OR.DESIGNATED_USER)THEN	! Display information about this message.? 	    FOUND=.TRUE.					! One or more messages will be displayed.   l 	    DO WHILE(USERMAIL_TEXT(POS:).NE.' ')		! Text is removed from this variable after is has been displayed.< 	      IF(PACKET_TYPE.EQ.MMH_C_FROM)THEN			! A "From" field.P 		TYPE '(/X,A//X,3A)',LINE,'From:',CHAR(9),USERMAIL_TEXT(POS+4:POS+PACKET_LEN+3)  A 	      ELSE IF(PACKET_TYPE.EQ.MMH_C_SUBJ)THEN		! A "Subj:" field. 3 		IF(PACKET_LEN.LT.72)THEN			! Short subject field. @ 		  TYPE *,'Subj:',CHAR(9),USERMAIL_TEXT(POS+4:POS+PACKET_LEN+3)G 		ELSE						! Long subject field; may be max value of a word in length. [ 		  TYPE '(X,3A/X,2A)','Subj:',CHAR(9),USERMAIL_TEXT(POS+4:POS+75),CHAR(9),'(more follows)'  		END IF  X 	      ELSE IF(PACKET_TYPE.EQ.MMH_C_CC)THEN		! This is implmented in VMS Version 5 only.l 		IF(USERMAIL_TEXT(POS+4:POS+PACKET_LEN+3).NE.' ')TYPE *,'cc:',CHAR(9),USERMAIL_TEXT(POS+4:POS+PACKET_LEN+3)
 	      END IF   A 	      POS=POS+PACKET_LEN+4				! Beginning of the next TLD field. E 	      STATUS=LIB$MOVC3(2,%REF(USERMAIL_TEXT(POS:POS+1)),PACKET_TYPE) F 	      STATUS=LIB$MOVC3(2,%REF(USERMAIL_TEXT(POS+2:POS+3)),PACKET_LEN) 	    END DO   7 C  Display the time at which this message was received.   = 	    STATUS=SYS$ASCTIM(,ASCII_TIME,%REF(USERMAIL_TEXT(1:8)),) & 	    TYPE *,'Time:',CHAR(9),ASCII_TIME   C  If this message has been forwarded, write the forwarding history to the screen.  If MMH_M_EXTMSG is not set, then the forwarding  C  history (if any) is in the second record in MAIL.MAI.  The second record has a primary key value equal to bytes (57:64) of the  C  first record.  K 	    IF(IAND(MMH_W_FLAGS,MMH_M_EXTMSG).EQ.0)THEN		! Message is in MAIL.MAI.  	      USERMAIL_TEXT(65:)=' ' S 	      READ(LUN2,KEYID=0,KEYEQ=%REF(USERMAIL_TEXT(57:64)),IOSTAT=IOS2)USERMAIL_TEXT06 	      POS=49						! Beginning of the first TLD field.  D 	      STATUS=LIB$MOVC3(2,%REF(USERMAIL_TEXT(POS:POS+1)),PACKET_LEN)m 	      IF(USERMAIL_TEXT(POS+2:POS+6).EQ.'From:')THEN	! Do not display text portion of non-forwarded messages.  		DO WHILE(PACKET_LEN.NE.0) b 		  IF(USERMAIL_TEXT(POS+2:POS+6).EQ.'From:')TYPE *	! Precede the "From:" field with a blank line.  . 		  IF(PACKET_LEN.LE.72)THEN			! Short fields.2 		    TYPE *,USERMAIL_TEXT(POS+2:POS+PACKET_LEN+1)G 		  ELSE						! Fields that are longer than necessary for this program.RC 		    TYPE '(X,A/X,A)',USERMAIL_TEXT(POS+2:POS+79),'(more follows)'e
 		  END IF  > 		  POS=POS+PACKET_LEN+2				! Beginning of the next TLD field.A 		  STATUS=LIB$MOVC3(2,%REF(USERMAIL_TEXT(POS:POS+1)),PACKET_LEN)c  n 		  IF(PACKET_LEN.EQ.0.AND.USERMAIL_TEXT(POS+4:POS+8).EQ.'From:')THEN	! Second, third, etc. forwarding format. 		    POS=POS+26C 		    STATUS=LIB$MOVC3(2,%REF(USERMAIL_TEXT(POS:POS+1)),PACKET_LEN) 
 		  END IF 		END DO
 	      END IFI  } C  If MMH_M_EXTMSG is set, this message is stored in an external message file.  The filename can be determined by using bytes./ C  (57:64) of the first (MMH) mail file record.e  7 	    ELSE						! Read data from the external text file..K 	      STATUS=LIB$MOVC3(8,%REF(USERMAIL_TEXT(57:64)),NUMERIC_MAIL_FILENAME)sr 	      WRITE(EXTERNAL_MAIL_FILENAME,'(A,2Z8.8,A)')'MAIL$',NUMERIC_MAIL_FILENAME(2),NUMERIC_MAIL_FILENAME(1),'.MAI': 	      STATUS=STR$TRIM(MAIL_FILENAME,MAIL_FILENAME,LENGTH)   C  Get a logical unit, and open the external message file.  If it has been deleted, or cannot be opened for any other reason, this. C  program simply ignores it and continues on.   	      STATUS=LIB$GET_LUN(LUN3)Io 	      OPEN(UNIT=LUN3,FILE=MAIL_FILENAME(1:LENGTH-8)//EXTERNAL_MAIL_FILENAME,STATUS='OLD',READONLY,IOSTAT=IOS3) @ 	      IF(IOS3.EQ.0)THEN					! The file was opened successfully.4 		READ(LUN3,'(Q,A)',IOSTAT=IOS3)LENGTH,USERMAIL_TEXT@ 		DO WHILE(IOS3.EQ.0.AND.USERMAIL_TEXT(1:6).EQ.'From:'//CHAR(9))D 		  TYPE '(/X,A)',USERMAIL_TEXT(1:LENGTH)		! Type the "From:" field.   C  After typing the "From:" field, there are 2 additional lines in VMS Version 4 ("To:" and "Subj:"), and 3 additional lines in } C  VMS Version 5 ("To:", "CC:", and "Subj:").  In the future, DEC may add additional fields, and this section will need to beI C  modified.   		  IF(VERSION.EQ.4)THEN5 		    NUM_LINES=2					! No cc: list in VMS Version 4.e 		  ELSEI 		    NUM_LINES=3					! cc: list is included in VMS Version 5 mail files.I
 		  END IF  < 		  DO I=1,NUM_LINES				! Type the To, CC, and Subj. fields.8 		    READ(LUN3,'(Q,A)',IOSTAT=IOS3)LENGTH,USERMAIL_TEXT$ 		    TYPE *,USERMAIL_TEXT(1:LENGTH)
 		  END DO  7 		  READ(LUN3,'(/Q,A)',IOSTAT=IOS3)LENGTH,USERMAIL_TEXTO 		END DO5 		CLOSE(UNIT=LUN3)				! Close the external mail file.a
 	      END IFa  	      STATUS=LIB$FREE_LUN(LUN3) 	    END IFE	 	  END IF,   	  FROM=' 'A 	  USERMAIL_TEXT=' '\ 	  READ(LUN1,IOSTAT=IOS)USERMAIL_TEXT			! Read the next NEWMAIL message (if any more exist). 	END DO=  L 	CLOSE(UNIT=LUN1)					! Close the recipient's mail file, unformatted access.J 	CLOSE(UNIT=LUN2)					! Close the recipient's mail file, formatted access. 	STATUS=LIB$FREE_LUN(LUN1) 	STATUS=LIB$FREE_LUN(LUN2)  X C  If no un-read messages from the current user were found, type an appropriate message.   	IF(FOUND)THEN 	  TYPE '(/X,A)',LINEo 	ELSE 8 	  TYPE '(/X,A)','All messages you sent have been read.' 	END IFt  K C  Notify this user if the recipient has forwarded mail to another account.   " 	IF(FORWARDING_ADDRESS.NE.' ')THENN 	  STATUS=STR$TRIM(FORWARDING_ADDRESS,FORWARDING_ADDRESS,LENGTH_OF_FORWARDING){ 	  TYPE '(2(/X,3A))',RECIPIENT(1:LENGTH_OF_RECIPIENT),' has forwarded mail to ',FORWARDING_ADDRESS(1:LENGTH_OF_FORWARDING),e_ 	1 'Check ',FORWARDING_ADDRESS(1:LENGTH_OF_FORWARDING),' for additional un-read mail messages.'p 	END IFn  1 	RETURN							! Return to the command dispatcher.x 	END nQ 	OPTIONS		/EXTEND_SOURCE				! Allow up to 132 characters per line in this module.t  " 	SUBROUTINE	CLEAN_VMSMAIL(VERSION)   ************************************************************************************************************************************ *																   *r *  Deleting a username from SYSUAF.DAT does not remove the username from the system mail file.  Subsequently, if a user is added   * *  with that same name, an erroneous value for the number of newmailmessages may be displayed.  This routine deletes records in	   * *  the system mail file for which there is no match in SYSUAF.DAT, and may be run at any time by designated users as defined in	   *" *  this routine.														   * *																   *r ************************************************************************************************************************************   	IMPLICIT INTEGER (A-Z)s  j 	PARAMETER	LOG_FILENAME='SITE_UTILITY:VMSMAIL.DEL'	! Logs the usernames removed from the system mail file.  9 	CHARACTER	CURRENT_USER*12				! Name of the current user. ? 	CHARACTER	TODAY*23				! Date and time this routine is running.rD 	CHARACTER	USERNAME*31				! Username read from the system mail file.  E 	EXTERNAL	JPI$_USERNAME				! Used to get the current user's username.n   C  End of declarations.t t C  Determine if the current user is one of the designated users identified in this routine.  If so, continue.  If not, return to8 C  the command dispatcher with an informational message.  R 	STATUS=LIB$GETJPI(%LOC(JPI$_USERNAME),,,,CURRENT_USER)	! Current user's username.v 	IF(.NOT.STR$FIND_FIRST_SUBSTRING(CURRENT_USER,SRC_STR_INDEX,SUB_STR_INDEX,'SYSTEM','ALAN'))THEN	! Modify as required.Q 	  TYPE '(/X,A)','You must be one of the designated users to select this option.' 2 	  RETURN						! Return to the command dispatcher. 	END IF	   C  Determine the current date and time.  If a record is deleted from the system mail file, it is appropriate to record the date, C  time, and user who was running this routine.  Open the three data files:  the system mail file, SYSUAF, and the file to contain C  the list of removed records.E  8 	STATUS=LIB$DATE_TIME(TODAY)				! Current date and time.   	STATUS=LIB$GET_LUN(LUN1)	 	STATUS=LIB$GET_LUN(LUN2)  	STATUS=LIB$GET_LUN(LUN3)s   	IF(VERSION.EQ.4)THENBj 	  OPEN(UNIT=LUN1,FILE='SYS$SYSTEM:VMSMAIL.DAT',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',SHARED) 	ELSE IF(VERSION.EQ.5)THENs 	  OPEN(UNIT=LUN1,FILE='SYS$SYSTEM:VMSMAIL_PROFILE.DATA',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',SHARED)u 	END IFr  p 	OPEN(UNIT=LUN2,FILE='SYS$SYSTEM:SYSUAF.DAT',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',SHARED,READONLY)Z 	OPEN(UNIT=LUN3,FILE=LOG_FILENAME,STATUS='UNKNOWN',ACCESS='APPEND',CARRIAGECONTROL='LIST')   C  Read an entry from the system mail file, then try to read the corresponding entry from SYSUAF.DAT.  If an entry is found, nothing~ C  happens.  If a UAF entry is not found, the entry in the system mail file is deleted.  This continues for all entries in the C  system mail file.  2 	STATUS=STR$TRIM(CURRENT_USER,CURRENT_USER,LENGTH)j 	READ(LUN1,KEYID=0,KEYGE=CHAR(0),IOSTAT=IOS1)USERNAME	! Read the first username from the system mail file. 	DO WHILE(IOS1.EQ.0)c 	  READ(LUN2,KEYID=0,KEYEQ=USERNAME,IOSTAT=IOS2)		! Try to read the corresponding SYSUAF.DAT entry.t2 	  IF(IOS2.NE.0)THEN					! SYSUAF entry not found.? 	    DELETE(UNIT=LUN1)					! Remove the system mail file entry. } 	    WRITE(LUN3,'(2A,3X,A,3X,2A)')'System mail file entry deleted: ',USERNAME(1:12),TODAY(1:17),'by: ',CURRENT_USER(1:LENGTH)w	 	  END IF   W 	  READ(LUN1,IOSTAT=IOS1)USERNAME			! Read the next username from the system mail file.l 	END DOU  C 	TYPE '(/X,2A)','Log filename of deleted records is: ',LOG_FILENAMEI   	CLOSE(UNIT=1) 	CLOSE(UNIT=2) 	CLOSE(UNIT=3) 	STATUS=LIB$FREE_LUN(LUN1) 	STATUS=LIB$FREE_LUN(LUN2) 	STATUS=LIB$FREE_LUN(LUN3)  1 	RETURN							! Return to the command dispatcher.  	END S  	SUBROUTINE	NORMAL_EXIT(VERSION)   ************************************************************************************************************************************ *																   *( *  This routine provides normal image rundown and returns the operator to VAX/VMS DCL.  Other commands may be entered here if	   * *  required. *																   *t ************************************************************************************************************************************   	TYPE * 
 	CALL EXIT  N 	RETURN							! This line is never executed, but is included for completeness. 	END  Q 	OPTIONS		/EXTEND_SOURCE				! Allow up to 132 characters per line in this module.)   	SUBROUTINE	HELP(VERSION)    ************************************************************************************************************************************ *																   *OE *  Provide HELP for the commands used in these routines.									   *s *																   *E ************************************************************************************************************************************   	IMPLICIT	INTEGER (A-Z).  5 	PARAMETER	HELP_LIBRARY_NAME='SITE_UTILITY:XMAIL.HLB'5  F 	CHARACTER	HELP_TOPIC*80				! Topic for which HELP has been requested.  I 	EXTERNAL	LIB$GET_INPUT				! Address of input routine for help prompting.sP 	EXTERNAL	LIB$PUT_OUTPUT				! Address of the output routine for LBR$OUTPUT_HELP.  0 	INCLUDE		'($HLPDEF)'				! VMS Help definitions.  = C  The return status of CLI$GET_VALUE is not checked because: b C  a.  if STATUS=CLI$_PRESENT, help information about the requested subject will be displayed, and\ C  b.  if STATUS=CLI$_ABSENT, the main help information and list of items will be displayed.  q 	STATUS=CLI$GET_VALUE('HELP_TOPIC',HELP_TOPIC)		! Determine if an item of help was requested on the command line.   U C  Lookup help text in the VMS-formatted Help library and display it on the terminal.x  k 	STATUS=LBR$OUTPUT_HELP(LIB$PUT_OUTPUT,,HELP_TOPIC,HELP_LIBRARY_NAME,HLP$M_HELP+HLP$M_PROMPT,LIB$GET_INPUT)s  1 	RETURN							! Return to the command dispatcher.  	END  Q 	OPTIONS		/EXTEND_SOURCE				! Allow up to 132 characters per line in this module.e  / 	SUBROUTINE	NUMBER_OF_NEWMAIL_MESSAGES(VERSION)w   ************************************************************************************************************************************ *																   *i *  Determine the number of mail messages, as recorded in the system mail file, that have not been read by a given user or all	   *k *  users.  This option may only be selected by designated users within the context of this routine.				   *	 *																   *	 ************************************************************************************************************************************   	IMPLICIT INTEGER (A-Z)*  9 	CHARACTER	CURRENT_USER*12				! Name of the current user.*N 	CHARACTER	OUTPUT_FILENAME*80			! File to which output is optionally directed.M 	CHARACTER	USERNAME*12				! Name of user whose newmail count will be checked.A= 	CHARACTER	VMSMAIL_TEXT*132			! Text of the system mail file.S  ] 	INTEGER*2	NUM_MESSAGES				! Number of new mail messages as recorded in the system mail file.	  = 	INCLUDE		'($FORIOSDEF)'				! Fortran I/O Status Definitions.   E 	EXTERNAL	JPI$_USERNAME				! Used to get the current user's username.r   C  End of declarations.t c C  Determine if the current user is one of the designated users identified in this routine.  If so, continue.  If not, return to8 C  the command dispatcher with an informational message.  R 	STATUS=LIB$GETJPI(%LOC(JPI$_USERNAME),,,,CURRENT_USER)	! Current user's username.v 	IF(.NOT.STR$FIND_FIRST_SUBSTRING(CURRENT_USER,SRC_STR_INDEX,SUB_STR_INDEX,'SYSTEM','ALAN'))THEN	! Modify as required.Q 	  TYPE '(/X,A)','You must be one of the designated users to select this option.'o2 	  RETURN						! Return to the command dispatcher. 	END IFs  l C  Determine if the output will be sent to a file or to the terminal screen, then open the system mail file.  ] 	IF(CLI$PRESENT('OUTPUT'))THEN				! If the qualifier /OUTPUT was specified, get the filespec.(1 	  STATUS=CLI$GET_VALUE('OUTPUT',OUTPUT_FILENAME)  	  STATUS=LIB$GET_LUN(LUN1) ^ 	  OPEN(UNIT=LUN1,FILE=OUTPUT_FILENAME,DEFAULTFILE='.LIS',STATUS='NEW',CARRIAGECONTROL='LIST')6 	ELSE							! The qualifier /OUTPUT was not specified.- 	  LUN1=6						! Default output logical unit.	 	END IFr   	STATUS=LIB$GET_LUN(LUN2)A 	IF(VERSION.EQ.4)THENM 	  POS_NUM_MAIL=34s 	  OPEN(UNIT=LUN2,FILE='SYS$SYSTEM:VMSMAIL.DAT',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',SHARED,READONLY)_ 	ELSE IF(VERSION.EQ.5)THEN 	  POS_NUM_MAIL=36| 	  OPEN(UNIT=LUN2,FILE='SYS$SYSTEM:VMSMAIL_PROFILE.DATA',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',SHARED,READONLY) 	END IF	  T C  If the newmail count is to be read for all users, do so in the following section.  A 	IF(CLI$PRESENT('ALL'))THEN				! The parameter ALL was specified. d 	  READ(LUN2,KEYID=0,KEYGE=CHAR(0),IOSTAT=IOS)VMSMAIL_TEXT	! First username in the system mail file.   	  WRITE(LUN1,'()')t 	  DO WHILE(IOS.NE.-1)U 	    STATUS=LIB$MOVC3(2,%REF(VMSMAIL_TEXT(POS_NUM_MAIL:POS_NUM_MAIL+1)),NUM_MESSAGES) 9 	    WRITE(LUN1,'(X,A,I)')VMSMAIL_TEXT(1:12),NUM_MESSAGESeQ 	    READ(LUN2,IOSTAT=IOS)VMSMAIL_TEXT			! Next username in the system mail file.c	 	  END DOL  X C  If the newmail count is to be read for only one user, do so in the following section.   	ELSEn^ 	  IF(.NOT.CLI$GET_VALUE('USERNAME',USERNAME))THEN	! The parameter USERNAME was not specified.H 	    TYPE '(/X,A)','A username or the /ALL qualifier must be specified.'Z 	    IF(LUN1.NE.6)CLOSE(UNIT=LUN1)			! Cleanup resoureces if an output file was specified. 	    STATUS=LIB$FREE_LUN(LUN1) 	    CLOSE(UNIT=LUN2)* 	    STATUS=LIB$FREE_LUN(LUN2)4 	    RETURN						! Return to the command dispatcher.	 	  END IF   ( C  The parameter USERNAME was specified.  ; 	  READ(LUN2,KEYID=0,KEYEQ=USERNAME,IOSTAT=IOS)VMSMAIL_TEXTrN 	  IF(IOS.EQ.FOR$IOS_ATTACCNON)THEN			! Attempt to access non-existent record.V 	    WRITE(LUN1,'(/X,2A)')'System mail entry not found; try Xmail/Reset for ',USERNAME 	  ELSE							! Valid username.CU 	    STATUS=LIB$MOVC3(2,%REF(VMSMAIL_TEXT(POS_NUM_MAIL:POS_NUM_MAIL+1)),NUM_MESSAGES) 0 	    WRITE(LUN1,'(/X,A,I)')USERNAME,NUM_MESSAGES	 	  END IFS 	END IF/  W 	IF(LUN1.NE.6)CLOSE(UNIT=LUN1)				! Cleanup resoureces if an output file was specified.H 	STATUS=LIB$FREE_LUN(LUN1) 	CLOSE(UNIT=LUN2)E 	STATUS=LIB$FREE_LUN(LUN2)  1 	RETURN							! Return to the command dispatcher.h 	END rQ 	OPTIONS		/EXTEND_SOURCE				! Allow up to 132 characters per line in this module.f  " 	SUBROUTINE	RESET_NEWMAIL(VERSION)   ************************************************************************************************************************************ *																   *i *  This routine correctly resets a user's new mail count.  You must be a designated user of this routine to reset another user's   *W *  newmail count.  No privilege is required to reset your own newmail count.							   *r *																   *T *  If the qualifier /ZERO is specified, the newmail count will be forced to zero, regardless of the true value.  This is useful	   *E *  in the most difficult cases of mail file corruption.										   *M *																   *h ************************************************************************************************************************************   	IMPLICIT INTEGER (A-Z)t  9 	CHARACTER	CURRENT_USER*12				! Name of the current user.mK 	CHARACTER	USERNAME*12				! Name of user whose newmail count will be reset.s= 	CHARACTER	VMSMAIL_TEXT*132			! Text of the system mail file.T  B 	LOGICAL		ALL_REQUESTED				! Set if the qualifier /ALL is present.S 	LOGICAL		NEW_USERNAME				! Set if username does not exist in the system mail file. X 	LOGICAL		RESET					! Set when the newmail count in the system mail file has been reset.  ] 	INTEGER*2	NUM_MESSAGES				! Number of new mail messages as recorded in the system mail file.Ic 	INTEGER*2	PREV_NUM_MESSAGES			! Number of new mail messages previously recorded in sys. mail file.E  = 	INCLUDE		'($FORIOSDEF)'				! Fortran I/O Status Definitions.	  E 	EXTERNAL	JPI$_USERNAME				! Used to get the current user's username.E1 	EXTERNAL	SS$_NORMAL				! Normal completion code.    C  End of declarations.! fe C  Determine who is running this routine, then determine the user whose newmail count is to be reset.t  ! 	ALL_REQUESTED=CLI$PRESENT('ALL') R 	STATUS=LIB$GETJPI(%LOC(JPI$_USERNAME),,,,CURRENT_USER)	! Current user's username.X 	IF(.NOT.ALL_REQUESTED.AND..NOT.CLI$GET_VALUE('USERNAME',USERNAME))USERNAME=CURRENT_USER   C  Determine if one of the designated users for this routine is the current user.  If so, continue.  If not, return to the command, C  dispatcher with an informational message.  2 	IF(USERNAME.NE.CURRENT_USER.OR.ALL_REQUESTED)THENx 	  IF(.NOT.STR$FIND_FIRST_SUBSTRING(CURRENT_USER,SRC_STR_INDEX,SUB_STR_INDEX,'SYSTEM','ALAN'))THEN ! Modify as required.S 	    TYPE '(/X,A)','You must be one of the designated users to select this option.'A4 	    RETURN						! Return to the command dispatcher.	 	  END IF8 	END IFm  c C  Open the system mail file FORMATTED so the record length can be determined for rewrite purposes.A   	STATUS=LIB$GET_LUN(LUN1)N 	IF(VERSION.EQ.4)THENO 	  POS_NUM_MAIL=34{ 	  OPEN(UNIT=LUN1,FILE='SYS$SYSTEM:VMSMAIL.DAT',FORM='FORMATTED',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',SHARED)* 	ELSE IF(VERSION.EQ.5)THEN 	  POS_NUM_MAIL=36} 	  OPEN(UNIT=LUN1,FILE='SYS$SYSTEM:VMSMAIL_PROFILE.DATA',FORM='FORMATTED',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',*
 	1 SHARED) 	END IF*  H C  Open SYSUAF.DAT to determine if the username entered is really valid.   	STATUS=LIB$GET_LUN(LUN2)Ep 	OPEN(UNIT=LUN2,FILE='SYS$SYSTEM:SYSUAF.DAT',ORGANIZATION='INDEXED',ACCESS='KEYED',STATUS='OLD',SHARED,READONLY)  = C  Reset the newmail count, or zero it out for a single user.s   	IF(.NOT.ALL_REQUESTED)THENpZ 	  READ(LUN2,KEYID=0,KEYEQ=USERNAME,IOSTAT=IOS2)		! Determine if this is a valid username.   	  IF(IOS2.NE.0)THEN" 	    TYPE '(/X,A)','No such user.' 	    CLOSE(UNIT=LUN1)_ 	    STATUS=LIB$FREE_LUN(LUN1) 	    CLOSE(UNIT=LUN2)R 	    STATUS=LIB$FREE_LUN(LUN2)4 	    RETURN						! Return to the command dispatcher. 	  ELSEIM 	    READ(LUN1,'(Q,A)',KEYID=0,KEYEQ=USERNAME,IOSTAT=IOS1)LENGTH,VMSMAIL_TEXTA 	    IF(IOS1.NE.0)THEN 	      NEW_USERNAME=.TRUE." 	      VMSMAIL_TEXT(1:31)=USERNAME   	      IF(VERSION.EQ.4)THENo. 		STATUS=STR$DUPL_CHAR(VMSMAIL_TEXT(32:),37,0) 	      ELSEtJ 		VMSMAIL_TEXT(32:37)=CHAR(1)//CHAR(0)//CHAR(2)//CHAR(0)//CHAR(0)//CHAR(0)
 	      END IFH   	      PREV_NUM_MESSAGES=0> 	      J1=2						! J1 is a variable used to format the output.	 	    ELSEO 	      NEW_USERNAME=.FALSE.l\ 	      STATUS=LIB$MOVC3(2,%REF(VMSMAIL_TEXT(POS_NUM_MAIL:POS_NUM_MAIL+1)),PREV_NUM_MESSAGES)% 	      IF(PREV_NUM_MESSAGES.EQ.0)THEN* 		J1=2 	      ELSE*' 		J1=ALOG10(FLOAT(PREV_NUM_MESSAGES))+2*
 	      END IF* 	    END IF*   C  If the qualifier /ZERO has been specified, reset the newmail count to zero, regardless of the true value.  Otherwise, count theA C  number of newmail messages that exist in the user's mail file.e    	    IF(CLI$PRESENT('ZERO'))THEN 	      NUM_MESSAGES=0u	 	    ELSE T 	      STATUS=COUNT_NEWMAIL(USERNAME,VERSION,VMSMAIL_TEXT,NUM_MESSAGES,POS_NUM_MAIL)C 	      IF(.NOT.STATUS)RETURN				! Return to the command dispatcher.* 	    END IFI  U 	    STATUS=LIB$MOVC3(2,NUM_MESSAGES,%REF(VMSMAIL_TEXT(POS_NUM_MAIL:POS_NUM_MAIL+1)))T  / 	    IF(NEW_USERNAME.AND.NUM_MESSAGES.EQ.0)THENp 	      RESET=.FALSE./ 	    ELSE IF(NEW_USERNAME.AND.VERSION.EQ.4)THENa* 	      WRITE(LUN1,'(A)')VMSMAIL_TEXT(1:68) 	      RESET=.TRUE.o/ 	    ELSE IF(NEW_USERNAME.AND.VERSION.EQ.5)THENE* 	      WRITE(LUN1,'(A)')VMSMAIL_TEXT(1:37) 	      RESET=.TRUE. 	 	    ELSEI0 	      REWRITE(LUN1,'(A)')VMSMAIL_TEXT(1:LENGTH) 	      RESET=.TRUE.A 	    END IFM   	    IF(RESET)THEN  	      IF(NUM_MESSAGES.EQ.0)THEN@ 	        J2=2						! J2 is a variable used to format the output. 	      ELSEa) 	        J2=ALOG10(FLOAT(NUM_MESSAGES))+2o
 	      END IF   q 	      TYPE '(/X,A,I<J1>,A,I<J2>,A)','Newmail count has been reset from',PREV_NUM_MESSAGES,' to',NUM_MESSAGES,'.',  	 	    ELSE	6 	      TYPE '(/X,2A)','Nothing to reset for ',USERNAME 	    END IF_	 	  END IFR  ) C  Reset the newmail count for all users.M   	ELSEr	 	  TYPE * g 	  READ(LUN2,KEYID=0,KEYGE=CHAR(0),IOSTAT=IOS2)DUMMY,USERNAME	! Read the first username from SYSUAF.DAT 5 	  DO WHILE(IOS2.NE.-1.AND.IOS2.NE.FOR$IOS_ATTACCNON) M 	    READ(LUN1,'(Q,A)',KEYID=0,KEYEQ=USERNAME,IOSTAT=IOS1)LENGTH,VMSMAIL_TEXTe 	    IF(IOS1.NE.0)THEN 	      NEW_USERNAME=.TRUE." 	      VMSMAIL_TEXT(1:31)=USERNAME   	      IF(VERSION.EQ.4)THENU. 		STATUS=STR$DUPL_CHAR(VMSMAIL_TEXT(32:),37,0) 	      ELSE_J 		VMSMAIL_TEXT(32:37)=CHAR(1)//CHAR(0)//CHAR(2)//CHAR(0)//CHAR(0)//CHAR(0)
 	      END IFC   	      PREV_NUM_MESSAGES=0> 	      J1=2						! J1 is a variable used to format the output.	 	    ELSEo 	      NEW_USERNAME=.FALSE.A\ 	      STATUS=LIB$MOVC3(2,%REF(VMSMAIL_TEXT(POS_NUM_MAIL:POS_NUM_MAIL+1)),PREV_NUM_MESSAGES)% 	      IF(PREV_NUM_MESSAGES.EQ.0)THENE 		J1=2 	      ELSET' 		J1=ALOG10(FLOAT(PREV_NUM_MESSAGES))+2R
 	      END IF  	    END IFI  R 	    STATUS=COUNT_NEWMAIL(USERNAME,VERSION,VMSMAIL_TEXT,NUM_MESSAGES,POS_NUM_MAIL) 	    IF(STATUS)THEN=W 	      STATUS=LIB$MOVC3(2,NUM_MESSAGES,%REF(VMSMAIL_TEXT(POS_NUM_MAIL:POS_NUM_MAIL+1)))d  1 	      IF(NEW_USERNAME.AND.NUM_MESSAGES.EQ.0)THENL 		RESET=.FALSE.p1 	      ELSE IF(NEW_USERNAME.AND.VERSION.EQ.4)THENK% 		WRITE(LUN1,'(A)')VMSMAIL_TEXT(1:68)F 		RESET=.TRUE.1 	      ELSE IF(NEW_USERNAME.AND.VERSION.EQ.5)THEND% 		WRITE(LUN1,'(A)')VMSMAIL_TEXT(1:37)C 		RESET=.TRUE. 	      ELSE_+ 		REWRITE(LUN1,'(A)')VMSMAIL_TEXT(1:LENGTH)I 		RESET=.TRUE.
 	      END IF1   	      IF(RESET)THEN 		IF(NUM_MESSAGES.EQ.0)THEN_; 		  J2=2						! J2 is a variable used to format the output.  		ELSE$ 		  J2=ALOG10(FLOAT(NUM_MESSAGES))+2 		END IF  q 		TYPE '(X,A,I<J1>,A,I<J2>,2A)','Newmail count has been reset from',PREV_NUM_MESSAGES,' to',NUM_MESSAGES,' for ',N 	1       USERNAMEe  s 	      ELSE IF(USERNAME.NE.'<System+Pass')THEN		! This record exists in SYSUAF.DAT if a system password is defined.e1 		TYPE '(/X,2A)','Nothing to reset for ',USERNAME 
 	      END IFRC 	    END IF						! End block IF for invalid username in SYSUAF.DAT.   T 	    READ(LUN2,IOSTAT=IOS2)DUMMY,USERNAME		! Read the next username from SYSUAF.DAT.	 	  END DOp 	END IF    	CLOSE(UNIT=LUN1)0 	STATUS=LIB$FREE_LUN(LUN1) 	CLOSE(UNIT=LUN2)( 	STATUS=LIB$FREE_LUN(LUN2)  1 	RETURN							! Return to the command dispatcher.I 	END (Q 	OPTIONS		/EXTEND_SOURCE				! Allow up to 132 characters per line in this module.	  X 	INTEGER FUNCTION COUNT_NEWMAIL(USERNAME,VERSION,VMSMAIL_TEXT,NUM_MESSAGES,POS_NUM_MAIL)   ************************************************************************************************************************************ *																   *iW *  This routine counts the number of newmail messages in a user's mail file.							   *L *																   *  ************************************************************************************************************************************   	IMPLICIT INTEGER (A-Z)S   	STRUCTURE	/ITEM_LIST_DEF/K 	  STRUCTURE	/FORM_OF_ITEM_REQUEST/	BLOCK(2)	! Two items in this item list.*7 	    INTEGER*2	BUFFER_LENGTH				! Length of the buffer. - 	    INTEGER*2	ITEM_CODE				! Item requested.a] 	    INTEGER*4	BUFFER_ADDRESS				! Buffer from which data is read, or to which it is written.lH 	    INTEGER*4	RETURN_LENGTH_ADDRESS			! Length of returned information. 	  END STRUCTURED 	  INTEGER*4	%FILL					! Longword with zero terminates the itemlist. 	END STRUCTURE! 	RECORD		/ITEM_LIST_DEF/ITEM_LISTe  0 	CHARACTER	DEFDEV*16				! User's default device.3 	CHARACTER	DEFDIR*64				! User's default directory.	P 	CHARACTER	FORWARDING_ADDRESS*80			! Forwarding address set in the MAIL utility.= 	CHARACTER	MAIL_FILENAME*132/' '/			! Complete Mail filename.*E 	CHARACTER	SUBDIR*80				! Mail sub-directory set in the MAIL utility. K 	CHARACTER	USERNAME*12				! Name of user whose newmail count will be reset.uS 	CHARACTER	USERMAIL_TEXT*80			! Text of the user's mail file (first 80 bytes only). = 	CHARACTER	VMSMAIL_TEXT*132			! Text of the system mail file.n  ] 	INTEGER*2	NUM_MESSAGES				! Number of new mail messages as recorded in the system mail file.L  = 	INCLUDE		'($FORIOSDEF)'				! Fortran I/O Status Definitions.h  E 	EXTERNAL	JPI$_USERNAME				! Used to get the current user's username.s1 	EXTERNAL	SS$_NORMAL				! Normal completion code.P* 	EXTERNAL	UAI$_DEFDEV				! Default device.- 	EXTERNAL	UAI$_DEFDIR				! Default directory.    C  End of declarations.	 o C  Locate the mail file, count the number of newmail messages, and return to the calling routine.  Invoke the GETUAI system serviceo\ C  to return the default device and directory for that user.  Begin by filling the itemlist.  h 	ITEM_LIST.BLOCK(1).BUFFER_LENGTH=16			! Default device; first byte is number of significant characters./ 	ITEM_LIST.BLOCK(1).ITEM_CODE=%LOC(UAI$_DEFDEV)R/ 	ITEM_LIST.BLOCK(1).BUFFER_ADDRESS=%LOC(DEFDEV)T+ 	ITEM_LIST.BLOCK(1).RETURN_LENGTH_ADDRESS=0)  k 	ITEM_LIST.BLOCK(2).BUFFER_LENGTH=64			! Default directory; first byte is number of significant characters. / 	ITEM_LIST.BLOCK(2).ITEM_CODE=%LOC(UAI$_DEFDIR)d/ 	ITEM_LIST.BLOCK(2).BUFFER_ADDRESS=%LOC(DEFDIR)S+ 	ITEM_LIST.BLOCK(2).RETURN_LENGTH_ADDRESS=0   + 	STATUS=SYS$GETUAI(,,USERNAME,ITEM_LIST,,,)R  d 	DEFDEV_LENGTH=ICHAR(DEFDEV(1:1))			! Number of significant characters in the default device string.g 	DEFDIR_LENGTH=ICHAR(DEFDIR(1:1))			! Number of significant characters in the default directory string.e  > C  Complete the mail filename by checking for a sub-directory.  N 	CALL PROCESS_SYSTEM_MAIL_FILE(VERSION,VMSMAIL_TEXT,SUBDIR,FORWARDING_ADDRESS)  A 	IF(SUBDIR.EQ.' ')THEN					! No sub-directory has been specified.MQ 	  MAIL_FILENAME=DEFDEV(2:DEFDEV_LENGTH+1)//DEFDIR(2:DEFDIR_LENGTH+1)//'MAIL.MAI' 1 	ELSE							! A sub-directory has been specified. , 	  STATUS=STR$TRIM(SUBDIR,SUBDIR,SUBDIR_LEN)e 	  MAIL_FILENAME=DEFDEV(2:DEFDEV_LENGTH+1)//DEFDIR(2:DEFDIR_LENGTH)//SUBDIR(1:SUBDIR_LEN)//'MAIL.MAI'I 	END IFE   C  Open the mail file.  If it cannot be opened, issue an appropriate message, reset the newmail count to zero, and return to the C  command dispatcher.  If the user's mail file is not indexed, or if it cannot be opened for some unknown reason, do not resettY C  the newmail count; issue an appropriate message, and return to the command dispatcher.u   	STATUS=LIB$GET_LUN(LUN1)EZ 	OPEN(UNIT=LUN1,FILE=MAIL_FILENAME,ACCESS='KEYED',STATUS='OLD',SHARED,READONLY,IOSTAT=IOS) 	IF(IOS.NE.0)THENY7 	  IF(IOS.EQ.FOR$IOS_FILNOTFOU)THEN			! File not found.aJ 	    STATUS=LIB$MOVC3(2,0,%REF(VMSMAIL_TEXT(POS_NUM_MAIL:POS_NUM_MAIL+1))) 	    NUM_MESSAGES=00< 	    TYPE '(/X,2A)','Mail file does not exist for ',USERNAME  L 	  ELSE IF(IOS.EQ.FOR$IOS_INCFILORG)THEN			! Inconsistent file organization.` 	    TYPE '(/X,2A)','Non-indexed mail file; newmail count not determined or reset for ',USERNAME   	  ELSEVb 	    TYPE '(/X,2A)','Unknown mail file error; newmail count not determined or reset for ',USERNAME	 	  END IFn 	  STATUS=LIB$FREE_LUN(LUN1)   	  NUM_MESSAGES=0N  5 	  COUNT_NEWMAIL=0					! Not a successful completion. 2 	  RETURN						! Return to the command dispatcher. 	END IF   g C  Count the number of newmail messages in the user's Mail file, then write it to the system mail file.E   	NUM_MESSAGES=0T; 	READ(LUN1,KEYID=1,KEYEQ='NEWMAIL',IOSTAT=IOS)USERMAIL_TEXTNB 	IF(IOS.NE.FOR$IOS_ATTACCNON)THEN			! Some newmail messages exist.< 	  DO WHILE(IOS.NE.-1.AND.USERMAIL_TEXT(10:16).EQ.'NEWMAIL')  	    NUM_MESSAGES=NUM_MESSAGES+1' 	    READ(LUN1,IOSTAT=IOS)USERMAIL_TEXTE	 	  END DO, 	END IFO   	CLOSE(UNIT=LUN1)E 	STATUS=LIB$FREE_LUN(LUN1)  ; 	COUNT_NEWMAIL=%LOC(SS$_NORMAL)				! Successful completion.e  1 	RETURN							! Return to the command dispatcher.h 	END nQ 	OPTIONS		/EXTEND_SOURCE				! Allow up to 132 characters per line in this module.a   	SUBROUTINE	SMAIL(VERSION)   ************************************************************************************************************************************ *																   *H *  This routine invokes the EDT editor to create a file, then sends that file as a VMS Mail message to all users on the system	   *r *  except those designated as NO_MAIL, and those for whom the SYSUAF flag UAF$V_NOMAIL has been set.  Optionally, a list of all	   *u *  usernames in SYSUAF may be generated.  You must be a designated user of this routine to select this option.			   *R *																   *F& *  File information:														   * *    If /LIST=[filename] is specified, a list of all users in SYSUAF.DAT is written to SYS_USERS.LIS in the current default	   *w *    directory.  If filename is specified, the list is written to filename which may contain up to 80 characters.		   *_ *																   **9 *    If Mail is sent, 3 files are created.											   **~ *      SYS$LOGIN:ALL_ACCOUNTS.LIS	List of all accounts to receive mail; excludes usernames in the character string NO_MAIL   *# *					in this routine.									   *mD *      SYS$LOGIN:SYS_MAIL.TXT		Text of the mail message.								   *u *      SYS$LOGIN:SYS_MAIL.COM		Command procedure submitted in batch mode to actually send the mail to all users.	   *	 *																   *l *    If the /NODELETE qualifier is specified, these three files are retained.  By default, or if /DELETE is specified, these files *' *    will be deleted.														   *  *																   ** *    SYS$LOGIN:SYS_MAIL.LOG, which is written by the batch job that actually sends the mail, is retained but is not printed.	   *A *																   *F ************************************************************************************************************************************   	IMPLICIT INTEGER (A-Z)T  N 	PARAMETER	NO_MAIL='/DEFAULT/FIELD/MASS11/ORACLE/SYSTEM/SYSTEST/SYSTEST_CLIG/'   	STRUCTURE	/ITEMLIST_DEF/s^ 	  STRUCTURE	/FORM_OF_ITEM_REQUEST/	BLOCK(4)	! One block for each item, SNDJBC system service.7 	    INTEGER*2	SIZE					! Number of bytes in each item.r0 	    INTEGER*2	ITEM					! Symbolic name of item.: 	    INTEGER*4	BUFFER_ADDRESS				! Address of information.9 	    INTEGER*4	BUFFER_SIZE				! Number of bytes returned.$ 	  END STRUCTUREB 	  INTEGER*4	%FILL					! Longword with zero to terminate itemlist. 	END STRUCTURE< 	RECORD		/ITEMLIST_DEF/ITEMLIST			! Address of the itemlist.  B 	CHARACTER	CURRENT_USER*12				! Name of user running this routine._ 	CHARACTER	LIST_FILENAME*80			! Name of the list file, if only a listing of users is requested.DE 	CHARACTER	SYSUAF_TEXT*512				! Text read from SYS$SYSTEM:SYSUAF.DAT. ? 	CHARACTER	USERNAME*12				! List of users read from SYSUAF.DAT.   3 	INTEGER*4	IOSB(2)					! Input/Output Status Block.h  J 	INCLUDE		'($SJCDEF)'				! Send message to the job controller definitions.  V 	EXTERNAL	CLI$_NEGATED				! Return status from CLI$PRESENT if a qualifier was negated.E 	EXTERNAL	JPI$_USERNAME				! Used to get the current user's username.$A 	EXTERNAL	UAF$S_USERNAME				! Length of username field in SYSUAF.YA 	EXTERNAL	UAF$T_USERNAME				! Offset to username field in SYSUAF.'? 	EXTERNAL	UAF$L_FLAGS				! Offset to the FLAGS field in SYSUAF.'O 	EXTERNAL	UAF$V_NOMAIL				! UAF flag that prohibits delivery of mail to a user.D   C  End of declarations.E N[ C  Determine if the current user is one of the designated users identified in this routine.D  R 	STATUS=LIB$GETJPI(%LOC(JPI$_USERNAME),,,,CURRENT_USER)	! Current user's username.v 	IF(.NOT.STR$FIND_FIRST_SUBSTRING(CURRENT_USER,SRC_STR_INDEX,SUB_STR_INDEX,'SYSTEM','ALAN'))THEN	! Modify as required.Q 	  TYPE '(/X,A)','You must be one of the designated users to select this option.'r2 	  RETURN						! Return to the command dispatcher. 	END IF   ~ C  If the qualifier /LIST has been specified, write a list of all users in SYSUAF to a disk file in the user's current default
 C  directory.	   	IF(CLI$PRESENT('LIST'))THENk 	  STATUS=CLI$GET_VALUE('LIST',LIST_FILENAME)		! The default filename is SYS_USERS, specified in XMAIL.CLD.h   	  STATUS=LIB$GET_LUN(LUN1)y 	  STATUS=LIB$GET_LUN(LUN2)![ 	  OPEN(UNIT=LUN1,FILE='SYS$SYSTEM:SYSUAF.DAT',ACCESS='KEYED',STATUS='OLD',SHARED,READONLY) \ 	  OPEN(UNIT=LUN2,FILE=LIST_FILENAME,DEFAULTFILE='.LIS',STATUS='NEW',CARRIAGECONTROL='LIST')  ` 	  READ(LUN1,KEYID=0,KEYGE='A',IOSTAT=IOS)SYSUAF_TEXT	! Read the first username from SYSUAF.DAT. 	  DO WHILE(IOS.NE.-1)[ 	    USERNAME=SYSUAF_TEXT(%LOC(UAF$T_USERNAME)+1:%LOC(UAF$T_USERNAME)+%LOC(UAF$S_USERNAME)) . 	    STATUS=STR$TRIM(USERNAME,USERNAME,LENGTH)  F 	    STATUS=LIB$MOVC3(4,%REF(SYSUAF_TEXT(%LOC(UAF$L_FLAGS)+1:)),FLAGS)Y 	    IF(.NOT.BTEST(FLAGS,%LOC(UAF$V_NOMAIL)))THEN	! The UAF flag Nomail has not been set.M* 	      WRITE(LUN2,'(A)')USERNAME(1:LENGTH)	 	    ELSE*K 	      WRITE(LUN2,'(A,T20,A)')USERNAME(1:LENGTH),'Nomail UAF flag bit set.'* 	    END IF*  Q 	    READ(LUN1,IOSTAT=IOS)SYSUAF_TEXT			! Read the next username from SYSUAF.DAT.n	 	  END DOt  H 	  INQUIRE(UNIT=LUN2,NAME=LIST_FILENAME)			! Get the complete file-spec.r 	  STATUS=STR$TRIM(LIST_FILENAME,LIST_FILENAME,LENGTH)	! Determine number of characters for formatting the output.I 	  TYPE '(/X,2A)','List of all users written to ',LIST_FILENAME(1:LENGTH)R  + C  Close all files, free all logical units.n   	  CLOSE(UNIT=LUN1). 	  CLOSE(UNIT=LUN2)	 	  STATUS=LIB$FREE_LUN(LUN1) 	  STATUS=LIB$FREE_LUN(LUN2)   C  Send a mail message to all users on this system.  Begin by creating a mail distribution list.  Exclude users identified in the=J C  parameter NO_MAIL, and those for whom the UAF flag NOMAIL has been set.   	ELSEE 	  STATUS=LIB$GET_LUN(LUN1)D 	  STATUS=LIB$GET_LUN(LUN2)A[ 	  OPEN(UNIT=LUN1,FILE='SYS$SYSTEM:SYSUAF.DAT',ACCESS='KEYED',STATUS='OLD',SHARED,READONLY)eX 	  OPEN(UNIT=LUN2,FILE='SYS$LOGIN:ALL_ACCOUNTS.LIS',STATUS='NEW',CARRIAGECONTROL='LIST')  ` 	  READ(LUN1,KEYID=0,KEYGE='A',IOSTAT=IOS)SYSUAF_TEXT	! Read the first username from SYSUAF.DAT. 	  DO WHILE(IOS.NE.-1)F 	    STATUS=LIB$MOVC3(4,%REF(SYSUAF_TEXT(%LOC(UAF$L_FLAGS)+1:)),FLAGS)Y 	    IF(.NOT.BTEST(FLAGS,%LOC(UAF$V_NOMAIL)))THEN	! The UAF flag Nomail has not been set.G] 	      USERNAME=SYSUAF_TEXT(%LOC(UAF$T_USERNAME)+1:%LOC(UAF$T_USERNAME)+%LOC(UAF$S_USERNAME)) 0 	      STATUS=STR$TRIM(USERNAME,USERNAME,LENGTH)^ 	      IF(INDEX(NO_MAIL,'/'//USERNAME(1:LENGTH)//'/').EQ.0)WRITE(LUN2,'(A)')USERNAME(1:LENGTH) 	    END IFE  Q 	    READ(LUN1,IOSTAT=IOS)SYSUAF_TEXT			! Read the next username from SYSUAF.DAT.D	 	  END DO)   	  CLOSE(UNIT=LUN1)H 	  CLOSE(UNIT=LUN2)S 	  STATUS=LIB$FREE_LUN(LUN2)   C  Invoke the EDT editor to create the mail message.  If an EDT initialization file exists in the user's home directory, it will beB C  used.  Create a command procedure to be submitted as a batch job to actually send the mail message.  This avoids blocking the) C  current user while Mail is being sent.   D 	  STATUS=EDT$EDIT('SYS$LOGIN:SYS_MAIL.TXT',,'SYS$LOGIN:EDTINI.EDT')  T 	  OPEN(UNIT=LUN1,FILE='SYS$LOGIN:SYS_MAIL.COM',STATUS='NEW',CARRIAGECONTROL='LIST')! 	  WRITE(LUN1,'(A)')'$ SET NOON', ( 	1		   '$ OLD_PRIVS=F$SETPRV("ALTPRI")'," 	2		   '$ SET PROCESS/PRIORITY=4',P 	3		   '$ MAIL/SUBJECT="System Update Message" SYS_MAIL.TXT "@ALL_ACCOUNTS.LIS"'  I C  If the /DELETE qualifier was negated; do not delete the working files.=  Q 	  IF(CLI$PRESENT('DELETE').EQ.%LOC(CLI$_NEGATED))THEN	! Do not delete the files.  	    WRITE(LUN1,'(A)')'$ EXIT'+ 	  ELSE							! Delete the temporary files.SO 	    WRITE(LUN1,'(A)')'$ DELETE ALL_ACCOUNTS.LIS;,SYS_MAIL.TXT;,SYS_MAIL.COM;',) 	1		     '$ EXIT' 	 	  END IFi   	  CLOSE(UNIT=LUN1)o 	  STATUS=LIB$FREE_LUN(LUN1)  d C  Define the itemlist required to submit a file to the job controller to be executed in batch mode.   	  ITEMLIST.BLOCK(1).SIZE=9E$ 	  ITEMLIST.BLOCK(1).ITEM=SJC$_QUEUEJ 	  ITEMLIST.BLOCK(1).BUFFER_ADDRESS=%LOC('SYS$BATCH')	! Name of the queue." 	  ITEMLIST.BLOCK(1).BUFFER_SIZE=0  Y 	  ITEMLIST.BLOCK(2).SIZE=22				! Number of characters in the command procedure filename.y1 	  ITEMLIST.BLOCK(2).ITEM=SJC$_FILE_SPECIFICATIONYb 	  ITEMLIST.BLOCK(2).BUFFER_ADDRESS=%LOC('SYS$LOGIN:SYS_MAIL.COM')	! Name of file to be submitted." 	  ITEMLIST.BLOCK(2).BUFFER_SIZE=0    	  ITEMLIST.BLOCK(3).SIZE=0WK 	  ITEMLIST.BLOCK(3).ITEM=SJC$_NO_LOG_DELETE		! Do not delete the log file.T% 	  ITEMLIST.BLOCK(3).BUFFER_ADDRESS=0I" 	  ITEMLIST.BLOCK(3).BUFFER_SIZE=0   	  ITEMLIST.BLOCK(4).SIZE=0MZ 	  ITEMLIST.BLOCK(4).ITEM=SJC$_NO_LOG_SPOOL		! Do not spool the log file to a print queue.% 	  ITEMLIST.BLOCK(4).BUFFER_ADDRESS=0o" 	  ITEMLIST.BLOCK(4).BUFFER_SIZE=0  h 	  STATUS=SYS$SNDJBCW(,%VAL(SJC$_ENTER_FILE),,ITEMLIST,IOSB,,)	! Submit batch job to the job controller.  ^ C  If the batch job could not be submitted, display the status message on the terminal screen.  Q 	  IF(.NOT.STATUS)CALL LIB$SIGNAL(%VAL(IOSB(1)))		! Non-successful return status.M   	END IF   1 	RETURN							! Return to the command dispatcher.i 	END  Q 	OPTIONS		/EXTEND_SOURCE				! Allow up to 132 characters per line in this module.   T 	SUBROUTINE	PROCESS_SYSTEM_MAIL_FILE(VERSION,VMSMAIL_TEXT,SUBDIR,FORWARDING_ADDRESS)   ************************************************************************************************************************************ *																   *s *  The system  mail file structure is not the same in VMS Version 4 as it is in version 5.  This routine returns to the calling	   *h *  routine the subdirectory and forwarding address (if any) that was set by the specified user.					   * *																   *r ************************************************************************************************************************************   	IMPLICIT INTEGER (A-Z)	   C  The following symbols are used by DEC in VMS MAIL, and are included here to facilitate program revisions in the event the symbolm C  values are changed.  There is no such module as MAILDEF, and DEC reserves the right to modify the structure of MAIL.MAI when theyK C  so choose.  Other symbols are defined, but are not used in this program.E   	PARAMETER	UPD_C_DIRNAM=3* 	PARAMETER	UPD_C_FWDNAM=4	  = 	CHARACTER	VMSMAIL_TEXT*(*)			! Text of the system mail file.O 	CHARACTER	SUBDIR*(*)t! 	CHARACTER	FORWARDING_ADDRESS*(*)e  
 	INTEGER*2	L1d   C  End of declarations.  	 	IF(VERSION.EQ.4)THEN*  O C  In VMS Version 4, the structure of VMSMAIL.DAT contains the following items:*w C    Byte 66 contains a value that is the number of characters in the "Sub-directory" field, including square brackets.C C    Byte 67 contains a value that is the number of characters in the "Personal name" field.  The personal name field is not usedt C    in this program.cY C    Byte 68 contains a value that is the number of characters in the "Forwarding" field.b~ C    These three fields are concatonated together in the reverse order, that is "Forwarding"//"Personal name"//"Sub-directory" C     beginning in byte 69.   e 	  SUB_DIRLEN=ICHAR(VMSMAIL_TEXT(66:66))			! Number of characters in the sub-directory specification.FD 	  IF(SUB_DIRLEN.EQ.0)THEN				! No sub-directory has been specified. 	    SUBDIR=' 'r3 	  ELSE							! A sub-directory has been specified. G 	    START_POS=70+ICHAR(VMSMAIL_TEXT(67:67))+ICHAR(VMSMAIL_TEXT(68:68))T# 	    END_POS=START_POS+SUB_DIRLEN-2m+ 	    SUBDIR=VMSMAIL_TEXT(START_POS:END_POS)*	 	  END IFt  d 	  LENGTH_OF_FORWARDING=ICHAR(VMSMAIL_TEXT(68:68))	! Number of characters in the forwarding address.R 	  IF(LENGTH_OF_FORWARDING.EQ.0)THEN			! No forwarding address has been specified. 	    FORWARDING_ADDRESS=' 'C8 	  ELSE							! A forwarding address has been specified.@ 	    FORWARDING_ADDRESS=VMSMAIL_TEXT(69:68+LENGTH_OF_FORWARDING)	 	  END IFE   	ELSEg  P C  In VMS Version 5, the structure of a record in VMSMAIL_PROFILE.DATA (UPD) is:7 C    Beginning in byte 32, a repeating sequence exists:e C      a word (2 bytes) indicating the type of field that follows (Newmail count, flags, sub-directory, forward name, personal name); C      a word (2 bytes) indicating the length of the field,e C      the text of the field.i  
 	  SUBDIR=' 'I 	  FORWARDING_ADDRESS=' ')  h 	  STATUS=STR$TRIM(VMSMAIL_TEXT,VMSMAIL_TEXT,L1)		! Length of the record read from VMSMAIL_PROFILE.DATA.J 	  POS=32						! First byte after 31 characters reserved for the username.  @ 	  STATUS=LIB$MOVC3(2,%REF(VMSMAIL_TEXT(POS:POS+1)),PACKET_TYPE)A 	  STATUS=LIB$MOVC3(2,%REF(VMSMAIL_TEXT(POS+2:POS+3)),PACKET_LEN)    	  DO WHILE(POS.LT.L1)P 	    IF(PACKET_TYPE.EQ.UPD_C_DIRNAM)THEN			! A sub-directory has been specified.2 	      SUBDIR=VMSMAIL_TEXT(POS+5:POS+PACKET_LEN+3)Y 	    ELSE IF(PACKET_TYPE.EQ.UPD_C_FWDNAM)THEN		! A forwarding address has been specified.S> 	      FORWARDING_ADDRESS=VMSMAIL_TEXT(POS+4:POS+PACKET_LEN+3) 	    END IF_  > 	    POS=POS+PACKET_LEN+4				! Position of the next TLD field.  B 	    STATUS=LIB$MOVC3(2,%REF(VMSMAIL_TEXT(POS:POS+1)),PACKET_TYPE)C 	    STATUS=LIB$MOVC3(2,%REF(VMSMAIL_TEXT(POS+2:POS+3)),PACKET_LEN)R	 	  END DOY 	END IFE  1 	RETURN							! Return to the command dispatcher.  	END