 .de Sh .br  .ne 5  .PP 
 \fB\\$1\fR .PP  .. .de Sp
 .if t .sp .5v 	 .if n .sp  ..	 .TH SOX 1  .SH NAME8 sox - SOund eXchange - universal sound sample translator .SH SYNOPSIS .B sox \fIinfile outfile \fB .br + .B sox \fIinfile outfile \fB[ \fIeffect\fR  ! .B [ \fIeffect options ...\fB ] ]  .br $ .B sox \fIinfile \fB-e \fIeffect\fR  .B [ \fIeffect options ...\fB ]  .br  .B sox [\fI general options \fB ] [ \fIformat options \fB ]  \fIifile\fB  [ \fIformat options \fB ]  \fIofile\fB - [ \fIeffect\fR [ \fIeffect options ...\fB ] ]  .br  \fIGeneral options:\fB [ -V ] [ -v \fIvolume\fB ]  .br  \fIFormat options:\fB  [ \fB-t \fIfiletype\fB ] [ -r \fIrate\fB ]  [ -s/-u/-U/-A ]  [ -b/-w/-l/-f/-d/-D ]  [ -c \fIchannels\fB ]  [ -x ] .br  \fIEffects:\fB .br  	copy  .br  	rate  .br  	avg   ." .br ." 	resample ." .br
 ." 	check  .br  	stat  .br 3 	echo \fIdelay volume\fB [ \fIdelay volume ... \fB]  .br " 	vibro \fIspeed \fB[ \fIdepth\fB ] .br  	lowp \fIcenter\fB .br  	highp \fIcenter\fB  .br 2 	band \fB[ \fI-n \fB] \fIcenter \fB[ \fIwidth\fB ] .SH DESCRIPTION  .I Sox2 translates sound files from one format to another, possibly doing a sound effect. .SH OPTIONS 5 The option syntax is a little grotty, but in essence:  .br  	sox file.au file.voc  .br 2 translates a sound sample in SUN Sparc .AU format $ into a SoundBlaster .VOC file, while .br - 	sox -v 0.5 file.au -rate 12000 file.voc rate  .br * does the same format translation but also ' lowers the amplitude by 1/2 and changes 4 the sampling rate from 8000 hertz to 12000 hertz via the  .B rate  \fIsound effect\fR loop. .PP  File type options: .TP 10 \fB-t\fI filetype ( gives the type of the sound sample file. .TP 10 \fB-r \fIrate\fR" Give sample rate in Hertz of file. .TP 10 \fB-s/-u/-U/-A\fR 2 The sample data is signed linear (2's complement),= unsigned linear, U-law (logarithmic), or A-law (logarithmic). . U-law and A-law are the U.S. and international6 standards for logarithmic telephone sound compression. .TP 10 \fB-b/-w/-l/-f/-d/-D\fR < The sample data is in bytes, 16-bit words, 32-bit longwords,; 32-bit floats, 64-bit double floats, or 80-bit IEEE floats. 6 Floats and double floats are in native machine format. .TP 10 \fB-x\fR+ The sample data is in XINU format; that is, 5 it comes from a machine with the opposite word order   than yours and must 2 be swapped according to the word-size given above.3 Only 16-bit and 32-bit integer data may be swapped. 3 Machine-format floating-point data is not portable. - IEEE floats are a fixed, portable format. ???  .TP 10 \fB-c \fIchannels\fR. The number of sound channels in the data file.= This may be 1, 2, or 4; for mono, stereo, or quad sound data.  .PP  General options: .TP 10 \fB-e\fR/ after the input file allows you to avoid giving ' an output file and just name an effect.  This is only useful with the   .B stat  effect.  .TP 10 \fB-v \fIvolume\fR# Change amplitude (floating point);  4 less than 1.0 decreases, greater than 1.0 increases.7 Note: we perceive volume logarithmically, not linearly. 
 Note: see the  .B stat  effect.  .TP 10 \fB-V\fR) Print a description of processing phases. # Useful for figuring out exactly how  .I sox is mangling your sound samples.  .PP < The input and output files may be standard input and output. This is specified by '-'.  The  .B -t\ \fItype" option must be given in this case, else   .I sox  + will not know the format of the given file.  The  .B -t, .B -r, .B -s/-u/-U/-A,  .B -b/-w/-l/-f/-d/-D and  .B -x 5 options refer to the input data when given before the 7 input file name.  After, they refer to the output data.  .PP & If you don't give an output file name, .I sox will just read the input file.6 This is useful for validating structured file formats; the  .B stat  effect may also be used  via the  .B -e  option.  .SH FILE TYPES .I Sox8 needs to know the formats of the input and output files.- File formats which have headers are checked,  " if that header doesn't seem right,. the program exits with an appropriate message.4 Currently, raw (no header) binary and textual data,  IRCAM Sound Files,. Sound Blaster, SPARC .AU (w/header), Mac HCOM,- PC/DOS .SOU, Sndtool, and Sounder, NeXT .SND, / Windows 3.1 RIFF/WAV, Turtle Beach .SMP, CD-R,  2 and Apple/SGI AIFF and 8SVX formats are supported. .PP  .TP 10 .B .aiff* AIFF files used on Apple IIc/IIgs and SGI.3 Note: the AIFF format supports only one SSND chunk. + It does not support multiple sound chunks,  2 or the 8SVX musical instrument description format.& AIFF files are multimedia archives and/ and can have multiple audio and picture chunks. 3 You may need a separate archiver to work with them.  .TP 10 .B .au SUN Microsystems AU files.- There are apparently many types of .au files; 6 DEC has invented its own with a different magic number and word order.   = The .au handler can read these files but will not write them. 5 Some .au files have valid AU headers and some do not. ; The latter are probably original SUN u-law 8000 hz samples. " These can be dealt with using the  .B .ul format (see below).  .TP 10 .B .hcom Macintosh HCOM files. 7 These are (apparently) Mac FSSD files with some variant  of Huffman compression. 4 The Macintosh has wacky file formats and this format9 handler apparently doesn't handle all the ones it should. 9 Mac users will need your usual arsenal of file converters , to deal with an HCOM file under Unix or DOS. .br  .TP 10 .B .raw  Raw files (no header). .br ) The sample rate, size (byte, word, etc),  " and style (signed, unsigned, etc.)! of the sample file must be given. % The number of channels defaults to 1.  .TP 10 .B ".ub, .sb, .uw, .sw, .ul") These are several suffices which serve as 6 a shorthand for raw files with a given size and style.( Thus, \fBub, sb, uw, sw,\fR and \fBul\fR- correspond to "unsigned byte", "signed byte", 2 "unsigned word", "signed word", and "ulaw" (byte).: The sample rate defaults to 8000 hz if not explicitly set,5 and the number of channels (as always) defaults to 1. ? There are lots of Sparc samples floating around in u-law format 5 with no header and fixed at a sample rate of 8000 hz. C (Certain sound management software cheerfully ignores the headers.) @ Similarly, most Mac sound files are in unsigned byte format with# a sample rate of 11025 or 22050 hz.  .TP 10 .B .sf IRCAM Sound Files. .br / SoundFiles are used by academic music software  @ such as the CSound package, and the MixView sound sample editor. .TP 10 .B .voc  Sound Blaster VOC files. .br @ VOC files are multi-part and contain silence parts, looping, and, different sample rates for different chunks.? On input, the silence parts are filled out, loops are rejected, 3 and sample data with a new sample rate is rejected. @ Silence with a different sample rate is generated appropriately.D On output, silence is not detected, nor are impossible sample rates. .TP 10 .B .auto? This is a ``meta-type'': specifying this type for an input file C triggers some code that tries to guess the real type by looking for E magic words in the header.  If the type can't be guessed, the program C exits with an error message.  The input must be a plain file, not a 0 pipe.  This type can't be used for output files. .PP  .TP 10 .B .cdr  CD-R .br 5 CD-R files are used in mastering music Compact Disks. 3 The file format is, as you might expect, raw stereo , raw unsigned samples at 44khz.  But, there's1 some blocking/padding oddity in the format, so it  needs its own handler. .PP  .TP 10
 .B .dat        Text Data files  .br 3 These files contain a textual representation of the 0 sample data.  There is one line at the beginning0 that contains the sample rate.  Subsequent lines. contain two numeric data items: the time since1 the beginning of the sample and the sample value. 5 Values are normalized so that the maximum and minimum 4 are 1.00 and -1.00.  This file format can be used to/ create data files for external programs such as 6 FFT analyzers or graph routines.  SOX can also convert5 a file in this format back into one of the other file  formats. .PP  .TP 10 .B .smp   Turtle Beach SampleVision files. .br J SMP files are for use with the PC-DOS package SampleVision by Turtle BeachJ Softworks. This package is for communication to several MIDI samplers. AllL sample rates are supported by the package, although not all are supported by; the samplers themselves. Currently loop points are ignored.  .PP  .TP 10 .B .wav  Windows 3.1 .WAV RIFF files. .br - These appear to be very similar to IFF files,  but not the same.   5 They are the native sound file format of Windows 3.1. 7 Obviously, Windows 3.1 is of such incredible importance : to the computer industry that it just had to have its own  sound file format. .SH EFFECTS B Only one effect from the palette may be applied to a sound sample.* To do multiple effects you'll need to run  .I sox   in a pipeline. .TP 30 copy' Copy the input file to the output file. 7 This is the default effect if both files have the same  ( sampling rate, or the rates are "close". .TP 30 rate5 Translate input sampling rate to output sampling rate 5 via linear interpolation to the Least Common Multiple  of the two sampling rates. This is the default effect  / if the two files have different sampling rates.  This is fast but noisy: : the spectrum of the original sound will be shifted upwards9 and duplicated faintly when up-translating by a multiple. 9 ." Lerp-ing is acceptable for cheap 8-bit sound hardware, 3 ." but for CD-quality sound you should instead use: 	 ." .TP 30  ." resample 8 ." Translate input sampling rate to output sampling rate# ." via simulated analog filtration. , ." This method is slow and uses lots of RAM,% ." but gives much better results then  ." .B rate.  .TP 30 avg 8 Mix 4- or 2-channel sound file into 2- or 1-channel file0 by averaging the samples for different speakers.	 ." .TP 30  ." check' ." Do a format check on the input file, 3 ." and print any errors on the standard error file.  ." Write no output.  ." If you give no output file,  ; ." you need to specify either this effect or the following:  .TP 30 stat) Do a statistical check on the input file, - and print results on the standard error file.  .B stat 1 may copy the file untouched from input to output,  if you select an output file.   0 The "Volume Adjustment:" field in the statistics gives you the argument to the  .B -v 	 .I number / which will make the sample as loud as possible.  .TP 30  echo [ \fIdelay volume ... \fB ] Add echoing to a sound sample.1 Each delay/volume pair gives the delay in seconds . and the volume (relative to 1.0) of that echo.' If the volumes add up to more than 1.0, 0 the sound will melt down instead of fading away. .TP 30" vibro \fIspeed \fB [ \fIdepth\fB ]- Add the world-famous Fender Vibro-Champ sound ! effect to a sound sample by using  a sine wave as the volume knob. 	 .B Speed  " gives the Hertz value of the wave. This must be under 30. .B Depth' gives the amount the volume is cut into  by the sine wave, ) ranging 0.0 to 1.0 and defaulting to 0.5.  .TP 30 lowp \fIcenter Apply a low-pass filter.2 The frequency response drops logarithmically with 	 .I center $ frequency in the middle of the drop.( The slope of the filter is quite gentle. .TP 30 highp \fIcenter  Apply a high-pass filter. 2 The frequency response drops logarithmically with 	 .I center $ frequency in the middle of the drop.( The slope of the filter is quite gentle. .TP 301 band \fB[ \fI-n \fB] \fIcenter \fB[ \fIwidth\fB ]  Apply a band-pass filter. , The frequency response drops logarithmically
 around the	 .I center 
 frequency. The  .I width gives the slope of the drop. The frequencies at   .I "center + width"  and  .I "center - width" * will be half of their original amplitudes. .B Band / defaults to a mode oriented to pitched signals, + i.e. voice, singing, or instrumental music.  The  .I -n * (for noise) option uses the alternate mode for un-pitched signals.  .B Band , introduces noise in the shape of the filter, i.e. peaking at the 	 .I center ! frequency and settling around it.  .P .I Sox enforces certain effects. ( If the two files have different sampling* rates, the requested effect must be one of .B copy, or .B rate, ." or  ." .B resample. 4 If the two files have different numbers of channels, the  .B avg ." or other channel mixing effect must be requested.  .TP 30 reverse $ Reverse the sound sample completely.) Included for finding Satanic subliminals.  .SH BUGS The syntax is horrific. : It's very tempting to include a default system that allows" an effect name as the program name2 and just pipes a sound sample from standard input 4 to standard output, but the problem of inputting the# sample rates makes this unworkable. 	 .SH FILES  .SH SEE ALSO .SH NOTICES  The echoplex effect is: (     Copyright (C) 1989 by Jef Poskanzer. 	 I     Permission to use, copy, modify, and distribute this software and its M     documentation for any purpose and without fee is hereby granted, provided K     that the above copyright notice appear in all copies and that both that D     copyright notice and this permission notice appear in supportingH     documentation.  This software is provided "as is" without express or     implied warranty.   