      PROGRAM Quota_Check
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **        Quota_Check        **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          RAGOSTA@MERLIN.ARC.NASA.GOV (Internet)
C*
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035-1000
C*          (415) 604-5558
C*
C*     DESCRIPTION :
C*
C*         The QUOTA CHECK command is used to check your available disk
C*         space against two limits that you specify.  If the available
C*         space is less than the first limit, a warning message is
C*         produced.  If the available space is less than the second limit,
C*         an alarm is sounded.  If no second limit is specified, it is half
C*         of the first limit.  If no limits are provided, 4000 and 2000 are
C*         used.
C*
C*         The syntax for this command is:
C*
C*               QUOta_check  [upper_limit [lower_limit]]
C*
C*         It is recommended that this command be placed in your LOGIN.COM file.
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*          31-MAY-1995  -  INITIAL VERSION
C*
C***********************************************************************
C*
      character *40 p(2), q(2)
c
      call getfor (nq, q, np, p)
      if (np .lt. 1) then
         ihi = 4000
         ilo = 2000
      else if (np .lt. 2) then
         call right(p(1))
         read(p(1),900,err=1000) ihi
         ilo = ihi / 2.0
      else
         call right(p(1))
         read(p(1),900,err=1000) ihi
         call right(p(2))
         read(p(2),900,err=1000) ilo
      endif
c
      call quota ('    ', '   ', nused, nperm, nerr)
      if (nerr .ne. 0) then
         write(6,*) 'Unable to retrieve quota.'
      else if (nperm .eq. 0) then
         write(6,*) 'Quotas not enabled or no entry for this user.'
      else
         nleft = nperm - nused
         if (nleft .le. ilo) then
            write(6,910) char(9), nleft
         else if (nleft .le. ihi) then
            write(6,920) nleft
         endif
      endif
      call exit
1000  write(6,*) 'Illegal limits specified.'
      call exit
900   format(30x,i10)
910   format(' ',a1,'***** Quota Alarm !!!',/,
     $ '  only ',i7,' blocks of quota left.')
920   format(' *** Quota Warning !',/,
     $ '  only ',i7,' blocks of quota left.')
      END
C
C---END Quota_Check
C
