      PROGRAM FILTER
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          FILTER           **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     PROGRAM :
C*          FILTER
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     PURPOSE :
C*          FILTER REPLACES CHARACTERS OR STRINGS WITH OTHER CHARACTERS
C*          OR STRINGS ACCORDING TO USER INPUT.  CAPITALIZATION, LOWER-
C*          CASIFICATION, ASCII TO STRING, STRING TO ASCII, AND UNTAB
C*          ARE BUILT IN.
C*
C*     QUALIFIERS :
C*          /ASCII   - REPLACE "DEASCII" STRINGS WITH ASCII CHARACTERS
C*          /AT      - USED WITH "UNTAB" TO SET TAB STOPS AT THESE LOCATIONS
C*          /CAPS    - CAPITALIZE
C*          /CONFIRM - CONFIRM EACH CHANGE
C*          /DEASCII - REPLACE ASCII CONTROL CHARACTERS WITH STRINGS
C*          /EVERY   - USED WITH "UNTAB" TO SET TAB STOPS EVERY NUM OF COLUMNS
C*          /EXACT   - MAKES CASE OF STRINGS MEANINGFULL
C*          /EXCLUDE - EXCLUDES FILES FROM PROCESSING
C*          /FILE=   - LOAD LIST OF STRINGS FROM A FILE
C*          /FORTRAN - USE FORTRAN STYLE SOURCE CODE WITH "UNTAB"
C*          /KEYBOARD- INPUT LIST OF STRING FROM KEYBOARD
C*          /LOG     - LIST ALL CHANGES AS MADE
C*          /LOWER   - MAKE CAPS LOWER CASE
C*          /UNTAB   - REPLACE TABS WITH SPACES (COL MOD 8 = 0)
C*          /ZBIT    - ZERO THE EIGHTH BIT OF ALL CHARACTERS
C*
C*     PARAMETERS :
C*          FILESPEC - FILESPEC OR LIST OF FILESPECS (WILDCARDS OK)
C*          OUTSPEC  - (OPTIONAL) NAME (OR LIST) OF OUTPUT FILES
C*
C*     SUBPROGRAM REFERENCES :
C*          GETFOR, LEFT, EXIT, SEARCH, GETSET, GETFILEX, FILTER_MAIN
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*          23-NOV-1993  -  ADDED /CONFIRM
C*          28-FEB-1990  -  CHECK INPUT FILE FOR LEGAL ATTRIBUTES
C*          19-APR-1989  -  FIXED BUG IN STRING REPLACEMENT OPTION - lej
C*          13-MAR-1989  -  ADDED /EXCLUDE
C*          11-MAR-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      COMMON / SWITCH / DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB,
     $   ZBIT, VERIFY, MADE_CHANGES, FORTRAN, CONFIRM
      LOGICAL DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB, ZBIT, VERIFY
      LOGICAL MADE_CHANGES, FORTRAN, CONFIRM
C
      CHARACTER *80 P(4), Q(10)
      CHARACTER *127 FILES, OUTFILES, ONEFILE, DEFILE, EXFILE, OUTFILE
C
      PARAMETER (NQUALS=15)
      CHARACTER *20 QUALS(NQUALS)
      LOGICAL MATCHD, AMBIG, LIST, OUTWILD
      DATA QUALS/ 'ASCII',  'AT',  'CAPS',  'CONFIRM', 'DEASCII',
     $ 'EVERY',  'EXACT',  'EXCLUDE',  'FILE',  'FORTRAN',  'KEYBOARD',
     $ 'LOG',  'LOWER',  'UNTAB',  'ZBIT' /
C
C --- GET USER PARAMETERS AND QUALIFIERS
C
      CALL GETFOR (NQ, Q, NP, P)
      IF (NQ .EQ. 0) THEN
         WRITE(6,990)
         CALL EXIT(1)
      ENDIF
C
C --- IF THE USER DIDN'T ENTER A FILE LIST ON THE COMMAND LINE, ASK
C ---  FOR IT
C
      IF (NP .EQ. 0) THEN
         WRITE(6,900)
         READ(5,910) P(1)
      ENDIF
C
C --- MAYBE HE CHANGED HIS MIND?
C
      IF (P(1) .EQ. ' ') THEN
         WRITE(6,920)
         CALL EXIT(1)
      ENDIF
C
      CALL LEFT(P(1))
      FILES = P(1)
      EXFILE = ' '
      DEFILE = ' '
C
C --- GET OUTPUT FILE LIST, IF ANY
C
      IF (NP .GT. 1) THEN
         OUTFILES = P(2)
         IF ((INDEX(OUTFILES,',') .NE. 0) .AND.
     $       (INDEX(OUTFILES,'*') .NE. 0)) THEN
            WRITE(6,970) OUTFILES(1:LENGTH(OUTFILES))
            CALL EXIT(1)
         ENDIF
C
C ------ IF THE INPUT LIST HAS MORE THAN ONE FILE, SO MUST THE
C ------  OUTPUT FILE LIST
C
         IF ((INDEX(FILES,',') .NE. 0) .OR. (INDEX(FILES,'*') .NE. 0)) 
     $      THEN
            LIST = .TRUE.
            IF (INDEX(FILES,'*') .NE. 0) THEN
               IF (INDEX(OUTFILES,'*') .EQ. 0) THEN
                  WRITE(6,960) FILES(1:LENGTH(FILES))
                  CALL EXIT(1)
               ENDIF
            ELSE
               IF ((INDEX(OUTFILES,'*') .EQ. 0) .AND.
     $             (INDEX(OUTFILES,',') .EQ. 0)) THEN
                  WRITE(6,960) FILES(1:LENGTH(FILES))
                  CALL EXIT(1)
               ENDIF
            ENDIF
         ELSE
            LIST = .FALSE.
         ENDIF
      ELSE
         OUTFILES = ' '
         LIST = .FALSE.
      ENDIF
C
      I = INDEX(OUTFILES,'*')
      IF (I .NE. 0) THEN
         OUTFILES(I:I) = ' '
         CALL BLANKS (OUTFILES)
         OUTWILD = .TRUE.
      ELSE
         OUTWILD = .FALSE.
      ENDIF
      IPTR = 1
C
C --- OK, WE HAVE THE FILE LISTS NOW
C
C --- LET'S CHECK OUT THE QUALIFIERS
C
      DO 10 I = 1, NQ
         L = INDEX(Q(I),'=') - 1
         IF (L .LE. 0) L = LENGTH(Q(I))
         CALL SEARCH (QUALS, NQUALS, Q(I)(1:L), K,
     $            MATCHD, AMBIG)
C
         IF (AMBIG) THEN
            WRITE(6,930) Q(I)(1:LENGTH(Q(I)))
            CALL EXIT(1)
         ENDIF
C
         IF (MATCHD) THEN
            IF (QUALS(K) .EQ. 'EXCLUDE') THEN
               EXFILE = Q(I)(L+2:)
            ENDIF
         ELSE
            WRITE (6,950) Q(I)(1:LENGTH(Q(I)))
         ENDIF
10    CONTINUE
C
      CALL GETSET ( Q, NQ )
      IF (FORTRAN) DEFILE = '.FOR'
C
C
C --- OK, NOW LET THE TOOL DO ITS STUFF
C
C
C --- EXTRACT FILE NAMES ONE AT A TIME
C
100   CALL GETFILEX ( FILES, ONEFILE, DEFILE, EXFILE )
C
C --- GENERATE NAME OF OUTPUT FILE FOR THIS INPUT FILE
C
      IF (ONEFILE .NE. ' ') THEN
C
C ------ IF NO OUTLIST SPECIFIED, CREATE NEW VERSION OF INPUT FILE
C
         IF (OUTFILES .EQ. ' ') THEN
            OUTFILE = ONEFILE
C
C ------ IF THE INPUT(OUTPUT) FILE SPEC IS A LIST, FIGURE OUT NEXT 
C ------  FILE NAME FROM THE OUTLIST
C
         ELSE IF (LIST) THEN
            IF (OUTWILD) THEN
               CALL PARSE ( OUTFILES, ONEFILE, 'FULL', OUTFILE )
            ELSE
               I = INDEX (OUTFILES(IPTR:),',')
               IF (I .EQ. 0) THEN
                  WRITE(6,980)
                  CALL EXIT(1)
               ENDIF
               I = I + IPTR
               OUTFILE = OUTFILES(IPTR:I-1)
               IPTR = I + 1
            ENDIF
C
C --- SINGLE OUTPUT FILE SPECIFIED
C
         ELSE
            OUTFILE = OUTFILES
         ENDIF
         I = INDEX(OUTFILE,';')
         IF (I .NE. 0) OUTFILE = OUTFILE(1:I) 
C
         CALL FILTER_MAIN ( ONEFILE, OUTFILE )
         GO TO 100
      ENDIF
      CALL EXIT(1)
C
1000  WRITE(6,940) Q(I)(1:LENGTH(Q(I)))
      CALL EXIT(1)
C
900   FORMAT(' File ? ',$)
910   FORMAT(A20)
920   FORMAT(' No file specified.')
930   FORMAT(' Ambiguous qualifier ',A)
940   FORMAT(' Unable to open output file ',A)
950   FORMAT(' Unknown qualifier ignored, 'A)
960   FORMAT(
     $ ' ERROR - incompatible input and output file specifications :'/,
     $ X,A,5X,A,/
     $ ' When the input parameter is specified as a list, ',/,
     $ ' The output spec must contain a wildcard (e.g., *.TXT).')
970   FORMAT(
     $ ' ERROR - Illegal parameter ',A,/,
     $ ' A list with wildcards makes no sense on output.')
980   FORMAT(
     $ ' ERROR - There are more files in the input list than in ',
     $ 'the output list.')
990   FORMAT(
     $ ' ERROR - FILTER requires at least one qualifier,',/,
     $ '         Enter HELP FILTER for details.')
      END
C
C---END FILTER
C
      SUBROUTINE FILTER_MAIN ( INFILE, OUTFILE )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          FILTER           **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     PROGRAM :
C*          FILTER
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     PURPOSE :
C*          FILTER REPLACES CHARACTERS OR STRINGS WITH OTHER CHARACTERS
C*          OR STRINGS ACCORDING TO USER INPUT.  CAPITALIZATION, LOWER-
C*          CASIFICATION, ASCII TO STRING, STRING TO ASCII, AND UNTAB
C*          ARE BUILT IN.
C*
C*     QUALIFIERS :
C*          /ASCII   - REPLACE "DEASCII" STRINGS WITH ASCII CHARACTERS
C*          /AT      - USED WITH "UNTAB" TO SET TAB STOPS AT THESE LOCATIONS
C*          /CAPS    - CAPITALIZE
C*          /DEASCII - REPLACE ASCII CONTROL CHARACTERS WITH STRINGS
C*          /EVERY   - USED WITH "UNTAB" TO SET TAB STOPS EVERY NUM OF COLUMNS
C*          /EXACT   - MAKES CASE OF STRINGS MEANINGFULL
C*          /EXCLUDE - EXCLUDES FILES FROM PROCESSING
C*          /FILE=   - LOAD LIST OF STRINGS FROM A FILE
C*          /FORTRAN - USE FORTRAN STYLE SOURCE CODE WITH "UNTAB"
C*          /KEYBOARD- INPUT LIST OF STRING FROM KEYBOARD
C*          /LOG     - LIST ALL CHANGES AS MADE
C*          /LOWER   - MAKE CAPS LOWER CASE
C*          /OUTPUT  - REDIRECTS OUTPUT TO A FILE
C*          /UNTAB   - REPLACE TABS WITH SPACES (COL MOD 8 = 0)
C*          /ZBIT    - ZERO THE EIGHTH BIT OF ALL CHARACTERS
C*
C*     PARAMETERS :
C*          FILESPEC - FILESPEC OR LIST OF FILESPECS (WILDCARDS OK)
C*
C*     COMMON BLOCKS :
C*          SWITCH
C*
C*     SUBPROGRAM REFERENCES :
C*          GETSET,  GETFILE,  CONVERT
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          ALL OF THE FILE HANDLING SECTION IS NONTRANSPORTABLE
C*          ASCII COLLATING SEQUENCE IS EXPECTED
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.0  -  11-MAR-1988
C*
C*     CHANGE HISTORY :
C*          11-MAR-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      CHARACTER *(*) INFILE, OUTFILE
      COMMON / SWITCH / DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB,
     $   ZBIT, VERIFY, MADE_CHANGES, FORTRAN, CONFIRM
      LOGICAL DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB, ZBIT, VERIFY
      LOGICAL MADE_CHANGES, FORTRAN, CONFIRM
      CHARACTER *255 LINE
      CHARACTER *80 MESS
      CHARACTER ATYPE*10, CTYPE*7, OTYPE*10, RTYPE*10

C
      made_changes = .false.
      MESS = ' '
      OPEN (UNIT=60, STATUS='OLD', READONLY, ERR=3000, FILE=INFILE)
      INQUIRE (UNIT=60, ACCESS=ATYPE, CARRIAGECONTROL=CTYPE, 
     $ ORGANIZATION=OTYPE, RECL=LREC, RECORDTYPE=RTYPE)
      IF (ATYPE .NE. 'SEQUENTIAL') THEN
         MESS = 'File is not a SEQUENTIAL file.'
         GO TO 4000
      ELSE IF ((CTYPE .NE. 'FORTRAN') .AND. (CTYPE .NE. 'LIST')) THEN
         MESS = 'Illegal carriage control type.'
         GO TO 4000
      ELSE IF (OTYPE .NE. 'SEQUENTIAL') THEN
         MESS = 'File organization is not sequential.'
         GO TO 4000
      ELSE IF (LREC .GT. 255) THEN
         MESS = 'Records too long.'
         GO TO 4000
      ELSE IF ((RTYPE .NE. 'FIXED') .AND. (RTYPE .NE. 'VARIABLE') .AND.
     $         (RTYPE(1:6) .NE. 'STREAM')) THEN
         MESS = 'Illegal record type.'
         GO TO 4000
      ENDIF
C
      OPEN (UNIT=61, STATUS='NEW', CARRIAGECONTROL='LIST',
     $       FILE=OUTFILE, DISPOSE='DELETE', ERR=2000 )
      WRITE(6,950) INFILE(1:LENGTH(INFILE))
C
10    READ(60,900,END=1000) L, LINE
      IF (L .GT. 0) THEN
         CALL CONVERT ( LINE, L )
         WRITE(61,910) LINE(1:L)
      ELSE
         WRITE(61,920)
      ENDIF
      GO TO 10
C
C --- END OF FILE ENCOUNTERED, CLOSE THESE FILES, GO TO NEXT FILE IN
C      LIST
C
1000  CLOSE(60)
      IF (MADE_CHANGES) THEN
         CLOSE(61, STATUS='KEEP')
      ELSE
         CLOSE(61)
      ENDIF
      RETURN
C
2000  WRITE(6,930) OUTFILE(1:LENGTH(OUTFILE))
      CLOSE(60)
      RETURN
C
3000  WRITE(6,940) INFILE(1:LENGTH(INFILE))
      RETURN
C
4000  CLOSE(UNIT=60)
      WRITE(6,960) INFILE(1:LENGTH(INFILE)), MESS(1:LENGTH(MESS))
      RETURN
C
900   FORMAT(Q,A)
910   FORMAT(A)
920   FORMAT()
930   FORMAT(' Unable to open output file ',/,'    ',A)
940   FORMAT(' Unable to open input file ',/,'    ',A)
950   FORMAT(' FILTERing file ',A)
960   FORMAT(' Skipping file ',A,' because:',/,'     ',A)
      END
C
C---END FILTER_MAIN
C
      SUBROUTINE GETSET (Q, NQ)
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          GETSET           **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     SUBPROGRAM :
C*          GETSET
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     PURPOSE :
C*          INITIALIZE SWITCHES AND GET FILE NAME(S)
C*
C*     COMMON BLOCKS :
C*          STRINGS, SWITCH
C*
C*     SUBPROGRAM REFERENCES :
C*          GETSTUFF, EXIT
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          USES VMS PARAMETER/QUALIFIER ROUTINES
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.0  -  11-MAR-1988
C*
C*     CHANGE HISTORY :
C*          11-MAR-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      COMMON / STOPS / ITAB(50)
      COMMON / STRINGS / STRING(500), REPLAC(500), LENS(500),
     $   LENR(500), NS
      COMMON / SWITCH / DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB,
     $   ZBIT, VERIFY, MADE_CHANGES, FORTRAN, CONFIRM
      LOGICAL DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB, ZBIT, VERIFY
      LOGICAL MADE_CHANGES, FORTRAN, CONFIRM
      CHARACTER *80 STRING, REPLAC, Q(NQ)
      CHARACTER TEMP*20, TYPE*1
      LOGICAL ERROR
      CHARACTER *5 TABLE(0:32)
      DATA TABLE /'<NUL>',  '<SOH>',  '<STX>',  '<ETX>',  '<EOT>',
     $  '<ENQ>',  '<ACK>',  '<BEL>',  '< BS>',  '< HT>',  '< LF>',
     $  '< VT>',  '< FF>',  '< CR>',  '< SO>',  '< SI>',  '<DLE>',
     $  '<DC1>',  '<DC2>',  '<DC3>',  '<DC4>',  '<NAK>',  '<SYN>',
     $  '<ETB>',  '<CAN>',  '< EM>',  '<SUB>',  '<ESC>',  '< FS>',
     $  '< GS>',  '< RS>',  '< US>',  '<DEL>' /
C
      NS = 0
C
C --- QUALIFIERS
C ---   UPPER(CAPS), LOWER, ASCII, DEASCII, FILE=, KEYBOARD, LOG,
C ---   AT, EVERY
C
      ASCII   = .FALSE.
      CONFIRM = .FALSE.
      DEASCII = .FALSE.
      EXACT   = .FALSE.
      EXTAB   = .FALSE.
      FORTRAN = .FALSE.
      LWER    = .FALSE.
      UPPER   = .FALSE.
      VERIFY  = .FALSE.
      ZBIT    = .FALSE.
      MADE_CHANGES = .FALSE.
      DO 10 I = 1, NQ
         IF (Q(I)(1:1) .EQ. 'A') THEN
C
C ----- /ASCII
C
            IF (Q(I)(2:2) .EQ. 'S') THEN
               ASCII = .TRUE.
               DO 30 II = 0,31
                  NS = NS + 1
                  STRING(NS) = TABLE(II)
                  REPLAC(NS) = CHAR(II)
                  LENS(NS)   = 5
                  LENR(NS)   = 1
30                CONTINUE
               NS = NS + 1
               STRING(NS) = TABLE(32)
               REPLAC(NS) = CHAR(127)
               LENS(NS)   = 5
               LENR(NS)   = 1
C
C ----- /AT
C
            ELSE IF (Q(I)(2:2) .EQ. 'T') THEN
               IPT = INDEX(Q(I),'(') + 1
               IF (IPT .EQ. 1) THEN
                  IPT = INDEX(Q(I),'=') + 1
                  IF (IPT .EQ. 1) GO TO 4000
               ENDIF
               ITP = 0
5              CALL GETOKE (Q(I), 80, IPT, TEMP, TYPE, ERROR)
               IF ((TEMP .EQ. ')') .OR. (TYPE .EQ. 'E')) GO TO 10
               IF (ERROR .OR. (TYPE .NE. 'I')) GO TO 4000
               CALL RIGHT ( TEMP )
               READ(TEMP,980) ITEMP
               IF ((ITEMP .LT. 1) .OR. (ITEMP .GT. 255)) GO TO 4000
               IF ((ITP .GT. 0) .AND. (ITEMP .LE. ITAB(ITP)))
     $                 GO TO 4000
               IF (ITP .EQ. 50) THEN
                  ITAB(ITP) = 1000
               ELSE
                  ITP = ITP + 1
                  ITAB(ITP) = ITEMP
                  GO TO 5
               ENDIF
            ELSE
               GO TO 3000
            ENDIF
C
C ----- /CAPS OR /CONFIRM
C
         ELSE IF (Q(I)(1:1) .EQ. 'C') THEN
            IF (Q(I)(2:2) .EQ. 'A') THEN
               UPPER = .TRUE.
            ELSE IF (Q(I)(2:2) .EQ. 'O') THEN
               CONFIRM = .TRUE.
            ELSE
               GO TO 3000
            ENDIF
C
C ----- /DEASCII
C
         ELSE IF (Q(I)(1:1) .EQ. 'D') THEN
            DEASCII = .TRUE.
            DO 20 II = 0, 31
               NS = NS + 1
               STRING(NS) = CHAR(II)
               REPLAC(NS) = TABLE(II)
               LENS(NS)   = 1
               LENR(NS)   = 5
20          CONTINUE
            NS = NS + 1
            STRING(NS) = CHAR(127)
            REPLAC(NS) = TABLE(32)
            LENS(NS)   = 1
            LENR(NS)   = 5
         ELSE IF (Q(I)(1:1) .EQ. 'E') THEN
C
C ----- /EXACT
C
            IF (Q(I)(2:3) .EQ. 'XA') THEN
               EXACT = .TRUE.
C
C ----- /EVERY
C
            ELSE IF (Q(I)(2:2) .EQ. 'V') THEN
               IPT = INDEX(Q(I),'(') + 1
               IF (IPT .EQ. 1) THEN
                  IPT = INDEX(Q(I),'=') + 1
                  IF (IPT .EQ. 1) GO TO 4000
               ENDIF
               CALL GETOKE (Q(I), 80, IPT, TEMP, TYPE, ERROR)
               IF (TYPE .NE. 'I') GO TO 4000
               CALL RIGHT(TEMP)
               READ(TEMP,980) ITEMP
               IF ((ITEMP .LT. 1) .OR. (ITEMP .GT. 100)) GO TO 4000
               ITP = 1
               ITAB(ITP) = 1
7              ITP = ITP + 1
               ITAB(ITP) = ITAB(ITP-1) + ITEMP
               IF (ITAB(ITP) .LT. 255) GO TO 7
            ELSE IF (Q(I)(2:2) .EQ. 'X') THEN   ! NOTHING
            ELSE
               GO TO 3000
            ENDIF
C
C ----- /FILE
C
         ELSE IF (Q(I)(1:2) .EQ. 'FI') THEN
            CALL GETSTUFF ( .TRUE., Q(I) )
C
C ----- /FORTRAN
C
         ELSE IF (Q(I)(1:2) .EQ. 'FO') THEN
            FORTRAN = .TRUE.
            ITP = 1
            ITAB(ITP) = 7
9           ITP = ITP + 1
            ITAB(ITP) = ITAB(ITP-1) + 3
            IF (ITAB(ITP) .LT. 255) GO TO 9
C
C ----- /KEYBOARD
C
         ELSE IF (Q(I)(1:1) .EQ. 'K') THEN
            CALL GETSTUFF ( .FALSE., Q(I) )
         ELSE IF (Q(I)(1:1) .EQ. 'L') THEN
C
C ----- /LOWER
C
            IF (Q(I)(1:3) .EQ. 'LOW') THEN
               LWER = .TRUE.
C
C ----- /LOG
C
            ELSE
               VERIFY = .TRUE.
            ENDIF
         ELSE IF (Q(I)(1:1) .EQ. 'U') THEN
C
C ----- /UNTAB
C
            IF (Q(I)(2:2) .EQ. 'N') THEN
               EXTAB = .TRUE.
C
C ----- /UPPER
C
            ELSE IF (Q(I)(2:2) .EQ. 'P') THEN
               UPPER = .TRUE.
            ELSE
               GO TO 3000
            ENDIF
C
C ----- /VERIFY
C
         ELSE IF (Q(I)(1:1) .EQ. 'V') THEN
            VERIFY = .TRUE.
C
C ----- /ZBIT
C
         ELSE IF (Q(I)(1:1) .EQ. 'Z') THEN
            ZBIT = .TRUE.
            DO 40 II = 1, 128
               NS = NS + 1
               STRING(NS) = CHAR(II+127)
               LENS(NS) = 1
               REPLAC(NS) = CHAR(II-1)
               LENR(NS) = 1
40          CONTINUE
C
C --- ANYTHING ELSE
C
         ELSE
            GO TO 3000
         ENDIF
10    CONTINUE
C
C --- MAKE SURE ENTRIES AREN'T CONTRADICTORY
C
      IF ((NS .EQ. 0) .AND.
     $    (.NOT. ASCII) .AND.
     $    (.NOT. DEASCII) .AND.
     $    (.NOT. LWER) .AND.
     $    (.NOT. UPPER) .AND.
     $    (.NOT. EXTAB) .AND.
     $    (.NOT. ZBIT)) CALL EXIT(1)
      IF ((ASCII .AND. DEASCII) .OR.
     $    (UPPER .AND. LWER)) THEN
         WRITE(6,*)' Contradictory flags entered, TURKEY.'
         CALL EXIT(1)
      ENDIF
C
C --- UPPER AND LOWER USE SYSTEM ROUTINES.  SINCE WE DON'T
C --- KNOW IF THEY MAKE CHANGES, ASSUME THEY DO.
C
      IF (UPPER .OR. LWER) MADE_CHANGES = .TRUE.
C
      RETURN
3000  WRITE(6,940) Q(I)(1:LENGTH(Q(I)))
      CALL EXIT(1)
4000  WRITE(6,960)
      CALL EXIT(1)
910   FORMAT(A)
930   FORMAT(' File ? ',$)
940   FORMAT(' Ambiguous or unknown qualifier : ',A)
960   FORMAT(' *** Illegal option for tab settings.')
980   FORMAT(15X,I5)
      END
C
C---END GETSET
C
      SUBROUTINE CONVERT ( LINE, L )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          CONVERT          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     SUBPROGRAM :
C*          CONVERT
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     PURPOSE :
C*          CONVERT A SINGLE LINE
C*
C*     INPUT ARGUMENTS :
C*          LINE - LINE TO BE CONVERTED
C*          L    - LENGTH OF LINE
C*
C*     OUTPUT ARGUMENTS :
C*          LINE - NEW LINE (IF NECESSARY)
C*          L    - NEW LENGTH OF LINE
C*
C*     COMMON BLOCKS :
C*          STRINGS, SWITCH
C*
C*     SUBPROGRAM REFERENCES :
C*          CAPS, LOWER, UNTAB
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          NONE
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.0  -  11-MAR-1988
C*
C*     CHANGE HISTORY :
C*          11-MAR-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      COMMON / STRINGS / STRING(500), REPLAC(500), LENS(500),
     $   LENR(500), NS
      COMMON / SWITCH / DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB,
     $   ZBIT, VERIFY, MADE_CHANGES, FORTRAN, CONFIRM
      LOGICAL DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB, ZBIT, VERIFY
      LOGICAL MADE_CHANGES, FORTRAN, CONFIRM
      LOGICAL OK, ERR
      CHARACTER *255 CLINE, TLINE
      CHARACTER *80 STRING, REPLAC
      CHARACTER *(*) LINE
C
      LP = 1
C
C --- CAPS OR LOWER
C
      IF (UPPER) THEN
         CALL CAPS ( LINE )
      ELSE IF (LWER) THEN
         CALL LOWER ( LINE )
      ENDIF
C
C --- UNTAB
C
      IF ( EXTAB ) CALL UNTAB ( L, LINE )
C
C --- CHECK THE LIST OF STRINGS
C
      CLINE = LINE
      IF (.NOT. EXACT) CALL CAPS(CLINE)
5     DO 10 I = 1, NS
C
C  -----  CHECK TO SEE IF THIS STRING IS AT THIS POSITION IN THE LINE
C
         LS = LENS(I)
         IF ((LS+LP-1) .LE. L) THEN
            IP = LP
            DO 7 J = 1, LS
               IF (CLINE(IP:IP) .NE. STRING(I)(J:J)) GO TO 10
               IP = IP + 1
7              CONTINUE
C
C ------- STRING FOUND... REPLACE IT
C
            LR = LENR(I)
C
C ------- REGULAR REPLACEMENT
C
            IF (LR .GT. 0) THEN
               IF (LP .GT. 1) THEN
                  TLINE = LINE(1:LP-1) // REPLAC(I)(1:LR) //
     $                    LINE(LP+LS:)
               ELSE
                  TLINE = REPLAC(I)(1:LR) // LINE(LP+LS:)
               ENDIF
               IF (CONFIRM) THEN
                  WRITE(6,900) TLINE(1:LENGTH(TLINE))
                  CALL PROMPT ('Make this change ? [Y]')
                  OK = .TRUE.
                  CAll YESNO (OK, ERR)
                  IF (.NOT. OK  .OR. ERR) GO TO 10
               ENDIF
               LINE = TLINE
               CLINE = LINE
               IF (.NOT. EXACT) CALL CAPS ( CLINE )
               L = L + LR - LS
               LP = LP + LR                         ! Inserted 4/20 LEJ
C
C ------- /EDIT FUNCTION
C
            ELSE
               CALL EDIT (LINE, 0, 0)
               L = LENGTH(LINE)
               MADE_CHANGES = .TRUE.
               RETURN
            ENDIF
            IF (VERIFY) WRITE(6,*) LINE(1:L)
            MADE_CHANGES = .TRUE.
         ENDIF
10       CONTINUE
      LP = LP + 1
      IF (LP .LE. L) GO TO 5
      RETURN
900   FORMAT(' ',A)
      END
C
C---END CONVERT
C
      SUBROUTINE GETSTUFF ( FROMFILE, Q )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **         GETSTUFF          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     SUBPROGRAM :
C*          GETSTUFF
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     PURPOSE :
C*          GET THE LIST OF STRINGS TO CHANGE FROM/TO
C*
C*     INPUT ARGUMENTS :
C*          FROMFILE - TO BE READ FROM A FILE?
C*          Q        - QUALIFIER TO BE SEARCHED FOR FILENAME IF FROMFILE
C*
C*     OUTPUT ARGUMENTS :
C*          NONE
C*
C*     COMMON BLOCKS :
C*          STRINGS
C*
C*     SUBPROGRAM REFERENCES :
C*          LENGTH
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          "READONLY" IS VMS-SPECIFIC
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.0  -  11-MAR-1988
C*
C*     CHANGE HISTORY :
C*          11-MAR-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      COMMON / SWITCH / DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB,
     $   ZBIT, VERIFY, MADE_CHANGES, FORTRAN, CONFIRM
      LOGICAL DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB, ZBIT, VERIFY
      LOGICAL MADE_CHANGES, FORTRAN, CONFIRM
      LOGICAL FROMFILE, EXTRACT
      COMMON / STRINGS / STRING(500), REPLAC(500), LENS(500),
     $   LENR(500), NS
      CHARACTER *80 STRING, REPLAC, LINE
      CHARACTER *80 Q, FNAME, A, B
C
C --- READ STRINGS FROM A FILE?
C
      IF (FROMFILE) THEN
         I = INDEX(Q,'=')
         L = LENGTH(Q)
         IF ((I .EQ. 0) .OR. (I .EQ. L)) THEN
            WRITE(6,900) Q
            CALL EXIT(1)
         ENDIF
         FNAME = Q(I+1:L)
         OPEN ( UNIT=62, STATUS='OLD', READONLY, ERR=1000, FILE=FNAME )
         NUNIT = 62
      ELSE
         NUNIT = 5
         WRITE(6,920)
      ENDIF
C
10    READ(NUNIT,930,END=100) LINE
      L = LENGTH(LINE)
      IF (L .GT. 0) THEN
         IF (EXTRACT ( LINE, A, B )) THEN
            IF (.NOT. EXACT) CALL CAPS(A)
            NS = NS + 1
            STRING(NS) = A
            LENS(NS)   = LENGTH(A)
            REPLAC(NS) = B
            IF (B .EQ. '<EDIT>') THEN
               LENR(NS) = -1
            ELSE
               LENR(NS)   = LENGTH(B)
            ENDIF
         ENDIF
      ENDIF
      GO TO 10
100   RETURN
1000  WRITE(6,910) FNAME(1:LENGTH(FNAME))
      CALL EXIT(1)
900   FORMAT(' File option usage: /FILE=filespec',//,' ',A)
910   FORMAT(' Unable to open file ',A)
920   FORMAT(' Enter FROM_STRING TO_STRING one per line, ^Z to exit.',/,
     $       ' Must use double quotes for embedded spaces.'/)
930   FORMAT(A)
      END
C
C---END GETSTUFF
C
      LOGICAL FUNCTION EXTRACT ( LINE, A, B )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          EXTRACT          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     SUBPROGRAM :
C*          EXTRACT
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     PURPOSE :
C*          EXTRACT TWO STRINGS FROM A LINE
C*
C*     INPUT ARGUMENTS :
C*          LINE - THE LINE THAT (PRESUMABLY) CONTAINS TWO STRINGS
C*
C*     OUTPUT ARGUMENTS :
C*          A - FIRST STRING
C*          B - SECOND STRING
C*
C*     COMMON BLOCKS :
C*          NONE
C*
C*     SUBPROGRAM REFERENCES :
C*          LEFT, LENGTH, CONTROLS
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          IF A STRING HAS PUNCTUATION, ENCLOSE IT IN DOUBLE QUOTES
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.0  -  11-MAR-1988
C*
C*     CHANGE HISTORY :
C*          11-MAR-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      CHARACTER *(*) LINE, A, B
C
      EXTRACT = .FALSE.
      CALL LEFT (LINE)
      LL = LENGTH(LINE)
      IL = 1
      DO 100 I = 1,2
         IF (LINE(IL:IL) .EQ. '"') THEN
C
C ----- STRING IS QUOTE DELIMITED
C
            JL = IL
            IL = IL + 1
10          JL = JL + 1
            IF (JL .GT. LL) THEN
               WRITE(6,900) LINE
               RETURN
            ENDIF
C
C ----- TRAILING QUOTE
C
            IF (LINE(JL:JL) .NE. '"') GO TO 10
C
C ----- OR IS IT AN EMBEDDED QUOTE...  "THIS IS A "" STRING WITH A QUOTE"
C
            IF (LINE(JL+1:JL+1) .EQ. '"') THEN
               JL = JL + 1
               GO TO 10
            ENDIF
            IF (I .EQ. 1) THEN
               A = LINE(IL:JL-1)
            ELSE
               B = LINE(IL:JL-1)
            ENDIF
            IL = JL + 1
         ELSE
C
C ----- STRING IS NOT ENCLOSED BY QUOTES
C
            JL = IL - 1
20          JL = JL + 1
            IF (JL .GT. LL) THEN
               IF (I .EQ. 1) THEN
                  WRITE(6,900) LINE
                  RETURN
               ELSE
                  GO TO 30
               ENDIF
            ENDIF
            IF (LINE(JL:JL) .NE. ' ') GO TO 20
30          IF (I .EQ. 1) THEN
               A = LINE(IL:JL-1)
            ELSE
               B = LINE(IL:JL-1)
            ENDIF
            IL = JL
         ENDIF
         IF ( I .EQ. 1 ) THEN
40          IF ((LINE(IL:IL) .EQ. ' ') .AND. (IL .LE. LL)) THEN
               IL = IL + 1
               GO TO 40
            ENDIF
         ENDIF
100      CONTINUE
C
C --- REPLACE  "" WITH "   AND  ^char  WITH CONTROL CHARACTER
C
      CALL CONTROLS ( A )
      CALL CONTROLS ( B )
      EXTRACT = .TRUE.
      RETURN
900   FORMAT(' Don''t understand line: ',/,' ',A)
      END
C
C---END EXTRACT
C
      SUBROUTINE CONTROLS ( X )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **         CONTROLS          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     SUBPROGRAM :
C*          CONTROLS
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     PURPOSE :
C*          REPLACE STRINGS WITH A "^" LEADIN WITH A CONTROL CHARACTER,
C*          REPLACE TWO QUOTES WITH ONE
C*
C*     INPUT ARGUMENTS :
C*          X - STRING WITH "" OR ^CHAR
C*
C*     OUTPUT ARGUMENTS :
C*          X - STRING WITH " OR CONTROL/CHAR
C*
C*     COMMON BLOCKS :
C*          NONE
C*
C*     SUBPROGRAM REFERENCES :
C*          LENGTH, CAPS
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          INPUT STRINGS MUST BE <= 80 CHARACTERS
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.0  -  11-MAR-1988
C*
C*     CHANGE HISTORY :
C*          11-MAR-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      CHARACTER *(*) X
      CHARACTER *80 T
      CHARACTER *1 C
C
      T  = X
      LT = LENGTH (T)
      LX = 0
      I  = 0
      X  = ' '
10    LX = LX + 1
      I  = I + 1
      IF (T(I:I) .EQ. '^') THEN
         I = I + 1
         C = T(I:I)
         IF (C .EQ. '^') THEN
            X(LX:LX) = '^'
         ELSE
            CALL CAPS ( C )
            X(LX:LX) = CHAR (IAND (ICHAR(C), 191))
         ENDIF
      ELSE IF (T(I:I+1) .EQ. '""') THEN
         X(LX:LX) = '"'
         I = I + 1
      ELSE
         X(LX:LX) = T(I:I)
      ENDIF
      IF (I .LT. LT) GO TO 10
      RETURN
      END
C
C--END CONTROLS
C
      SUBROUTINE UNTAB ( L, STRING )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          UNTAB            **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     SUBPROGRAM :
C*          REMOVE TABS
C*
C*     AUTHOR :
C*          ART RAGOSTA
C*          MS 207-5
C*          AMES RESEARCH CENTER
C*          MOFFETT FIELD, CA  94035
C*          (415) 604-5558
C*
C*     PURPOSE :
C*          REPLACE A STRING WITH THE SAME STRING WHERE TABS ARE
C*          REPLACED BY AN APPROPRIATE NUMBER OF BLANKS TO HAVE
C*          SIMILAR SPACING.
C*
C*     INPUT ARGUMENTS :
C*          L      - LENGTH OF INPUT STRING
C*          STRING - STRING FROM WHICH TABS ARE TO BE REMOVED
C*
C*     OUTPUT ARGUMENTS :
C*          L      - LENGTH OF OUTPUT STRING
C*          STRING - SAME STRING WITH BLANKS REPLACING TABS(INPLACE)
C*
C*     INTERNAL WORK AREAS :
C*          ITAB - AN ARRAY CONTAINING THE TAB STOP SETTINGS.
C*          LINE - TEMPORARY STORAGE FOR TABBED STRING.
C*
C*     SUBPROGRAM REFERENCES :
C*          LENGTH
C*
C*     TRANSPORTABILITY LIMITATIONS :
C*          THE NON-STANDARD DATA STATEMENT SETS TAB CHARACTER TO ASCII 9.
C*          ( TRANSPORTABLE VERSION IS COMMENTED )
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.2
C*
C*     CHANGE HISTORY :
C*          18-APR-88    MODIFIED FOR USE WITH FILTER
C*          29-JUL-85    ITPTR FIXED (INITIALIZED)
C*          15-OCT-84    INITIAL VERSION
C*
C***********************************************************************
C*
      COMMON / SWITCH / DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB,
     $   ZBIT, VERIFY, MADE_CHANGES, FORTRAN, CONFIRM
      LOGICAL DEASCII, ASCII, UPPER, LWER, EXACT, EXTAB, ZBIT, VERIFY
      LOGICAL MADE_CHANGES, FORTRAN, CONFIRM
      CHARACTER *(*) STRING
      CHARACTER *255 LINE
      CHARACTER *5 BLANKS
      CHARACTER *1 TAB
      COMMON / STOPS / ITAB(50)
      DATA BLANKS /'     '/
C
C --- NON-STANDARD DATA STATEMENT :
C
      DATA TAB/9/
C
C --- STANDARD REPLACEMENT FOR ABOVE DATA STATEMENT :
C     TAB = CHAR ( 9 )
C
      LINE   = STRING
      STRING = ' '
      LL     = LEN(STRING)
      K      = 1
      ITPTR  = 1
C
C --- IF USING /FORTRAN UNTABBING, MUST USE UNIQUE FORMAT
C
      IF (FORTRAN) THEN
         I = INDEX(LINE,TAB)
         IF ((I .GT. 0) .AND. (I .LT. 6)) THEN
            IF ((LINE(I+1:I+1) .GE. '1') .AND.
     $          (LINE(I+1:I+1) .LE. '9')) THEN
               IF (I .EQ. 1) THEN
                  LINE = '     $' // LINE(I+2:)
               ELSE
                  LINE = LINE(1:I-1) // BLANKS(I:5) // '$' // LINE(I+2:)
               ENDIF
            ELSE
               IF (I .EQ. 1) THEN
                  LINE = '      ' // LINE(I+1:)
               ELSE
                  LINE = LINE(1:I-1) // BLANKS(I:5) // ' ' // LINE(I+1:)
               ENDIF
            ENDIF
            MADE_CHANGES = .TRUE.
            L = L + 6 - I
         ELSE IF (I .EQ. 6) THEN
            LINE(6:6) = ' '
            MADE_CHANGES = .TRUE.
         ENDIF
      ENDIF
C
      DO 20 I = 1,L
         IF ( LINE(I:I) .EQ. TAB ) THEN
            MADE_CHANGES = .TRUE.
C
C ------ FIND NEXT TAB STOP
C
5            IF ( K .GE. ITAB(ITPTR)) THEN
                ITPTR = ITPTR + 1
                GO TO 5
             ENDIF
C
C ------ SKIP BLANKS TO TAB STOP ( ALREADY BEEN INITIALIZED TO BLANKS )
C
10           IF ( K .LT. ITAB(ITPTR)) THEN
                K = K + 1
                GO TO 10
             ENDIF
          ELSE
C
C ------ COPY NON-TAB CHARACTERS
C
             STRING(K:K) = LINE(I:I)
             K = K + 1
          ENDIF
          IF ( K .GT. LL ) GO TO 30
20        CONTINUE
30    L = LENGTH (STRING)
      RETURN
      END
C
C---END UNTAB
C
      BLOCK DATA
      COMMON / STOPS / ITAB(50)
      DATA ITAB /
     $   9,  17,  25,  33,  41,  49,  57,  65,  73,  81,  89,  98,
     $ 106, 114, 122, 130, 138, 146, 154, 162, 170, 178, 186, 195,
     $ 203, 211, 219, 227, 235, 243, 251, 10000, 18*0 /
      END
C
C---END BLOCK DATA
C
