      program check_mail
c*
C*     Arthur E. Ragosta
C*     RAGOSTA%MRL.SPAN@IO.ARC.NASA.GOV
C*     MS 219-3
C*     NASA Ames Research Center
C*     Moffett Field, Ca.  94035
C*     (415) 694-5558
C*
c*     Check to see if this user has new mail messages...
c*     Set the logical NEW_MAIL to a message showing the number.
c*
      Character *2048 mail_record, field_text_char
      character *80 mess
      character *12 user
      Character *4 field_type_char, field_length_char, count
c
      Integer status, size
      Integer*2 field_type, field_length, field_begin, field_end
      Integer*2 field_text, position, newmail_count
C
      Equivalence(field_type_char,field_type)
      Equivalence(field_length_char,field_length)
      Equivalence(field_text_char(1:2),field_text)
c
      newmail_count = -1
      call getuser (user)
c
C Open the mail file.
C
       OPEN(1,NAME='SYS$SYSTEM:VMSMAIL_PROFILE.DATA',READONLY,
     +      ACCESS='KEYED',ORGANIZATION='INDEXED',STATUS='OLD',
     +      SHARED,IOSTAT=STATUS,FORM='FORMATTED')
       If (status .ne. 0) go to 100
C
C Read this user's record
C
      Read(1,'(q,a)',key=user(1:length(user)),iostat=status)
     $       size,mail_record(1:size)
      If (status .ne. 0) go to 100
C
C *** If you reach this point, record found on mail file. Now analyze the
C *** record's contents. Following the username field (length 31) are appended
C *** a series of variable length fields. The variable data format is a
C *** sequence of data fields in the following format:
C          Field type           WORD
C          Field length         WORD
C          Data                 STRING/WORD depending on field type
C
      position = 32
      Do while (position .le. size)
         field_end = position + 1
         field_type_char = mail_record(position:field_end)
         field_begin = position + 2
         field_end = position + 3
         field_length_char = mail_record(field_begin:field_end)
         field_begin = position + 4
         field_end = field_begin + field_length - 1
         field_text_char = mail_record(field_begin:field_end)
         position = field_end + 1
         If (field_type .eq. 1) then
C           (If true, then data field contains value of new mail count)
            newmail_count = field_text
            goto 100
         endif
       end do
c
c --- we now have the mail count, set it !
c
100   if (newmail_count .lt. 0) then
         write(mess, 910) user(1:length(user))
      else
         write (count,900) newmail_count
         call left (count)
         write (mess,920) user(1:length(user)), count(1:length(count))
      endif 
      CALL LIB$SET_SYMBOL ('NEW_MAIL', mess(1:length(mess)))
      call exit
900   format(i4)
910   format('Unable to get mail info for user ',a)
920   format('User ',a,' has ',a,' new message(s).')
      end
