/*******************************************************************************
*	NOPE - Nopurge utility.  NOPE was born out of the need for a way to
* determine which files would be purged if a purge were done.  The user should
* define a symbol "NOPE :==$SYS$PRIV:NOPE" which will allow the user to use the
* NOPE utility thusly;
*			NOPE		(same as NOPE *.*;*)
*			NOPE [...]	(same as NOPE [...]*.*;*)
*			NOPE *.C	(examine only files with extension '.C')
*			NOPE DEV:[*...]	(examine entire disk
*
*	Each directory that has files matching the filespec are displayed, but
* only those files which would be purged are displayed.  The allocated block
* count is displayed for each file, and a total line is displayed at the end.
*
*	This program is an example of the use of the RMS routines $PARSE,
* $SEARCH, $OPEN and $CLOSE.  First, $PARSE 'sets up' for the search.  Then the
* $SEARCH is performed in a loop.  Also within the loop, $OPEN and $CLOSE are
* invoked to determine file allocation only if necessary.
*******************************************************************************/
#include <descrip.h>
#include <file.h>
#include <rms.h>
#include <iodef.h>
#include <ssdef.h>

main(argc,argv)
int argc;
char *argv[];
{
	struct FAB wild_fab;		/* Used in wildcard search */
	struct NAM wild_nam;		/* Used in conjunction with wild_fab */
	struct FAB size_fab;		/* Used in retreiving file allocation */

	char template[] = "*.*;*";	/* Default template */
	char fullname[256];		/* Input file spec given by user */
	char expanded[256];		/* File spec after logical expansion */
	char result[256];		/* Result from search */
	char last_name[256];		/* Last search result */
	char last_dir[256];
	char *pointer1;
	int tot_blocks, tot_files, this_dirlen, last_dirlen, compare_namlen;
	int last_namlen, this_namlen, compare_dirlen, counter;
	register status;

/* Initialize the wildcard FAB & NAM */
	wild_fab = cc$rms_fab;
	wild_nam = cc$rms_nam;

	wild_fab.fab$l_fna = fullname;
	wild_fab.fab$b_fac = FAB$M_GET;
	wild_fab.fab$l_fop = FAB$V_NAM;
	wild_fab.fab$l_nam = &wild_nam;
	wild_fab.fab$l_dna = template;
	wild_fab.fab$b_dns = strlen(template);

	wild_nam.nam$l_esa = expanded;
	wild_nam.nam$b_ess = 255;
	wild_nam.nam$l_rsa = result;
	wild_nam.nam$b_rss = 255;

/* Initialize the size FAB & NAM */
	size_fab = cc$rms_fab;

	size_fab.fab$l_fna = result;
	size_fab.fab$b_fac = FAB$M_GET;
	size_fab.fab$b_shr = FAB$M_SHRGET;

/* First parse the file spec given to us */
	argv++;
	if (argc == 1)
		strcpy(fullname,template);
	    else
		sscanf(*argv,"%s",&fullname);
	wild_fab.fab$b_fns = strlen(fullname);
	if (((status = SYS$PARSE(&wild_fab)) &1) != 1)
		{
		printf("Error %d on parse\n",status);
		exit(status);
		}

/* Main loop */
	for(tot_blocks = tot_files = last_namlen = last_dirlen = 0;;)
		{
		if (((status = SYS$SEARCH(&wild_fab)) &1) != 1)
			{
			if (status == RMS$_NMF)
				break;
			    else
				{
				printf("Error %d on search\n",status);
				exit(status);
				}
			}

		expanded[wild_nam.nam$b_esl] = 0;
		result[wild_nam.nam$b_rsl] = 0;

		/* Establish some pointers and counters for comparison */
		for (counter=0;result[counter] != 0;counter++)
			{
			if (result[counter] == ']')
				this_dirlen = counter + 1;
			if (result[counter] == '\;')
				{
				this_namlen = counter - this_dirlen;
				break;
				}
			}
		pointer1 = &result[this_dirlen];

		/* Compare directories, print if new directory */
		if (this_dirlen > last_dirlen)
			compare_dirlen = this_dirlen;
		    else
			compare_dirlen = last_dirlen;
		if (strncmp(last_dir,result,compare_dirlen) != 0)
			{
			last_namlen = this_namlen;
			strncpy(last_name,pointer1,this_namlen);
			last_name[this_namlen] = '\0';
			last_dirlen = this_dirlen;
			strncpy(last_dir,result,this_dirlen);
			last_dir[this_dirlen] = '\0';
			printf("	%s\n",last_dir);
			continue;
			}
			
		/* Compare filename, print if this file would be purged */
		if (this_namlen > last_namlen)
			compare_namlen = this_namlen;
		    else
			compare_namlen = last_namlen;
		if (strncmp(last_name,pointer1,compare_namlen) == 0)
			{
			size_fab.fab$b_fns = strlen(result);
			if (((status = SYS$OPEN(&size_fab)) &1) != 1)
				{
				if (status == RMS$_FLK)
					{
					printf("%-30s<file locked>\n",
						(strchr(result,']') + 1));
					tot_files++;
					continue;
					}
				printf("Error %d on open\n",status);
				exit(status);
				}

			if (((status = SYS$CLOSE(&size_fab)) &1) != 1)
				{
				printf("Error %d on close\n",status);
				exit(status);
				}

			printf("%-30s	%d\n",(strchr(result,']') + 1),
				size_fab.fab$l_alq);
			tot_files++;
			tot_blocks += size_fab.fab$l_alq;
			}
		   else
			{
			last_namlen = this_namlen;
			strncpy(last_name,pointer1,this_namlen);
			last_name[this_namlen] = '\0';
			}
		}

	printf("\n	%d total blocks in %d files\n",
		tot_blocks,tot_files);
	exit(SS$_NORMAL);
}
