      PROGRAM RPURGE 
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          RPURGE           **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     PROGRAM :
C*          REVERSE PURGE
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5578
C*
C*     PURPOSE :
C*          DO A "REVERSE" PURGE... IN OTHER WORDS, DELETE ALL BUT THE
C*          OLDEST VERSION OF THE FILE(S)
C*
C*     SUBPROGRAM REFERENCES :
C*          GETFOR,  PARSE,  LIB$FIND_FILE,  PROMPT,  YESNO,  DELETE
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          NOT TRANSPORTABLE
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.0  -   8-SEP-1988
C*
C*     CHANGE HISTORY :
C*           8-SEP-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*                            
      include '($rmsdef)'
      character *120 name, newname, lastname, thisname
      character *80 q(2), p(2)
      logical confirm, log, confirmed, err
c
      confirm = .false.
      log = .false.
      num = 0
c
c --- Get file name and flags
c
      call getfor (nq, q, np, p)
      if (np .eq. 0) then
         name = '*.*;*'
      else
         name = p(1)
      endif
      call parse ( name, '*.*;*', 'FULL', newname )
c
      DO 10 I = 1, nq
         if (q(i)(1:1) .eq. 'C') confirm = .true.
         if (q(i)(1:1) .eq. 'L') log = .true. 
10    CONTINUE
c
c --- initialize wildcard search
c
      icon = 0
      lastname = ' '
      i = 0
c
c --- get single file name
c
20    istat = lib$find_file ( newname, thisname, icon,,,,)
      if ((istat .eq. rms$_nmf) .or. (istat .eq. rms$_fnf)) go to 100
c
c --- if the latest filename is the same as the previous (except for the
c ---  version number), delete the previous name since it is the more
c ---  recent version
c
      i = index(thisname,';')
      if (thisname(:i) .eq. lastname(:j)) then
         if (confirm) then
            call prompt ( 6, 'Delete file ' //
     $            lastname(1:length(lastname)) // ' (Y/N) ?')
            call yesno ( 5, confirmed, err )
            if (err) then
               write(6,*)'Illegal response.'
               go to 100
            endif
            if (confirmed) then
               call delete ( lastname, err )
               if (err) go to 1000
               num = num + 1
               if (log) write(6,*) lastname(1:length(lastname)) //
     $                             ' deleted.'
            endif
         else
            call delete ( lastname, err )
            if (err) go to 1000
            num = num + 1
            if (log) write(6,*) lastname(1:length(lastname)) //
     $                          ' deleted.'
         endif
      endif
      lastname = thisname
      j = i
      go to 20
c
c --- all done
c
1000  write(6,*)'Fatal error, unable to delete '//lastname
100   if (num .eq. 0) write(6,*)'No files reverse purged.'
      call exit
      END
C
C---END RPURGE
C
