      PROGRAM GROK_MAIN
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **        GROK_MAIN          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     AUTHOR :
C*          Arthur E. Ragosta  
C*          RAGOSTA@MERLIN.ARC.NASA.GOV
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     DESCRIPTION :
C*          THIS PROGRAM STUB IS USED AS THE FRONT END FOR THE ARTA
C*          TOOLS WHICH PROCESS FILES.   IT CHECKS FOR QUALIFIERS AND
C*          A LIST OF FILES.  THE FILE LIST IS PARSED AND THE FILES ARE
C*          PASSED ONE AT A TIME TO THE TOOLS MAIN PROGRAM.
C*
C*          THE FOLLOWING QUALIFIERS ARE PROCESSED HERE, BUT ARE NOT
C*          STRIPPED OFF:
C*             /OUTPUT=FILE            /EXCLUDE=LIST
C*
C*     SUBPROGRAM REFERENCES :
C*          GETFOR,  EXIT,  LEFT,  GETFILE,  GROK
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*           8-MAR-1989  -  INITIAL VERSION
C*           8-APR-1990  -  IMPROVED PRINTOUT
c*          10-apr-1990  -  Added /TOTAL flag
C*
C***********************************************************************
C*
      CHARACTER *40 P(2), Q(3), WORK
      CHARACTER *127 FILES, ONEFILE, DEFILE, EXFILE
C**
C** --- NOTE: THE FOLLOWING ARRAY MUST INCLUDE ANY QUALIFIERS USED
C**           BY THE CALLED ROUTINE
C**
      PARAMETER (NQUALS=3)
      CHARACTER *40 QUALS(NQUALS), FNAME
      LOGICAL MATCHD, AMBIG, totals
      DATA QUALS/  'TOTAL',  'OUTPUT',   'EXCLUDE'/
C
C --- GET USER PARAMETERS AND QUALIFIERS
C
      CALL GETFOR (NQ, Q, NP, P)
C
C --- IF THE USER DIDN'T ENTER A FILE LIST ON THE COMMAND LINE, ASK 
C ---  FOR IT
C
      IF (NP .EQ. 0) THEN
         WRITE(6,900)
         READ(5,910) P(1)
      ENDIF
C
C --- MAYBE HE CHANGED HIS MIND?
C
      IF (P(1) .EQ. ' ') THEN
         WRITE(6,920)
         CALL EXIT(1)
      ENDIF
C
C --- OK, WE HAVE THE FILE LIST NOW
C
      CALL LEFT(P(1))
      FILES = P(1)
      EXFILE = ' '
      DEFILE = ' '
      totals = .false.
C
C --- LET'S CHECK OUT THE QUALIFIERS
C
      IF (NQUALS .GT. 1) CALL QSORT (QUALS, NQUALS, WORK)
      DO 10 I = 1, NQ
         L = INDEX(Q(I),'=') - 1
         IF (L .LE. 0) L = LENGTH(Q(I)) 
         CALL SEARCH (QUALS, NQUALS, Q(I)(1:L), K,
     $            MATCHD, AMBIG)
C
         IF (AMBIG) THEN
            WRITE(6,930) Q(I)
            CALL EXIT(1)
         ENDIF
C
         IF (MATCHD) THEN
            IF (QUALS(K) .EQ. 'OUTPUT') THEN
               FNAME = Q(I)(L+2:)
               IF (FNAME .NE. ' ') THEN
                  CLOSE (UNIT=6)
                  OPEN (UNIT=6, FILE=FNAME, STATUS='NEW', ERR=1000)
               ENDIF
            ELSE IF (QUALS(K) .EQ. 'EXCLUDE') THEN
               EXFILE = Q(I)(L+2:)
            else    ! Total
               totals = .true.
            ENDIF
         ELSE
            WRITE (6,950) Q(I)
         ENDIF
10    CONTINUE
C
C
C --- OK, NOW LET THE TOOL DO ITS STUFF
C
C
C --- EXTRACT FILE NAMES ONE AT A TIME
C
      nl_total = 0
      nw_total = 0
      nc_total = 0
      lmn_total = 100000000
      lmx_total = 0
      mp_total = 0
100   CALL GETFILE ( FILES, ONEFILE, DEFILE, EXFILE )
      IF (ONEFILE .NE. ' ') THEN
         CALL GROK ( ONEFILE, nl, nw, nc, lmn, lmx, mp )
         nl_total = nl_total + nl
         nw_total = nw_total + nw
         nc_total = nc_total + nc
         if (lmn .lt. lmn_total) lmn_total = lmn
         if (lmx .gt. lmx_total) lmx_total = lmx
         if (mp .gt. mp_total) mp_total = mp
         GO TO 100
      ENDIF
      if (totals) write(6,960) char(27)//'[7m',  char(27)//'[0m',
     $               nl_total, nw_total, nc_total, lmn_total,
     $               lmx_total, mp_total
      CALL EXIT(1)
C
1000  WRITE(6,940) Q(I)
      CALL EXIT(1)
C
900   FORMAT(' File ? ',$)
910   FORMAT(A20)
920   FORMAT(' No file specified.')
930   FORMAT(' Ambiguous qualifier ',A)
940   FORMAT(' Unable to open output file ',A)
950   FORMAT(' Unknown qualifier ignored, 'A)
960   format(/'   ==== ',a,' Grand totals ',a,' ===='/
     $ ' Number of lines = ',i10,/,
     $ ' Number of words = ',i10,/,
     $ ' Number of chars = ',i10,/,
     $ ' Shortest line   = ',i10,/,
     $ ' Longest line    = ',i10,/,
     $ ' Longest page    = ',i10)
      END
C
C---END GROK_MAIN
C
      SUBROUTINE GROK ( NEWFILE, nlines, nwords, nchar, lmin, lmax,
     $   mpage )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **         GROK_MAIN         **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     AUTHOR :
C*          Arthur E. Ragosta  
C*          RAGOSTA@MERLIN.ARC.NASA.GOV
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5578
C*
C*     DESCRIPTION :
C*          THIS PROGRAM SCANS A TEXT FILE AND PRINTS OUT SOME 
C*           INFORMATION ABOUT IT (LINE SIZE, TABS, CARRIAGE CONTROL, 
C*           ETC.)
C*
C*     INPUT ARGUMENTS :
C*          NEWFILE - THE FILE REQUESTED
C*          NQ, Q, NP, P - NOT USED
C*
C*     SUBPROGRAM REFERENCES :
C*          LEFT,  EXIT
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          CHECKS FOR THE VAX-SPECIFIC CARRIAGE CONTROL ATTRIBUTE
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*           8-MAR-1989  -  INITIAL VERSION
C*
C***********************************************************************
C*
      CHARACTER *(*) NEWFILE
      CHARACTER *256 LINE
      CHARACTER *40 CC
      CHARACTER *23 CDATE, RDATE, EDATE, BDATE
      CHARACTER *10 CPAGE, temp, temp1, temp2
      CHARACTER *1 TAB
      LOGICAL INWORD, TABS
      DATA NOUT, NUNIT, TAB /6,60,9/
C
      CALL FILE_DATES ( NEWFILE, CDATE, RDATE, EDATE, BDATE )
      OPEN (UNIT=NUNIT, READONLY, STATUS='OLD', NAME=NEWFILE, ERR=1000)
      WRITE (NOUT,930) CHAR(27) // '[7m ' //
     $   NEWFILE(1:LENGTH(NEWFILE)) // ' ' // CHAR(27) // '[0m'
      WRITE (NOUT,960) CDATE(1:11)
      IF (CDATE(1:11) .NE. RDATE(1:11)) THEN
         WRITE (NOUT,970) RDATE(1:11)
      ELSE
         WRITE (NOUT,980)
      ENDIF
C
C --- GET FILE'S CARRIAGE CONTROL TYPE
C
      INQUIRE (UNIT=NUNIT, CARRIAGECONTROL=CC)
C
C --- RESET ALL COUNTERS AND FLAGS
C
      LMAX   = 0
      LMIN   = 512
      NLINES = 0
      NWORDS = 0
      NCHAR  = 0
      IPAGE  = 0
      MPAGE  = 0
      TABS   = .FALSE.
C
C --- CHECK EACH LINE OF THE FILE
C
10    READ(NUNIT,900,END=500,ERR=600) LINE
C
C --- FORM FEEDS SEPERATE PAGES
C
      IF (LINE(1:1) .EQ. CHAR(12)) THEN
         IF (IPAGE .GT. MPAGE) MPAGE = IPAGE
         IPAGE = 0
      ENDIF
      IPAGE = IPAGE + 1
      NLINES = NLINES + 1
      LL     = LENGTH(LINE)
C
C --- SEE IF THIS LINE IS THE SHORTEST OR LONGEST TO DATE
C
      IF (LL .GT. LMAX) LMAX = LL
      IF (LL .LT. LMIN) LMIN = LL
      NCHAR  = NCHAR + LL
      INWORD = .FALSE.
C
C --- COUNT WORDS IN THIS LINE AND KEEP AN EYE OPEN FOR TABS
C
      DO 20 I=1, LL
         IF ((LINE(I:I) .EQ. ' ') .OR. (LINE(I:I) .EQ. TAB)) THEN
            IF (LINE(I:I) .EQ. TAB) TABS = .TRUE.
            INWORD = .FALSE.
         ELSE IF (.NOT. INWORD) THEN
            INWORD = .TRUE.
            NWORDS = NWORDS + 1
         ENDIF
20    CONTINUE
      GO TO 10
C
C --- END OF FILE
C     
500   write(temp,950) nlines
      call left(temp)
      write(temp1,950) nwords
      call left(temp1)
      write(temp2,950) nchar
      call left(temp2)
      WRITE(NOUT,910) temp(1:length(temp)), temp1(1:length(temp1)),
     $  temp2(1:length(temp2))
      write(temp,950) lmax
      call left(temp)
      write(temp1,950) lmin
      call left(temp1)
      write(nout,911) temp(1:length(temp)), temp1(1:length(temp1))
      IF (IPAGE .GT. MPAGE) MPAGE = IPAGE
      WRITE(CPAGE,950) MPAGE
      CALL LEFT ( CPAGE )
      WRITE(NOUT,940) CPAGE(1:LENGTH(CPAGE))
      write(nout,912) CC(1:LENGTH(CC)) 
      IF ( TABS ) THEN
         WRITE(NOUT,915)
      ELSE
         WRITE(NOUT,916)
      ENDIF
C
C --- CLEANUP FOR NEXT TIME THROUGH
C
      CLOSE (NUNIT)
      RETURN
C
600   WRITE(NOUT,920)
      CALL EXIT(1)
C
1000  WRITE(NOUT,925) NEWFILE(1:LENGTH(NEWFILE))
      CALL EXIT(1)
C
900   FORMAT(A)
910   FORMAT(/' The file contains ',a,' lines, ',a,' words, ',
     $         a,' characters.')
911   format(' The longest line is ',a,' characters,',
     $         ' the shortest line is ',a,' characters.')
912   format(/' Carriage control type is ',A,'.')
915   FORMAT(' The file contains tabs.')
916   FORMAT(' The file does not contain tabs.')
920   FORMAT(' ***** ERROR Reading input file.'///)
925   FORMAT(' ***** ERROR, Unable to open file ',A)
930   FORMAT(/' GROKing file ',A)
940   FORMAT(' The longest page is ',A,' lines long.')
950   FORMAT(I10)
960   FORMAT(' Created on ',A,$)
970   FORMAT('+, revised on ',A,'.')
980   FORMAT('+.')
      END
C
C---END GROK
C
