#
# MMS description file for SOX/SoundTools (and Gopstein/Harris sound2sun)
#
# Modification History
# 12 Dec 1992, K. S. Kubo, Created
#
# NOTES (todo):
#	* This does not yet provide support for VMS distribution (e.g. shar
#	  target).
#	* It may be nice to link the library as a shareable image.
#	* To do this "right" this should also provide support for sounds
#	  in the DDIF format... someday, maybe.
#

.IFDEF DEBUG
DEBUGFLAGS	= /debug/nooptimize
LINKDBGFLAGS	= /nouserlibrary/traceback/debug
.ELSE
DEBUGFLAGS	= /nodebug/optimize
LINKDBGFLAGS	= /nouserlibrary/notraceback/nodebug
.ENDIF

CC		= cc
CFLAGS		= /object=$*.OBJ$(DEBUGFLAGS)
LINK		= link
LINKFLAGS	= /executable=$*.EXE$(LINKDBGFLAGS)

FSRC	= 	raw.c, \
	  	voc.c, \
		au.c, \
		sf.c, \
	  	aiff.c, \
		hcom.c, \
		8svx.c, \
		sndrtool.c, \
		wav.c, \
		sbdsp.c, \
		smp.c, \
		auto.c

ESRC	=	copy.c, \
		avg.c, \
		pred.c, \
		stat.c, \
		vibro.c, \
		echo.c, \
		rate.c, \
		band.c, \
		lowp.c, \
		highp.c, \
		reverse.c

PSRC	=	sox.c

OSRC	=	sound2sun.c

SOURCES = 	$(FSRC),$(ESRC),$(PSRC), \
		handlers.c, libst.c, misc.c, getopt.c, \
		$(OSRC)

HDRS	=	st.h, \
		libst.h, \
		sfheader.h, \
		patchlevel.h
TESTS	=	tests.com, \
		monkey.au, \
		monkey.voc
MISC	=	readme., install., todo, sox.man, st.man, \
		descrip.mms, sox.opt, vms.lis, sound2au.com, sound2sun.opt

SOUNDLIB  =	soundtools.olb

LIBMODS	= \
    $(SOUNDLIB)(raw) \
    $(SOUNDLIB)(voc) \
    $(SOUNDLIB)(au) \
    $(SOUNDLIB)(sf) \
    $(SOUNDLIB)(aiff) \
    $(SOUNDLIB)(hcom) \
    $(SOUNDLIB)(8svx) \
    $(SOUNDLIB)(sndrtool) \
    $(SOUNDLIB)(wav) \
    $(SOUNDLIB)(sbdsp) \
    $(SOUNDLIB)(smp) \
    $(SOUNDLIB)(auto) \
    $(SOUNDLIB)(copy) \
    $(SOUNDLIB)(avg) \
    $(SOUNDLIB)(pred) \
    $(SOUNDLIB)(stat) \
    $(SOUNDLIB)(vibro) \
    $(SOUNDLIB)(echo) \
    $(SOUNDLIB)(rate) \
    $(SOUNDLIB)(band) \
    $(SOUNDLIB)(lowp) \
    $(SOUNDLIB)(highp) \
    $(SOUNDLIB)(reverse) \
    $(SOUNDLIB)(handlers) \
    $(SOUNDLIB)(libst) \
    $(SOUNDLIB)(misc) \
    $(SOUNDLIB)(getopt)

.FIRST
    @ if F$TrnLnm("VAXC$INCLUDE") .eqs. "" then define VAXC$INCLUDE sys$library
    @ if F$TrnLnm("SYS") .eqs. "" then define SYS sys$library

#
# Actual targets
#
all : sox.exe sound2sun.exe
    @ ! dummy argument

clean :
    - delete *.obj;
    - delete *.raw;
    - delete *.sf;

depend : $(HDRS) $(SOURCES)
    set command/replace clddir:depend
    depend $(SOURCES)
    ! dependencies updated

sox.exe : sox.obj $(SOUNDLIB) descrip.mms sox.opt
    $(LINK) $(LINKFLAGS) sox.obj, sox.opt/options

sound2sun.exe : sound2sun.obj descrip.mms sound2sun.opt
    $(LINK) $(LINKFLAGS) sound2sun.obj, sound2sun.opt/options

$(SOUNDLIB) : $(LIBMODS)
    ! $(SOUNDLIB) updated

#DO NOT DELETE THIS LINE!

raw.obj : libst.h
raw.obj : raw.c
raw.obj : st.h
voc.obj : st.h
voc.obj : voc.c
au.obj : au.c
au.obj : st.h
sf.obj : sf.c
sf.obj : sfheader.h
sf.obj : st.h
aiff.obj : aiff.c
aiff.obj : st.h
hcom.obj : hcom.c
hcom.obj : st.h
8svx.obj : 8svx.c
8svx.obj : st.h
sndrtool.obj : sndrtool.c
sndrtool.obj : st.h
wav.obj : st.h
wav.obj : wav.c
sbdsp.obj : sbdsp.c
smp.obj : st.h
smp.obj : smp.c
auto.obj : st.h
auto.obj : wav.c
copy.obj : copy.c
copy.obj : st.h
avg.obj : avg.c
avg.obj : st.h
pred.obj : pred.c
pred.obj : st.h
stat.obj : st.h
stat.obj : stat.c
vibro.obj : st.h
vibro.obj : vibro.c
echo.obj : echo.c
echo.obj : st.h
rate.obj : rate.c
rate.obj : st.h
band.obj : band.c
band.obj : st.h
lowp.obj : lowp.c
lowp.obj : st.h
highp.obj : highp.c
highp.obj : st.h
reverse.obj : reverse.c
reverse.obj : st.h
sox.obj : sox.c
sox.obj : st.h
handlers.obj : handlers.c
handlers.obj : st.h
libst.obj : libst.c
misc.obj : misc.c
misc.obj : st.h
getopt.obj : getopt.c
getopt.obj : st.h
sound2sun.obj : sound2sun.c
