/*
 * Dynamically loaded map routine.
 *
 * Scan ident for invalid VMS filenames and fix.
 *
 *    usermap /www/* fspec_fixup,fixup
 */
#include "access.h"			/* Access structure. */
#include "ident_map.h"
#include "tutil.h"
#include <stdio.h>

int ts_tcp_stack_used ( ) { return 1000; }
/***************************************************************************/
/* Scan ident for filenames with multiple periods and convert to underscores.
 *
 * Return values:
 *	-1	Continue with next rule.
 */
int fspec_fixup ( info_ptr blk, char *translation, int maxlen,
	access_info acc, char **case_preserved, int cp_len )
{
    int last_dot, i, dot_count;
    /*
     * Parse username out of translation (part after pattern).
     */
    for ( dot_count=i=0; (i < maxlen) && translation[i]; i++ ) {
	if ( translation[i] == '.' ) {
	    dot_count++;
	    if ( dot_count > 1 ) {
		translation[last_dot] = '_';
		if ( case_preserved ) (*case_preserved)[last_dot] = '_';
	    }
	    last_dot = i;
        } else if ( translation[i] == '[' || translation[i] == '<' ) {
	    dot_count = -10000;
	} else if ( translation[i] == '/' || translation[i] == ']' ||
		translation[i] == '>' ) {
	    dot_count = 0;
	}
    }
    return IDENT_MAP_LOOP;
}
