/*
 * str.c
 *
 *	Code for VAX STR$ routines
 *
 * Description:
 *
 *	This file contains various 'str$' functions equivalent
 *	to those available in Vax/VMS string library.
 *
 * Bugs:
 *
 *	Not compatible at the binary level.
 *
 *	No seperate "string zone" to allocate memory from,
 *	uses malloc/free instead.
 *
 *	Some versions of realloc are broken! Some don't like to be
 *	called hundreds of times.  The program may
 *	crash with a segmentation fault in such a case.
 *
 *	I probibly should be using dsc$descriptor instead of
 *	dsc$descriptor_s, but I prefer to have the type 'char*'
 *	instead of 'void*' which is the only difference.
 *
 *	Not worrying about the dsc$b_dtype field yet. Assumes it
 *	will always be type DSC$K_DTYPE_T (character coded text).
 *	Type V should mean size is in bits, and P means size is in
 *	digits (4 bit nibbles).
 *
 * History
 *
 *	Oct 10, 1996 - Kevin Handy
 *		Preliminary design. Spelling errors are
 *		not my fault! Someone must have snuck them in
 *		there when I wasn't looking.
 */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "descrip.h"
#include "strdef.h"

/*************************************************************
 * str$add
 *
 *	Add two decimal strings of digits
 */
unsigned long str$add(const unsigned long* asign, const long* aexp, 
	const struct dsc$descriptor_s* adigits,
	const unsigned long* bsign, const long*bexp, 
	const struct dsc$descriptor_s* bdigits,
	unsigned long* csign, long* cexp, struct dsc$descriptor_s* cdigits)
{
	/* Not yet coded */
}


/*************************************************************
 * str$compare_multi
 *
 */
long str$compare_multi(
	const struct dsc$descriptor_s* first_source_string,
	const struct dsc$descriptor_s* second_source_string,
	const long* flags_value,
	const long* foreign_language)
{
	/* Not yet coded */
	assert(0);
}


/*************************************************************
 * str$divide
 *
 */
unsigned long str$divide(
	const unsigned long* asign, const long* aexp, const struct dsc$descriptor_s* a_digits,
	const unsigned long* bsign, const long* bexp, const struct dsc$descriptor_s* b_digits,
	const long* total_digits, const long* round_truncate_indicator,
	unsigned long* csign, long* cexp, struct dsc$descriptor_s* cdigits)
{
	/* Not yet coded */
	assert(0);
}



/*************************************************************
 * str$element
 *
 */
unsigned long str$element(struct dsc$descriptor_s* destination_string,
	const long* element_number,
	const struct dsc$descriptor_s* delimiter_string,
	const struct dsc$descriptor_s* source_string)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$find_first_in_set
 *
 */
long str$find_first_in_set(const struct dsc$descriptor_s* source_string,
	const struct dsc$descriptor_s* set_of_characters)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$find_first_not_in_set
 *
 */
long str$find_first_not_in_set(
	const struct dsc$descriptor_s* source_string,
	const struct dsc$descriptor_s* set_of_characters)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$find_first_substring
 *
 */
unsigned long str$find_first_substring(
	const struct dsc$descriptor_s* source_string,
	long* index,
	long* substring_index, ...)
{
	/* Not yet coded */
	assert(0);
}


/*************************************************************
 * str$len_extr
 *
 */
unsigned long str$len_extr(struct dsc$descriptor_s* destination_string,
	const struct dsc$descriptor_s* source_string,
	const long* start_position,
	const long* longword_integer_length)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$match_wild
 *
 */
unsigned long str$match_wild(const struct dsc$descriptor_s* candidate_string,
	const struct dsc$descriptor_s* pattern_string)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$mul
 *
 */
unsigned long str$mul(const unsigned long* asign, const long aexp,
	const struct dsc$descriptor_s* adigits,
	const unsigned long* bsign, const long* bexp,
	const struct dsc$descriptor_s* bdigits,
	unsigned long* csign, long* cexp,
	struct dsc$descriptor_s* cdigits)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$position
 *
 */
unsigned long str$position(const struct dsc$descriptor_s* source_string,
	const struct dsc$descriptor_s* substring,
	long* start_position)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$prefix
 *
 */
unsigned long str$prefix(struct dsc$descriptor_s* destination_string,
	const struct dsc$descriptor_s* source_string)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$recip
 *
 */
unsigned long str$recip(
	const unsigned long* asign, const long* aexp,
	const struct dsc$descriptor_s* adigits,
	const unsigned long* bsign, const long* bexp,
	const struct dsc$descriptor_s* bdigits,
	unsigned long* csign, long* cexp,
	struct dsc$descriptor_s* cdigits)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$replace
 *
 */
unsigned long str$replace(struct dsc$descriptor_s* destinstaion_string,
	const struct dsc$descriptor_s* source_string,
	const long* start_position,
	const long* end_position,
	const struct dsc$descriptor_s* replacement_string)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$round
 *
 */
unsigned long str$round(const long* places, unsigned long* flags,
	const unsigned long* asign, const long* aexp,
	const struct dsc$descriptor_s* adigits,
	const unsigned long* bsign, const long* bexp,
	const struct dsc$descriptor_s* bdigits,
	unsigned long* csign, long* cexp,
	struct dsc$descriptor_s* cdigits)
{
	/* Not yet coded */
	assert(0);
}

/*************************************************************
 * str$translate
 *
 */
unsigned long str$translate(struct dsc$descriptor_s* destinstaion_string,
	const struct dsc$descriptor_s* source_string,
	const struct dsc$descriptor_s* translation_string,
	const struct dsc$descriptor_s* match_string)
{
	/* Not yet coded */
	assert(0);
}

