/*
 * str.c
 *
 *	Code for VAX STR$DUPL_CHAR routine
 *
 * Description:
 *
 *
 * Bugs:
 *
 *
 * History
 *
 *	Oct 10, 1996 - Kevin Handy
 *		Preliminary design.
 */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "descrip.h"
#include "strdef.h"

/*************************************************************
 * str$dupl_char
 *
 */
unsigned long str$dupl_char(struct dsc$descriptor_s* destination_string,
	const long* repetition_count,
	const char* ascii_character)
{
        char* s1_ptr;           /* Pointer to first string */
        short s1_length;        /* Length of first string */
        char* s2_ptr;           /* Pointer to second string */
        short s2_length;        /* Length of second string */
	unsigned long result = STR$_NORMAL;
	char UseChar = ' ';	/* Character to use for duplication */
	long UseCount;
	unsigned long alt_result;

	/*
	 * Get the repitition count
	 */
	if (repetition_count == NULL)
	{
		UseCount = 1;
	}
	else
	{
		UseCount = *repetition_count;
	}

	/*
	 * Check out the source string. It better have one
	 * single character in it.
	 */
	if (ascii_character != NULL)
	{
		UseChar = *ascii_character;
	}

	/*
	 * Validate the repitition count
	 */
	if (UseCount < 0)
	{
		UseCount = 0;
		result = STR$_NEGSTRLEN;
	}

	if (UseCount > 65535L)
	{
		DOSIGNAL(STR$_STRTOOLON);
		return STR$_STRTOOLON;
	}

	/*
	 * Resize the destination string
	 */
	alt_result = str$$resize(destination_string, UseCount);
	if (alt_result != STR$_NORMAL)
	{
		result = alt_result;
	}
	else
	{
		/*
	 	 * Now, see what we've got for a destination
	 	 */
		str$analyze_sdesc(destination_string, &s1_length, &s1_ptr);
		memset(s1_ptr, UseChar, min(s1_length, UseCount));

		/*
		 * Did we truncate?
		 */
		if (UseCount > s1_length)
		{
			result = STR$_TRU;
		}
	}

	/*
	 * Done!
	 */
	return result;
}

