/*
 * str.c
 *
 *	Code for VAX STR$FREE1_DX routine
 *
 * Description:
 *
 *
 * Bugs:
 *
 * History
 *
 *	Oct 10, 1996 - Kevin Handy
 *		Preliminary design.
 */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "descrip.h"
#include "strdef.h"

/*************************************************************
 * str$free1_dx
 *
 *	Deallocates the described string space and flags
 *	the descriptor as no string at all (dsc$a_pointer = 0,
 *	dsc$w_length = 0).
 */
unsigned long str$free1_dx(struct dsc$descriptor_s* string_descriptor)
{
	/*
	 * Validate class
	 */
	if (str$$is_string_class(string_descriptor) != STR$_NORMAL)
	{
		DOSIGNAL(STR$_ILLSTRCLA);
		return STR$_ILLSTRCLA;
	}

	/*
	 * Validate address
	 */
	if (string_descriptor->dsc$a_pointer == NULL)
	{
		DOSIGNAL(STR$_FATINTERR);
		return STR$_FATINTERR;
	}

	free(string_descriptor->dsc$a_pointer);
	string_descriptor->dsc$a_pointer = NULL;
	string_descriptor->dsc$w_length = 0;

	/*
	 * Succussful operation
	 */
	return STR$_NORMAL;
}


