/* Copyright (C) 1996, Russell Lang.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/


// dwmainc.cpp
// Ghostscript DLL loader for Windows 95/NT
// For WINDOWCOMPAT (console mode) application

#define STRICT
#include <windows.h>
#include <shellapi.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
extern "C" {
#include "gscdefs.h"
#define GSREVISION gs_revision
#include "gsdll.h"
}
#include "dwmain.h"
#include "dwdll.h"

/* public handles */
HINSTANCE phInstance;

const char *szDllName = "GSDLL32.DLL";

// Which version of Windows
BOOL is_win32s = FALSE;

int win_exit_status;

int FAR _export gsdll_callback(int message, char FAR *str, unsigned long count);

// the Ghostscript DLL class
gsdll_class gsdll;

char start_string[] = "systemdict /start get exec\n";

// program really starts at WinMain
int
new_main(int argc, char *argv[])
{
typedef char FAR * FARARGV_PTR;
int rc;

    // load DLL
    if (gsdll.load(phInstance, szDllName, GSREVISION)) {
	char buf[256];
	gsdll.get_last_error(buf, sizeof(buf));
	fputs(buf, stdout);
	return 1;
    }

    // initialize the interpreter
    rc = gsdll.init(gsdll_callback, (HWND)NULL, argc, argv);
    if (rc == GSDLL_INIT_QUIT) {
        gsdll.unload();
	return 0;
    }
    if (rc) {
	char buf[256];
	gsdll.get_last_error(buf, sizeof(buf));
	fputs(buf, stdout);
        gsdll.unload();
	return rc;
    }

    // if (!batch)
    gsdll.execute(start_string, strlen(start_string));
    
    gsdll.unload();

    return 0;
}


#pragma argsused  // ignore warning about unused arguments in next function

int PASCAL 
WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int cmdShow)
{
#if defined(_MSC_VER)    /* MSC doesn't give us _argc and _argv[] so ...   */
#define MAXCMDTOKENS 128
	int	_argc=0;
	LPSTR	_argv[MAXCMDTOKENS];
	_argv[_argc] = "gswin32.exe";
	_argv[++_argc] = _fstrtok( lpszCmdLine, " ");
	while (_argv[_argc] != NULL)
		_argv[++_argc] = _fstrtok( NULL, " ");
#endif

	{   DWORD version = GetVersion();
	    if ((HIWORD(version) & 0x8000) != 0)
		is_win32s = TRUE;
	}

	if (hPrevInstance) {
	    fputs("Can't run twice", stdout);
	    return FALSE;
	}

	/* copy the hInstance into a variable so it can be used */
	phInstance = hInstance;

	new_main(_argc, _argv);

	return win_exit_status;
}


int
read_stdin(char FAR *str, int len)
{
int ch;
int count = 0;
    while (count < len) {
	ch = fgetc(stdin);
	if (ch == EOF)
	    return count;
	*str++ = ch;
	count++;
	if (ch == '\n')
	    return count;
    }
    return count;
}


int FAR _export
gsdll_callback(int message, char FAR *str, unsigned long count)
{
char buf[256];
    switch (message) {
	case GSDLL_POLL:
	    // Don't check message queue because we don't
	    // create any windows.
	    // May want to return error code if abort wanted
	    break;
	case GSDLL_STDIN:
	    return read_stdin(str, count);
	case GSDLL_STDOUT:
	    fwrite(str, 1, count, stdout);
	    return count;
	case GSDLL_DEVICE:
	    if (count) {
		sprintf(buf, "mswindll device not supported in this version of Ghostscript\n");
		fputs(buf, stdout);
	    }
	    break;
	case GSDLL_SYNC:
	    break;
	case GSDLL_PAGE:
	    break;
	case GSDLL_SIZE:
	    break;
	default:
	    sprintf(buf,"Callback: Unknown message=%d\n",message);
	    fputs(buf, stdout);
	    break;
    }
    return 0;
}


