#    Copyright (C) 1995, 1996 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# makefile for zlib library code.

# This partial makefile compiles the zlib library for use in Ghostscript.
# You can get the source code for this library from:
#   ftp://ftp.uu.net/pub/archiving/zip/zlib102.zip   (zlib 1.0.2)
#		or zlib-1.0.2.tar.gz
# Please see Ghostscript's `make.txt' file for instructions about how to
# unpack these archives.

# Define the name of this makefile.
ZLIB_MAK=zlib.mak

# ZSRCDIR is defined in the platform-specific makefile, not here,
# as the directory where the zlib sources are stored.
#ZSRCDIR=zlib
ZSRC=$(ZSRCDIR)$(D)
CCCZ=$(CCC) -I$(ZSRCDIR)

# We keep all of the zlib code in a separate directory so as not to
# inadvertently mix it up with Aladdin Enterprises' own code.
ZDEP=$(AK)

# Code common to compression and decompression.

zlibc_=zutil.$(OBJ)
zlibc.dev: $(ZLIB_MAK) $(ECHOGS_XE) $(zlibc_)
	$(SETMOD) zlibc $(zlibc_)

zutil.$(OBJ): $(ZSRC)zutil.c $(ZDEP)
	$(CCCZ) $(ZSRC)zutil.c

# Encoding (compression) code.

zlibe_=adler32.$(OBJ) deflate.$(OBJ) trees.$(OBJ)
zlibe.dev: $(ZLIB_MAK) $(ECHOGS_XE) zlibc.dev $(zlibe_)
	$(SETMOD) zlibe $(zlibe_)
	$(ADDMOD) zlibe -include zlibc

adler32.$(OBJ): $(ZSRC)adler32.c $(ZDEP)
	$(CCCZ) $(ZSRC)adler32.c

deflate.$(OBJ): $(ZSRC)deflate.c $(ZDEP)
	$(CCCZ) $(ZSRC)deflate.c

trees.$(OBJ): $(ZSRC)trees.c $(ZDEP)
	$(CCCZ) $(ZSRC)trees.c

# Decoding (decompression) code.

zlibd1_=infblock.$(OBJ) infcodes.$(OBJ) inffast.$(OBJ)
zlibd2_=inflate.$(OBJ) inftrees.$(OBJ) infutil.$(OBJ)
zlibd_ = $(zlibd1_) $(zlibd2_)
zlibd.dev: $(ZLIB_MAK) $(ECHOGS_XE) zlibc.dev $(zlibd_)
	$(SETMOD) zlibd $(zlibd1_)
	$(ADDMOD) zlibd -obj $(zlibd2_)
	$(ADDMOD) zlibd -include zlibc

infblock.$(OBJ): $(ZSRC)infblock.c $(ZDEP)
	$(CCCZ) $(ZSRC)infblock.c

infcodes.$(OBJ): $(ZSRC)infcodes.c $(ZDEP)
	$(CCCZ) $(ZSRC)infcodes.c

inffast.$(OBJ): $(ZSRC)inffast.c $(ZDEP)
	$(CCCZ) $(ZSRC)inffast.c

inflate.$(OBJ): $(ZSRC)inflate.c $(ZDEP)
	$(CCCZ) $(ZSRC)inflate.c

inftrees.$(OBJ): $(ZSRC)inftrees.c $(ZDEP)
	$(CCCZ) $(ZSRC)inftrees.c

infutil.$(OBJ): $(ZSRC)infutil.c $(ZDEP)
	$(CCCZ) $(ZSRC)infutil.c
