/*      dir.c
 *                              5-Aug-1995      IfN/Mey
 *
 *      Derived from a module from P Kay's UNIXSHR.
 *
 *      Slightly modified by Eckart Meyer, meyer@ifn.ing.tu-bs.de
 *+
 * opendir, readdir, seekdir and closedir.
 *-
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dir.h"
#include <lib$routines.h>
#include <ssdef.h>
#include <rmsdef.h>
#include <errno.h>

#ifndef __UNISTD_LOADED
char *getcwd (char *__buffer, unsigned int __size);
int chdir   (char *__dir_spec);
#endif

/*
 * readdir() should return files relative to the path specified by
 * opendir(). For this reason we have to chdir() to that directory
 * before calling SYS$FIND_FILE. When called often and with large
 * directories this decreases performance significantly.
 *
 * If you are sure that chdir() is not called from other places between
 * calls to opendir() and closedir() and that your application does not
 * care about a default directory change, you may define FAST_READDIR.
 * This way, chdir() is only called once in opendir() and again in closedir()
 * to change the default directory back to the saved path.
 */

/* #define FAST_READDIR /**/


static DIR directory;
static struct direct dp;
static char *wild = "*.*;0";
static char path[256];
static char resfile[256];
static char save_path[256];

int DEBUGLEVEL = 0;
#define DEBUG(level,body) ((DEBUGLEVEL>=(level))?(printf body):0)


DIR *opendir(filename)
char *filename;
{
  DEBUG (4,("opendir: \"%s\"\n",filename));
  if (strlen(filename) > 250) {
    errno = ENAMETOOLONG;
    return(NULL);
  }
  strcpy(path,filename);
  directory.dd_loc = 0;
#ifdef FAST_READDIR
  getcwd(save_path,256);
  chdir(path);
#endif
  return(&directory);
}

struct direct *readdir(dirp)
DIR *dirp;
{
  int st;
  char *p, *q;
  struct {
     int length;
     char *ptr;
  } filedesc, res_filedesc;
  filedesc.length = strlen(wild);
  filedesc.ptr = wild;
  res_filedesc.length = 256;
  res_filedesc.ptr = resfile;
#ifndef FAST_READDIR
  getcwd(save_path,256);
  chdir(path);
#endif
  DEBUG (8,("readdir: saved path = \"%s\", path = \"%s\"\n",save_path,path));
 /**/
  st = lib$find_file(&filedesc,&res_filedesc,&directory.dd_loc,0,0,0,0);
#ifndef FAST_READDIR
  chdir(save_path);
#endif
  if (st == SS$_NORMAL || st == RMS$_NORMAL) {
     for (p = res_filedesc.ptr;*p != ']';p++);
     for (q = dp.d_name, ++p; *p != ';'; q++ ,p++){
       *q = *p;
       if ( *q >= 'A' && *q <= 'Z') *q = *q -'A'+'a';
     }
     *q = '\0';
     dp.d_namlen = strlen(dp.d_name);
     DEBUG (3,("readdir: returns \"%s\"\n",dp.d_name));
     return(&dp);
  }
  if (st == RMS$_NMF) return(NULL);     /* don't touch errno if no more files */
  errno = ENOENT;
  if (st == SS$_NOPRIV) errno = EACCES;
  return(NULL);
}

closedir(dirp)
DIR *dirp;
{
  lib$find_file_end(&directory.dd_loc);
#ifdef FAST_READDIR
  chdir(save_path);
#endif
}

rewinddir(dirp)
DIR *dirp;
{
/* sorry no time to do this properly */
}
