//=========================================================
//
//	Scatter.c
//
//	Demonstrates the use of a new Win32 function,
//	ReadFileScatter, which has been introduced in 
//	SP2.
//
//=========================================================
#include <windows.h>
#include <stdio.h>

// page size on x86
#define PAGE_SIZE 4096

// 
// Prototype for undocumented function
//
 BOOL  (__stdcall *ReadFileScatter)( 
				HANDLE File,				// handle of file to read 
				LARGE_INTEGER lpBuffer[],	// array describing buffer
				DWORD nNumberOfBytesToRead,	// number of bytes to read
				LPDWORD lpNumberOfBytesRead,// address of number of bytes read
                LPOVERLAPPED lpOverlapped	// address of structure for data 
);

//
// Buffer big enough to hold at least 3 page-aligned pages
//
char	Buffer[ 4 * PAGE_SIZE ];

//---------------------------------------------------------
//
// PrintError
//
// Formats an error message for the last error
//
//---------------------------------------------------------
void PrintError()
{
	char *errMsg;

	FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
			NULL, GetLastError(), 
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), 
			(LPTSTR) &errMsg, 0, NULL );
	printf("%s\n", errMsg );
	LocalFree( errMsg );
}


//---------------------------------------------------------
//
// main
//
// Do everything
//
//---------------------------------------------------------
void main( int argc, char *argv[])
{
	HANDLE			hFile, hEvent;
	LARGE_INTEGER	nBufDescription[2];
	char			string1[64], string2[64];
	OVERLAPPED		Overlapped;
	DWORD			nBytesRead;
	char			*page1, *page3;

	printf("Scatter\n" );
	printf("Demonstrates the use of new NT 4.0SP2 Win32 API\n");
	printf("Scatter reading scatter.txt\n");

	//
	// get the address of the function in kernel.dll
	//
	if( !(ReadFileScatter = (void *) GetProcAddress( GetModuleHandle("kernel32.dll"),
			"ReadFileScatter" )) ) {
		printf("Not running on SP2 or higher.\n");
		exit(1);
	}

	//
	// open the file 
	//
	if((hFile = CreateFile( "scatter.txt", GENERIC_READ, 0, NULL, OPEN_EXISTING,
						FILE_FLAG_OVERLAPPED|FILE_FLAG_NO_BUFFERING, 
						NULL )) < 0 ) {
		printf("Error opening scatter.txt: ");
		PrintError();
		exit(1);
	}

	//
	// create an event
	//
	hEvent = CreateEvent( NULL, TRUE, FALSE, NULL );

	// 
	// clear the entire buffer
	//
	memset( Buffer, 0, 4*PAGE_SIZE );

	//
	//point at 1st and 3rd pages in the buffer
	//
	page1 = (char *) ((DWORD)(Buffer + PAGE_SIZE) & ~(PAGE_SIZE-1));
	page3 = page1 + 2*PAGE_SIZE;
	nBufDescription[0].LowPart = (DWORD) page1;
	nBufDescription[1].LowPart = (DWORD) page3;

	//
	// prepare the overlapped structure
	//
	Overlapped.Offset		= 0;
	Overlapped.OffsetHigh	= 0;
	Overlapped.hEvent		= hEvent;

	//
	// go for it - read two pages of the file
	//
	ReadFileScatter( hFile, nBufDescription, 2*PAGE_SIZE,
					NULL, &Overlapped );

	// 
	// wait for I/O to finish
	//
	WaitForSingleObject( hEvent, INFINITE );

	if( !GetOverlappedResult(hFile, &Overlapped, 
								&nBytesRead, FALSE)) {
		printf("Read file failed: ");
		PrintError();
		CloseHandle( hFile );
		exit(1);
	} else {
		printf("%d bytes read.\n", nBytesRead );
	}

	//
	// print out the first line of each page - must
	// be a text file for this to have the correct effect
	//
	memset( string1, 0, 64 );
	strncpy( string1, page1, strlen("This is the first page in the file"));
	memset( string2, 0, 64 );
	strncpy( string2, page3, strlen("This is the second page in the file"));

	printf("At page 1 of the buffer: \"%s\"\n", string1 );
	printf("At page 3 of the buffer: \"%s\"\n", string2 );
	
	//
	// close up shop
	//
	CloseHandle( hFile );
}