/* <clidef.h>
 *
 *	Command Language Interface definitions.
 */
#ifndef _CLIDEF_H
#define _CLIDEF_H
/*
   This module defines the offset values for the data structures
   used to communicated command information between the CLI and
   the utility that was requested to perform the operation.
 */

#define CLI$V_DEBUG	0
#define CLI$V_DBGTRU	1
#define CLI$V_VERIFY	2
#define CLI$V_BATCH	3
#define CLI$V_INDIRECT	4
#define CLI$V_VFYINP	5
#define CLI$M_DEBUG	(1<<CLI$V_DEBUG)	/* 0x01 */
#define CLI$M_DBGTRU	(1<<CLI$V_DBGTRU)	/* 0x02 */
#define CLI$M_VERIFY	(1<<CLI$V_VERIFY)	/* 0x04 */
#define CLI$M_BATCH	(1<<CLI$V_BATCH)	/* 0x08 */
#define CLI$M_INDIRECT	(1<<CLI$V_INDIRECT)	/* 0x10 */
#define CLI$M_VFYINP	(1<<CLI$V_VFYINP)	/* 0x20 */
#define CLI$V_TRMVRBLV	8
#define CLI$M_TRMVRBLV	0x0300
#define CLI$S_TRMVRBLV	2
#define CLI$V_DBGEXCP	16
#define CLI$M_DBGEXCP	(1<<CLI$V_DBGEXCP)	/* 0x010000 */
struct clidef {
    unsigned long cli$l_iniargcnt;	/* initial arg count */
    int *cli$a_progxfer;		/* program transfer vector address */
    int *cli$a_utilserv;		/* address of CLI utility service */
    int *cli$a_imghdadr;		/* address of image header */
    int *cli$a_imgfiled;		/* address of image file data */
    unsigned long cli$l_linkflag;	/* link flag longword */
    union {
	unsigned long cli$l_cliflag;	/* CLI flag longword */
	struct {
	    unsigned cli$v_debug    : 1; /* debug qualifier seen */
	    unsigned cli$v_dbgtru   : 1; /* debug was true */
	    unsigned cli$v_verify   : 1; /* verify is on */
	    unsigned cli$v_batch    : 1; /* this process is a batch job */
	    unsigned cli$v_indirect : 1; /* indirect level not equal to zero*/
	    unsigned cli$v_vfyinp   : 1; /* utility should verfiy input */
	    unsigned		    : 2; /* round up to next byte */
	    unsigned cli$v_trmvrblv : 2; /* terminal verbosity level */
	    unsigned		    : 6; /* round up to next byte */
	    unsigned cli$v_dbgexcp  : 1; /* debugger called via "debug" exception */
	    unsigned		    : 7, : 8;
	} cli$r_cliflag_bits;
    } cli$r_cliflag_overlay;
/*	  The following arguments are optional depending on iniargcnt */
    unsigned long cli$l_arglist;    /* address of application argument list */
				    /* (used for merged image arg. passing) */
};

/* Define CLI command interface request block */
#define CLI$V_PARMREQ	0
#define CLI$V_ABSADR	1
#define CLI$V_EXPNAM	2
#define CLI$M_PARMREQ	(1<<CLI$V_PARMREQ)	/* 0x01 */
#define CLI$M_ABSADR	(1<<CLI$V_ABSADR)	/* 0x02 */
#define CLI$M_EXPNAM	(1<<CLI$V_EXPNAM)	/* 0x04 */
#define CLI$V_LASTVAL	0
#define CLI$V_DUMMY	1
#define CLI$M_LASTVAL	(1<<CLI$V_LASTVAL)	/* 0x01 */
#define CLI$M_DUMMY	(1<<CLI$V_DUMMY)	/* 0x02 */
#define CLI$V_PARMPRS	0
#define CLI$V_CONCATINP 1
#define CLI$V_MOREINP	2
#define CLI$V_PARMDEF	3
#define CLI$M_PARMPRS	(1<<CLI$V_PARMPRS)	/* 0x01 */
#define CLI$M_CONCATINP (1<<CLI$V_CONCATINP)	/* 0x02 */
#define CLI$M_MOREINP	(1<<CLI$V_MOREINP)	/* 0x04 */
#define CLI$M_PARMDEF	(1<<CLI$V_PARMDEF)	/* 0x08 */
#define CLI$V_MOREVALS	0
#define CLI$V_KEYVALU	1
#define CLI$M_MOREVALS	(1<<CLI$V_MOREVALS)	/* 0x01 */
#define CLI$M_KEYVALU	(1<<CLI$V_KEYVALU)	/* 0x02 */
#define CLI$K_REQDESC	28		/* size of the structure */
#define CLI$C_REQDESC	28
struct clidef1 {
    union {
	unsigned cli$l_rq_serv;			/*(was long fill; dummy arg)*/
	struct {
	    union {
		unsigned char cli$b_rqtype;	/* type of request being made */
		struct {
		    unsigned cli$v_subtyp : 4;	/* sub type vield */
		    unsigned cli$v_prityp : 4;	/* primary typye */
		} cli$r_rqtype_bits;
	    } cli$r_rqtype_overlay;
	    union {
		unsigned short cli$w_servcod;	/* CLI service code */
		struct {
		    union {
			unsigned char cli$b_rqindx; /* offset for value keyword index */
			unsigned char cli$b_bitnum; /* bit to set if request is sucessful */
		    } cli$r_rqindx_overlay;
		    union {
			unsigned char cli$b_rqflgs; /* input flags concerning request */
			struct {
			    unsigned cli$v_parmreq : 1; /* paramater is required */
			    unsigned cli$v_absadr  : 1; /* all address are absolute */
			    unsigned cli$v_expnam  : 1; /* return explicit names only */
			    unsigned		   : 5;
			} cli$r_rqflgs_bits0;
			struct {
			    unsigned cli$v_lastval : 1; /* last value allowed */
			    unsigned cli$v_dummy   : 1; /* *** save place for abs adr *** */
			    unsigned		   : 6;
			} cli$r_rqflgs_bits1;
		    } cli$r_rqflgs_overlay;
		} cli$r_servcod_fields;
	    } cli$r_servcod_overlay;
	    union {
		unsigned char cli$b_rqstat;	/* output status flags */
		struct {
		    unsigned cli$v_parmprs : 1; /* parameter is present */
		    unsigned cli$v_concatinp: 1; /* input concatonation exists */
		    unsigned cli$v_moreinp : 1; /* another set of input parameters */
		    unsigned cli$v_parmdef : 1; /* parameter was defaulted present */
		    unsigned		   : 4;
		} cli$r_rqstat_bits0;
		struct {
		    unsigned cli$v_morevals: 1; /* unprocessed values remain */
		    unsigned cli$v_keyvalu : 1; /* subsequent token is value for key */
		    unsigned		   : 6;
		} cli$r_rqstat_bits1;
	    } cli$r_rqstat_overlay;
	} cli$r_rq_serv_fields;
    } cli$r_rq_serv_overlay;
    int *cli$a_erract;			/* address of error action routine */
    union {
	unsigned int cli$q_rqdesc[2];	/* quadword request descriptor */
	struct {
	    unsigned short cli$w_rqsize; /* resultant size of parameter */
	    short clidef1_fill_w;	/* spare word in descriptor */
	    union {
		unsigned long cli$l_rqvalu; /* actual value in value converstion */
		int *cli$a_rqaddr;	/* address of resultant parameter */
	    } cli$r_rqvalu_overlay;
	} cli$r_rqdesc_fields;
    } cli$r_rqdesc_overlay;
    int *cli$a_prsact;			/* parameter present action routine */
    int *cli$a_absact;			/* parameter absent action routine */
    int *cli$a_qualst;			/* address of qualifiers */
};

/* Define the Descriptor Used by Symbol and Logical-name Callbacks */
struct clidef2 {
    unsigned	: 8, : 8, : 8, : 8;	/* char fill[4]; */
    unsigned int cli$q_namdesc[2];	/* logical name or symbol name */
    unsigned int cli$q_valdesc[2];	/* equivalence name or symbol value */
    unsigned int cli$q_tabdesc[2];	/* name of logical name table */
    unsigned long cli$l_itmlst;		/* address of item list */
    unsigned long cli$l_attr;		/* address of attribute longword */
};

/* Define the Descriptor Locations Used for the Old/New */
/* Out-of-Band Character(s) Masks			*/
struct clidef3 {
    unsigned	: 8, : 8, : 8, : 8;	/* char fill[4]; */
    unsigned long cli$l_new_mask;	/* enable/disable mask */
    unsigned long cli$l_old_mask;	/* previous enabled values mask */
};

/* Define the descriptor used for ATTACH callback */
struct clidef4 {
    unsigned	: 8, : 8, : 8, : 8;	/* char fill[4]; */
    unsigned long cli$l_pid;		/* PID of "destination" process */
};

/* Define the descriptor used for SPAWN callback */
#define CLI$V_NOWAIT	0
#define CLI$V_NOCLISYM	1
#define CLI$V_NOLOGNAM	2
#define CLI$V_NOKEYPAD	3
#define CLI$V_NOTIFY	4
#define CLI$V_NOCONTROL 5
#define CLI$V_TRUSTED	6
#define CLI$V_AUTHPRIV	7
#define CLI$V_SUBSYSTEM 8
#define CLI$M_NOWAIT	(1<<CLI$V_NOWAIT)	/* 0x01 */
#define CLI$M_NOCLISYM	(1<<CLI$V_NOCLISYM)	/* 0x02 */
#define CLI$M_NOLOGNAM	(1<<CLI$V_NOLOGNAM)	/* 0x04 */
#define CLI$M_NOKEYPAD	(1<<CLI$V_NOKEYPAD)	/* 0x08 */
#define CLI$M_NOTIFY	(1<<CLI$V_NOTIFY)	/* 0x10 */
#define CLI$M_NOCONTROL (1<<CLI$V_NOCONTROL)	/* 0x20 */
#define CLI$M_TRUSTED	(1<<CLI$V_TRUSTED)	/* 0x40 */
#define CLI$M_AUTHPRIV	(1<<CLI$V_AUTHPRIV)	/* 0x80 */
#define CLI$M_SUBSYSTEM (1<<CLI$V_SUBSYSTEM)	/* 0x0100 */
#define CLI$K_SPAWN_VERSION 1		/* latest version */
#define CLI$C_SPAWN_VERSION 1
struct clidef5 {
    unsigned	: 8, : 8, : 8, : 8;	/* char fill[4]; */
    union {
	unsigned short cli$w_flags;	/* flags word (V6.x) */
	unsigned char cli$b_flags;	/* flags byte (V5.x) */
	struct {
	    unsigned cli$v_nowait   : 1; /* don't wait for subprocess completion */
	    unsigned cli$v_noclisym : 1; /* don't copy CLI symbols to subprocess */
	    unsigned cli$v_nolognam : 1; /* don't copy logical names to subprocess */
	    unsigned cli$v_nokeypad : 1; /* don't copy keypad state to subprocess */
	    unsigned cli$v_notify   : 1; /* output notification message */
	    unsigned cli$v_nocontrol: 1; /* don't put CR/LF in front of prompt string */
	    unsigned cli$v_trusted  : 1; /* allow spawn regardless of UAF CAPTIVE flag */
	    unsigned cli$v_authpriv : 1; /* propagate AUTHPRIV to subprocess */
	    unsigned cli$v_subsystem: 1; /* copy protected subsystem IDs to subprocess */
	    unsigned		    : 7;
	} cli$r_flags_bits;
    } cli$r_flags_overlay;
    unsigned	     : 8, : 8;		/* char fill[2]; unused */
    unsigned long cli$l_outpid;		/* PID of subprocess on return */
    unsigned long cli$l_lststatus;	/* address to store final subprocess status */
    unsigned int cli$q_cmdstr[2];	/* descriptor of command string */
    unsigned int cli$q_input[2];	/* descriptor of input filespec */
    unsigned int cli$q_output[2];	/* descriptor of output filespec */
    unsigned int cli$q_prcnam[2];	/* descriptor of name for subprocess */
    unsigned long cli$l_astadr;		/* address of termination AST routine */
    unsigned long cli$l_astprm;		/* address of AST routine parameter */
    unsigned char cli$b_efn;		/* event flag to set on termination */
    unsigned char cli$b_version;	/* data structure version */
    unsigned	: 8, : 8;		/* char fill[2]; unused */
    unsigned int cli$q_prompt[2];	/* descriptor of prompt string */
    unsigned int cli$q_cli[2];		/* descriptor of CLI name */
    unsigned int cli$q_table[2];	/* descriptor of CLI table name */
};
/*
   Define the length of the longest "supervisor-mode service" request block
   so that programs can allocate a fixed amount of space for the block.
 */
#define CLI$K_SRVDESC	84	/* length of longest "service" callback */
#define CLI$C_SRVDESC	84

/* Define the parameter qualifier descriptor. */
#define CLI$V_ALLOCCUR	0
#define CLI$V_QDUSRV	1
#define CLI$V_QDEXPA	2
#define CLI$M_ALLOCCUR	(1<<CLI$V_ALLOCCUR)	/* 0x01 */
#define CLI$M_QDUSRV	(1<<CLI$V_QDUSRV)	/* 0x02 */
#define CLI$M_QDEXPA	(1<<CLI$V_QDEXPA)	/* 0x04 */
#define CLI$V_QUALTRU	0
#define CLI$V_QUALEXP	1
#define CLI$M_QUALTRU	(1<<CLI$V_QUALTRU)	/* 0x01 */
#define CLI$M_QUALEXP	(1<<CLI$V_QUALEXP)	/* 0x02 */
#define CLI$K_QUALDEF	20	/* size of fixed part of structure */
#define CLI$C_QUALDEF	20
#define CLI$K_QDBITS	20	/* start of bit lists(varialble length) */
#define CLI$C_QDBITS	20
struct clidef6 {
    unsigned char cli$b_qdblksiz;	/* size of the final block */
    unsigned char cli$b_qdcode;		/* id code for the qualifier */
    union {
	unsigned char cli$b_qdflgs;	/* flags byte */
	struct {
	    unsigned cli$v_alloccur : 1; /* take action on all occurances */
	    unsigned cli$v_qdusrv   : 1; /* user contex value is present */
	    unsigned cli$v_qdexpa   : 1; /* take action on explicit occurances */
	    unsigned		    : 5;
	} cli$r_qdflgs_bits;
    } cli$r_qdflgs_overlay;
    union {
	unsigned char cli$b_qdstat;	/* qualifier status */
	struct {
	    unsigned cli$v_qualtru : 1; /* qualifier is true */
	    unsigned cli$v_qualexp : 1; /* qualifier explicitly stated */
	    unsigned		   : 6;
	} cli$r_qdstat_bits;
    } cli$r_qdstat_overlay;
    union {
	unsigned int cli$q_qdvaldesc[2]; /* qualifier value descriptor */
	struct {
	    unsigned short cli$w_qdvalsiz; /* size of value */
	    unsigned	: 16;		/* short fill; spare word */
	    int *cli$a_qdvaladr;	/* address of value string */
	} cli$r_qdvaldesc_fields;
    } cli$r_qdvaldesc_overlay;
    int *cli$a_truact;			/* qualifier true action routine */
    int *cli$a_flsact;			/* qualifier false action routine */
    unsigned long cli$l_usrval;		/* option user value if present */
};
/* Define space for the result parse work area */
#define CLI$K_WORKAREA 128		/* size of header */
#define CLI$C_WORKAREA 128

/* Define CLI utility request codes */
/*
   codes are 8 bits, consisting of 2 4 bit fields
   the least 4 bits are subfuction definitons
   and the most significant 4 bits are request type
 */
/* Define request type codes */
#define CLI$K_UTILOPR	0		/* utility operations */
#define CLI$K_INPSPEC	1		/* request for an input specification */
#define CLI$K_OUTSPEC	2		/* an output file specification */
#define CLI$K_PARDONE	3		/* parameter done request */
#define CLI$K_VALCONV	4		/* request a value conversion */
#define CLI$K_CLINT	5		/* clint operations */
/* */
/* Define complete codes for utility operations */
#define CLI$K_INITPRS	0		/* request initialization of parse */
#define CLI$K_GETCMD	1		/* get command buffer limits */
#define CLI$K_GETQUAL	2		/* optain state of qualifiers */
#define CLI$K_GETOPT	3		/* decode command option */
#define CLI$K_GETLINE	4		/* get command line */
/*
   The cliserv request type appears here, instead of with the other request
   types, because it has no subfunctions associated with it, and because a
   day 1 coding error causes DCL to expect that this request number will
   appear in the subfunction bits.  This means that no utility operation
   can be defined with the subfunction number 5.
 */
#define CLI$K_CLISERV	5		/* request a service from the CLI */
/* */
/* Define complete codes for input specifications */
#define CLI$K_INPUT1	16		/* primary input */
#define CLI$K_INPUT2	17		/* secondary input */
#define CLI$K_INPUT3	18		/* third, */
#define CLI$K_INPUT4	19		/* etc,etc,etc */
/* Define complete codes for output specifications */
#define CLI$K_OUTPUT1	32		/* first output */
#define CLI$K_OUTPUT2	33		/* second output */
#define CLI$K_OUTPUT3	34		/* third,- */
#define CLI$K_OUTPUT4	35		/* etc,etc,etc */
/* Define codes for result parse parameter completion */
#define CLI$K_ENDPRM1	48		/* completed parameter set 1 */
#define CLI$K_ENDPRM2	49		/* " set 2 */
#define CLI$K_ENDPRM3	50		/* " set 3 */
#define CLI$K_ENDPRM4	51		/* " set 4 */
/* Define codes for value conversion requests */
#define CLI$K_NUMERVAL	64		/* numberic value */
#define CLI$K_ASCIIVAL	65		/* ascii value */
#define CLI$K_KEYWORD	66		/* keyword value */
#define CLI$K_KEYVAL	67		/* keyword with value */
#define CLI$K_FILSPEC	68		/* value is a filespec */
/* Define complete codes for utility operations */
#define CLI$K_PRESENT	80		/* determine if entity is present */
#define CLI$K_GETVALUE	81		/* get value of entity */
#define CLI$K_ENDPARSE	82		/* clean up after parsing command */
#define CLI$K_DCLPARSE	83		/* parse user command line */
#define CLI$K_DISPATCH	84		/* dispatch to action routine */
#define CLI$K_NEXTQUAL	85		/* process next qualifier */
union clidef7 {
    unsigned long cli$l_workarea[32];	/* allocate 32 long words */
};

/* define set code set request block (V5.5) */
struct clidef8 {
    unsigned	: 8, : 8, : 8, : 8;	/* char fill[4]; */
    unsigned long cli$l_codeset;	/* code set value */
};

#endif	/*_CLIDEF_H*/
