/* <vms/climsgdef.h>
 *
 *	DCL status codes.
 */
#ifndef _VMS_CLIMSGDEF_H
#define _VMS_CLIMSGDEF_H

#define CLI$_FACILITY	3

/* generic success */
#define CLI$_NORMAL	0x00030001	/* normal successful completion */

/* warnings */
#define CLI$_ABVERB	0x00038008	/* ambiguous command verb - supply more characters */
#define CLI$_ABKEYW	0x00038010	/* ambiguous qualifier or keyword - supply more characters */
#define CLI$_BUFOVF	0x00038018	/* command buffer overflow - shorten expression or command line */
#define CLI$_COMPLX	0x00038020	/* expression too complex - simplify */
#define CLI$_DEFOVF	0x00038028	/* too many command procedure parameters - limit to eight */
#define CLI$_DIRECT	0x00038030	/* invalid directory syntax - check brackets and other delimiters */
#define CLI$_EXPSYN	0x00038038	/* invalid expression syntax - check operators and operands */
#define CLI$_IMCHNG	0x00038040	/* two images requested in one command */
#define CLI$_INSFPRM	0x00038048	/* missing command parameters - supply all required parameters */
#define CLI$_IVCHAR	0x00038050	/* invalid numeric value - check for invalid digits */
#define CLI$_IVKEYW	0x00038060	/* unrecognized keyword - check validity and spelling */
#define CLI$_IVOPER	0x00038068	/* unrecognized operator in expression - check spelling and syntax */
#define CLI$_IVPROT	0x00038070	/* invalid protection code - only use combinations of R,W,E, and D */
#define CLI$_IVQLOC	0x00038078	/* invalid qualifier location - place after a parameter */
#define CLI$_IVSYMB	0x00038080	/* invalid symbol name - start name with an alphabetic character */
#define CLI$_IVVALU	0x00038088	/* invalid value syntax - see command documentation */
#define CLI$_IVVERB	0x00038090	/* unrecognized command verb - check validity and spelling */
#define CLI$_MAXPARM	0x00038098	/* too many parameters - reenter command with fewer parameters */
#define CLI$_NOATFIL	0x000380A0	/* no file name for command procedure */
#define CLI$_NOCCAT	0x000380A8	/* parameter concatenation not allowed - check use of plus (+) */
#define CLI$_NOCOMD	0x000380B0	/* no command on line - reenter with alphabetic first character */
#define CLI$_NOKEYW	0x000380B8	/* qualifier name is missing - append the name to the slash */
#define CLI$_NOLIST	0x000380C0	/* list of parameter values not allowed - check use of comma (,) */
#define CLI$_NOQUAL	0x000380C8	/* qualifiers not allowed - supply only verb and parameters */
#define CLI$_NOVALU	0x000380D0	/* value not allowed - remove value specification */
#define CLI$_NOTNEG	0x000380D8	/* qualifier or keyword not negatable - remove "NO" or omit */
#define CLI$_NULFIL	0x000380E0	/* missing or invalid file specification - respecify */
#define CLI$_NUMBER	0x000380E8	/* invalid numeric value - supply an integer */
#define CLI$_ONCOMD	0x000380F0	/* ON command too large - decrease the length of the THEN clause */
#define CLI$_ONERR	0x000380F8	/* invalid ON condition - use WARNING, SEVERE, ERROR, or CONTROL_Y */
#define CLI$_ONLEVL	0x00038100	/* invalid ON context - use only within command procedures */
#define CLI$_ONOVF	0x00038108	/* no room for ON command - symbol overflow, delete some symbols */
#define CLI$_PARMDEL	0x00038110	/* invalid parameter delimiter - check use of special characters */
#define CLI$_RSLOVF	0x00038118	/* buffer overflow - specify fewer command elements */
#define CLI$_SKPDAT	0x00038120	/* image data (records not beginning with "$") ignored */
#define CLI$_STKOVF	0x00038128	/* command procedures too deeply nested - limit to 32 levels */
#define CLI$_SYMDEL	0x00038130	/* invalid symbol or value delimiter - check command syntax */
#define CLI$_SYMOVF	0x00038138	/* no room for symbol definitions - delete some symbols */
#define CLI$_UNDSYM	0x00038140	/* undefined symbol - check validity and spelling */
#define CLI$_USGOTO	0x00038148	/* target of GOTO not found - check spelling and presence of label */
#define CLI$_VALREQ	0x00038150	/* missing qualifier or keyword value - supply all required values */
#define CLI$_ONEVAL	0x00038158	/* list of values not allowed - check use of comma (,) */
#define CLI$_OVRFLW	0x00038160	/* too much data - modify size of field or size of data */
#define CLI$_UNPROQUAL	0x00038168	/* unprocessed qualifiers */
#define CLI$_UNPROPARM	0x00038170	/* unprocessed parameters */
#define CLI$_INVKEY	0x00038178	/* invalid keyword */
#define CLI$_INVRSP	0x00038180	/* invalid response */
#define CLI$_UNDFIL	0x00038188	/* file has not been opened by DCL - check logical name */
#define CLI$_FILOPN	0x00038190	/* file is already open */
#define CLI$_BADRET	0x00038198	/* RETURN was issued without a subroutine */
#define CLI$_ABSYMD	0x000381A0	/* abbreviated symbol definition conflict - rename symbol */
#define CLI$_INVUIC	0x000381A8	/* invalid UIC - must be of the form [group,member] */
#define CLI$_BADTEXT	0x000381B0	/*   \!AS\!AS */
#define CLI$_ABFNAM	0x000381B8	/* ambiguous lexical function name - supply more characters */
#define CLI$_IVFNAM	0x000381C0	/* invalid lexical function name - check validity and spelling */
#define CLI$_BLKOVRFLOW 0x000381C8	/* block overflow */
#define CLI$_BLKUNDFLOW 0x000381D0	/* block underflow */
#define CLI$_BADBLK	0x000381D8	/* END issued without corresponding BEGIN */
#define CLI$_NOLBLS	0x000381E0	/* label ignored - use only within command procedures */
#define CLI$_NOCHANGE	0x000381E8	/* neither directory nor UIC could be changed - see documentation */
#define CLI$_ABSENT	0x000381F0	/* entity or value absent from command string */
#define CLI$_NEGATED	0x000381F8	/* entity explicitly negated in command string */
#define CLI$_INVFILSPE	0x00038200	/* input or output file specification too long - shorten */
#define CLI$_INVLOGFIL	0x00038208	/* invalid log file specification */
#define CLI$_NOTHEN	0x00038210	/* IF or ON statement syntax error - check placement of THEN keyword */
#define CLI$_SYMTOOLNG	0x00038218	/* symbol !AS is too long to copy to subprocess */
#define CLI$_ASTDCL	0x00038220	/* out-of-band or ctrl/c AST's will also be delivered to parent */
#define CLI$_INVRANGE	0x00038228	/* field specification is out of bounds - check sign and size */
#define CLI$_LOCNEG	0x00038230	/* entity explicitly and locally negated in command string */
#define CLI$_CMDNOTFND	0x00038238	/* command not found - use RECALL/ALL to display saved commands */
#define CLI$_IVQUAL	0x00038240	/* unrecognized qualifier - check validity, spelling, and placement */
#define CLI$_CMDSEG	0x00038248	/*  \!AS\ */
#define CLI$_NOTIFY	0x00038250	/* /NOTIFY not allowed - do not use with /WAIT or in batch jobs */
#define CLI$_CONFLICT	0x00038258	/* illegal combination of command elements - check documentation */
#define CLI$_UNDKEY	0x00038260	/* !AC key !AS is undefined */
#define CLI$_ARGREQ	0x00038268	/* missing argument - supply all required arguments */
#define CLI$_SYMLNG	0x00038270	/* symbol name is too long - shorten the name */
#define CLI$_SYMABR	0x00038278	/* abbreviated symbols not allowed - remove "*" from symbol name */
#define CLI$_IVKEYNAM	0x00038280	/* unrecognized key name - check validity and spelling */
#define CLI$_NOPAREN	0x00038288	/* value improperly delimited - supply parenthesis */
#define CLI$_IVATIME	0x00038290	/* invalid absolute time - use DD-MMM-YYYY:HH:MM:SS.CC format */
#define CLI$_IVDTIME	0x00038298	/* invalid delta time - use DDDD-HH:MM:SS.CC format */
#define CLI$_TKNOVF	0x000382A0	/* command element is too long - shorten */
#define CLI$_CMDFILERR	0x000382A8	/* login command file initialization error */
#define CLI$_INVOUTSPE	0x000382B0	/* invalid output file assignment */
#define CLI$_PERMSYM	0x000382B8	/* deletion of permanent symbols not allowed */
#define CLI$_GBLNDF	0x000382C0	/* cannot define symbol - global symbol scoping is enabled */
#define CLI$_INVGOSUB	0x000382C8	/* invalid use of the GOSUB command */
#define CLI$_GOSUBMAX	0x000382D0	/* GOSUB procedures too deeply nested - limit to 16 levels */
#define CLI$_USCALL	0x000382D8	/* CALL target !AC either missing, misspelled, or inaccessible */
#define CLI$_USGOSUB	0x000382E0	/* target of GOSUB not found - check spelling and presence of label */
#define CLI$_FRZNCTX	0x000382E8	/* context is frozen - either cancel this context or use alternate */
#define CLI$_NOTCTX	0x000382F0	/* symbol specified is not a valid context symbol */
#define CLI$_INVCTXTYP	0x000382F8	/* symbol specified is defined for a different context type */
#define CLI$_CMDSEG2	0x00038300	/* \\ */
#define CLI$_INVNOD	0x00038308	/* invalid node name specification; respecify */

/* errors */
#define CLI$_CONFQUAL	0x00038802	/* conflicting qualifiers */
#define CLI$_INVQUAL	0x0003880A	/* invalid qualifier */
#define CLI$_REQPRMABS	0x00038812	/* required parameter is absent */
#define CLI$_INVQUALNUM 0x0003881A	/* invalid qualifier number */
#define CLI$_INVREQTYP	0x00038822	/* invalid request type */
#define CLI$_NOVALUE	0x0003882A	/* value not present */
#define CLI$_VALCNVERR	0x00038832	/* error converting value */
#define CLI$_ILLVAL	0x0003883A	/* illegal value is present */
#define CLI$_NOOPTPRS	0x00038842	/* no option present on command */
#define CLI$_CREQUEJOB	0x0003884A	/* error creating job on queue !AS */
#define CLI$_SUBMITERR	0x00038852	/* error submitting file to queue !AS */
#define CLI$_DEVALSPL	0x0003885A	/* device already spooled */
#define CLI$_DEVNOTSPL	0x00038862	/* device not spooled */
#define CLI$_IVDEVTYPE	0x0003886A	/* invalid device type - specify a mailbox device */
#define CLI$_IMGFNF	0x00038872	/* image file not found */
#define CLI$_DEVNOTFOR	0x0003887A	/* device not mounted foreign */
#define CLI$_PWDNOTVAL	0x00038882	/* old password validation error - password unchanged */
#define CLI$_PWDNOTVER	0x0003888A	/* new password verification error - password unchanged */
#define CLI$_PWDLOCKED	0x00038892	/* password was locked to prevent change */
#define CLI$_NOTFR	0x0003889A	/* no transfer address */
#define CLI$_PWDSYNTAX	0x000388A2	/* illegal password syntax */
#define CLI$_IMGNAME	0x000388AA	/* image file !AS */
#define CLI$_IMAGEFNF	0x000388B2	/* image file not found !AS */
#define CLI$_BADSTRLVL	0x000388BA	/* unrecognized structure level for command tables */
#define CLI$_REFUSED	0x000388C2	/* you cannot attach to that process */
#define CLI$_BADCTLMSK	0x000388CA	/* bad control character enable/disable mask */
#define CLI$_INVRFM	0x000388D2	/* invalid record format for record I/O - file not opened */
#define CLI$_NOCLINT	0x000388DA	/* image requested CLI interface routine that does not exist */
#define CLI$_NOSPAWN	0x000388E2	/* DCL cannot spawn an MCR subprocess - subprocess aborted */
#define CLI$_SPWNIO	0x000388EA	/* shared input or output files are not allowed - respecify */
#define CLI$_TRMMBX	0x000388F2	/* terminal has associated mailbox - terminate image and then SPAWN */
#define CLI$_STRTOOLNG	0x000388FA	/* string argument is too long - shorten */
#define CLI$_CMDGONE	0x00038902	/* this is no longer a valid command - see documentation */
#define CLI$_NOCMDPROC	0x0003890A	/* error opening captive command procedure - access denied */
#define CLI$_INVROUT	0x00038912	/* invalid routine specified in command tables - check .CLD file */
#define CLI$_OLDTAB	0x0003891A	/* command tables have obsolete format - use SET COMMAND to recreate */
#define CLI$_INVTAB	0x00038922	/* command tables have invalid format - see documentation */
#define CLI$_NOTDISCON	0x0003892A	/* terminal is not disconnectable - explicitly specify LOGOUT */
#define CLI$_ENTNF	0x00038932	/* specified entity not found in command tables */
#define CLI$_ATTRMBX	0x0003893A	/* cannot attach to that process - terminal has associated mailbox */
#define CLI$_INVCALL	0x00038942	/* invalid CALL nesting structure or data inconsistency detected */
#define CLI$_INVIFNEST	0x0003894A	/* invalid IF-THEN-ELSE nesting structure or data inconsistency */
#define CLI$_CAPTINT	0x00038952	/* captive account - interactive access denied */
#define CLI$_CAPTINQ	0x0003895A	/* captive account - inquire command not valid */
#define CLI$_NOFORCMD	0x00038962	/* account restricted - foreign commands not valid */
#define CLI$_NORUNMCR	0x0003896A	/* account restricted - RUN and MCR commands not valid */
#define CLI$_NOREADCP	0x00038972	/* No read access to interrupted command procedure */
#define CLI$_INVPREFIX	0x0003897A	/* invalid prefix format string - check FAO directives */
#define CLI$_CAPTSPAWN	0x00038982	/* captive account - SPAWN command not allowed */

/* informationals */
#define CLI$_DEFKEY	0x0003DDC3	/* !AC key !AS has been defined */
#define CLI$_DELKEY	0x0003DDCB	/* !AC key !AC has been deleted */
#define CLI$_SETKEY	0x0003DDD3	/* keypad state has been set to !AC */
#define CLI$_SPARE1	0x0003DDDB	/* spare - for future use */
#define CLI$_ALLOC	0x0003DDE3	/* !AS allocated */
#define CLI$_SUPERSEDE	0x0003DDEB	/* previous value of !AS has been superseded */
#define CLI$_INSPRIV	0x0003DDF3	/* insufficient privilege to change UIC - you need CMKRNL privilege */
#define CLI$_NODIRCHG	0x0003DDFB	/* directory cannot be changed to match UIC greater than [377,377] */
#define CLI$_IGNQUAL	0x0003DE03	/* qualifiers appearing before this item were ignored */
#define CLI$_TABEXIST	0x0003DE0B	/* !AS already exists - not superseded */
#define CLI$_TABSUPER	0x0003DE13	/* previous table !AS has been superseded */
#define CLI$_TABNOTFND	0x0003DE1B	/* previous table !AS was not found - new table created */
#define CLI$_DELSYM	0x0003DE23	/* !AC symbol !AC has been deleted */
#define CLI$_SYMTRUNC	0x0003DE2B	/* preceding symbol value has been truncated */
#define CLI$_KEYCNV	0x0003DE33	/* synonym key !AS has been converted to !AS */
#define CLI$_INVDEF	0x0003DE3B	/* !AD does not exist */
#define CLI$_MISSPELL	0x0003DE43	/* !AC !AD is misspelled, using !AC !AC!AC */
#define CLI$_MSNGENDS	0x0003DE4B	/* missing or misspelled ENDSUBROUTINE statement detected while scanning for label */

/* success codes */
#define CLI$_SPAWNED	0x0003FD01	/* process !AS spawned */
#define CLI$_ATTACHED	0x0003FD09	/* terminal now attached to process !AS */
#define CLI$_RETURNED	0x0003FD11	/* control returned to process !AS */
#define CLI$_PRESENT	0x0003FD19	/* entity value is present in command string */
#define CLI$_DEFAULTED	0x0003FD21	/* entity defaulted present in command string */
#define CLI$_CONCAT	0x0003FD29	/* requested value is terminated by a plus sign */
#define CLI$_LOCPRES	0x0003FD31	/* entity value is locally present in command string */
#define CLI$_COMMA	0x0003FD39	/* requested value is terminated by a comma */
#define CLI$_OKTAB	0x0003FD41	/* command tables are already in latest format */
#define CLI$_UPGTAB	0x0003FD49	/* command tables have been upgraded to latest format */
#define CLI$_PROC_ID	0x0003FFF1	/* identification of created process is !XL */
#define CLI$_QUEJOBCRE	0x0003FFF9	/*   Job !UW entered on queue !AC */

#endif	/*_VMS_CLIMSGDEF_H*/
