//
// Set.cpp
// Implementation of Set template class
//
// To be used with article from C++ Users Journal
// Developed by Jim Beveridge, May, 1997
//

#include <stdlib.h>
#include "Set.h"

// Use explicit instantiation to create the various
// versions of the template that will be used by the
// rest of the program.
template Set<int>;
template Set<double>;

//////////////////////////////////////////////////////
// template class Set function implementations
//////////////////////////////////////////////////////

template<class T> 
Set<T>::Set()
{
    m_Values = NULL;
    m_Count = 0;
}

template<class T> 
Set<T>::~Set()
{
    Empty();
}

template<class T> 
void Set<T>::Add(const T& val)
{
    // Don't add if a duplicate
    if (!Lookup(val))
    {
        // Growth size of one is extremely inefficient,
        // but works for illustration purposes.
        T* pT = new T[m_Count+1];
        for (int i=0;i<m_Count;i++)
            pT[i] = m_Values[i];
        delete [] m_Values;
        m_Values = pT;
        pT[m_Count++] = val;
    }
}


template<class T>
bool Set<T>::Lookup(const T& val) const
{
    for (int i=0;i<m_Count;i++)
        if ( m_Values[i] == val )
            return true;
    return false;
}

template<class T> 
Set<T>& Set<T>::operator= (const Set<T>& s)
{
    Empty();
    m_Values = new T[s.m_Count];
    for (int i=0;i<s.m_Count;i++)
        m_Values[i] = s.m_Values[i];
    m_Count = s.m_Count;
    return *this;
}


template<class T> 
void Set<T>::Empty()
{
    delete [] m_Values;
    m_Values = NULL;
    m_Count = 0;
}


