//
// Set.h
// Declarations for Set template class
//
// To be used with article from C++ Users Journal
// Developed by Jim Beveridge, May, 1997
//

#ifndef _SET_H_
#define _SET_H_

// Deal with compilers that aren't up to snuff
#if defined(_MSC_VER) && _MSC_VER < 1100
#define bool int
#define true 1
#define false 0
#endif

///////////////////////////////////////////////////
// class Set Definition
// Keeps a collection of items with no duplicates.
// This is a "toy" collection class and not
// suitable for production work.

template <class T>
class Set
{
public:

    // Default constructor.
    Set();

    // Destructor.
    ~Set();

    // Determine if a value is in the set
    bool Lookup(const T&) const;

    // Add a value to the set
    void Add(const T&);

    // Delete everything in the set
    void Empty();

    // Assignment operator
    Set<T>& operator=(const Set<T>&);

    private:
    // Pointer to array of elements in set
    T*  m_Values;

    // Number of elements in set
    int m_Count;
};

#endif // _SET_H_
