001 #!/bin/ksh
002
003 TARGET_TYPE=""
004 TARGET_NAME=`basename $PWD`
005 SOURCES=$(echo `ls -1 *.c *.C *.cpp 2>/dev/null`) 
006 TOOLS_DIR=`dirname $0`
007
008 if [ -a $TOOLS_DIR/includes ]
009 then INCLUDE_DIRS=$(sed -n 's/ *-I *\(.*\) */\1/p' 
$TOOLS_DIR/includes)
010 else INCLUDE_DIRS=""
011 fi
012
013 ### Support functions.
014
015 search_for_includes()
016 {
017    LAST_INCLUDE_DIR=${INCDIR:-/usr/include} 
018
019    for THE_INCLUDE in $*
020    do
021       if [ -a $THE_INCLUDE ]
022       then echo "\t\t$THE_INCLUDE \\" ; continue 
023       else
024          for INCLUDE_DIR in $INCLUDE_DIRS 
025          do
026             if [ -a $INCLUDE_DIR/$THE_INCLUDE ]
027             then echo "\t\t$INCLUDE_DIR/$THE_INCLUDE \\" ; continue 
2
028             fi
029          done
030       fi
031       if [ -a $LAST_INCLUDE_DIR/$THE_INCLUDE ]
032       then echo "\t\t$LAST_INCLUDE_DIR/$THE_INCLUDE \\" 
033       fi
034    done
035 }
036
037 usage()
038 {
039    echo "Usage: mkmk [ -exec | -shared | -static ] [ target_name ]" 
040    exit
041 }
042
043 analyse_sources()
044 {
045    for current_file in $*
046    do
047       found=`grep -l main $current_file` 
048       if [ "$found" = "$current_file" ] 
049       then
050          TARGET_TYPE=EXECUTABLE
051          return
052       fi
053    done
054
055    TARGET_TYPE=SHARED
056 }
057
058 set_type()
059 {
060    case $1 in
061       analyse) analyse_sources $SOURCES ;; 
062         -exec) TARGET_TYPE=EXECUTABLE ;; 
063       -shared) TARGET_TYPE=SHARED ;;
064       -static) TARGET_TYPE=STATIC ;; 
065             *) usage ;;
066    esac
067 }
068
069 set_name()
070 {
071    TARGET_NAME=$1
072 }
073
074 ### Analyse input parameters.
075 ### Usage: mkmk [ -exec | -shared | -static ] [ target_name ] 
076
077 case $# in
078    0) set_type analyse
079       set_name `basename $PWD`
080       ;;
081    1) if [ "${1##-*}" = "" ]
082       then
083          set_type $1
084          set_name `basename $PWD` 
085       else
086          set_type analyse
087          set_name $1
088       fi
089       ;;
090    2) set_type $1
091       set_name $2
092       ;;
093    *) usage
094       ;;
095 esac
096
097 ### Set PROJECT_DIR variable:
098 ### If the variable is set, its value will be used. 
099 ### Otherwise if the current directory mathes the 
100 ### 'project_dir/src/sub-project_dir' pattern,
101 ### the 'project_dir' value will be used.
102 ### Otherwise $HOME directory will be used as PROJECT_DIR. 
103
104 if [ ${PROJECT_DIR:-PROJECT_DIR_UNDEFINED} == PROJECT_DIR_UNDEFINED 
]
105 then
106    if [ $(basename $(dirname $PWD)) = src ] 
107    then PROJECT_DIR=$(dirname $(dirname $PWD)) 
108    else PROJECT_DIR=$HOME
109    fi
110 fi
111
112 ### Build the project hierarchy. 
113
114 # if [ ! -d $PROJECT_DIR/include ] 
115 # then mkdir $PROJECT_DIR/include 
116 # fi
117 # if [ ! -d $PROJECT_DIR/lib ]
118 # then mkdir $PROJECT_DIR/lib
119 # fi
120 # if [ ! -d $PROJECT_DIR/bin ]
121 # then mkdir $PROJECT_DIR/bin
122 # fi
123 # if [ ! -d $PROJECT_DIR/src ]
124 # then mkdir $PROJECT_DIR/src
125 # fi
126
127 ### Build makefile.
128 (
129 echo "### Do not edit. Autogenerated makefile." 
130 echo
131 echo "TOOLS_DIR      = $TOOLS_DIR" 
132 echo "PROJECT_DIR    = $PROJECT_DIR"
133 echo "STATIC_LIBRARY = \$(PROJECT_DIR)/lib/lib$TARGET_NAME.a" 
134 echo "SHARED_LIBRARY = \$(PROJECT_DIR)/lib/lib$TARGET_NAME.so" 
135 echo "EXECUTABLE     = \$(PROJECT_DIR)/bin/$TARGET_NAME"
136 echo "SOURCES        = $SOURCES" 
137 echo
138
139 case $TARGET_TYPE in
140    EXECUTABLE) echo 'make: delete $(EXECUTABLE)' ;;
141        SHARED) echo 'make: delete $(SHARED_LIBRARY)' ;; 
142        STATIC) echo 'make: delete $(STATIC_LIBRARY)' ;; 
143             *) usage ;;
144 esac
145
146 echo
147 echo 'include $(TOOLS_DIR)/mkmk.inc' 
148 echo
149
150 ### Generate dependencies.
151
152 for SOURCE_FILE in $SOURCES
153 do
154    OBJECT_FILE=$(echo $SOURCE_FILE | sed -e 's/\..*/\.o/p') 
155    INCLUDES1=$(sed -n -e 's/^\#include *"\(.*\)".*/\1/p' 
$SOURCE_FILE)
156    INCLUDES2=$(sed -n -e 's/^\#include *<\(.*\)>.*/\1/p' 
$SOURCE_FILE)
157    echo "$OBJECT_FILE:\t$SOURCE_FILE \\" 
158    search_for_includes $INCLUDES1
159    search_for_includes $INCLUDES2 
160    echo "\t"
161 done
162 ) > makefile
