#!/bin/ksh

TARGET_TYPE=""
TARGET_NAME=`basename $PWD`
SOURCES=$(echo `ls -1 *.c *.C *.cc *.CC *.cpp 2>/dev/null`)
TOOLS_DIR=`dirname $0`

### INCDIR is checked by compiler last. Usually /usr/include.

if [ -a $TOOLS_DIR/includes ]
then INCLUDE_DIRS=$(sed -n 's/ *-I *\(.*\) */\1/p' $TOOLS_DIR/includes)
else INCLUDE_DIRS=""
fi

### Functions

search_for_includes()
{
   LAST_INCLUDE_DIR=${INCDIR:-/usr/include}

   for THE_INCLUDE in $*
   do
      if [ -a $THE_INCLUDE ] 
      then echo "\t\t$THE_INCLUDE \\" ; continue
      else 
         for INCLUDE_DIR in $INCLUDE_DIRS
         do
            if [ -a $INCLUDE_DIR/$THE_INCLUDE ] 
            then echo "\t\t$INCLUDE_DIR/$THE_INCLUDE \\" ; continue 2
            fi
         done
      fi
      if [ -a $LAST_INCLUDE_DIR/$THE_INCLUDE ] 
      then echo "\t\t$LAST_INCLUDE_DIR/$THE_INCLUDE \\"
      fi 
   done
}

usage()
{
   echo "Usage: mkmk [ -exec | -shared | -static ] [ target_name ]"
   exit
}

analyse_sources()
{
   for current_file in $*
   do
      found=`grep -l main $current_file`
      if [ "$found" = "$current_file" ]
      then
         TARGET_TYPE=EXECUTABLE
         return
      fi
   done

   TARGET_TYPE=SHARED
   return
}

set_type()
{
   case $1 in
      analyse) analyse_sources $SOURCES ;;
        -exec) TARGET_TYPE=EXECUTABLE ;;
      -shared) TARGET_TYPE=SHARED ;;
      -static) TARGET_TYPE=STATIC ;;
            *) usage ;;
   esac
}

set_name()
{
   TARGET_NAME=$1
}

### Analyse input parameters.
### Usage: mkmk [ -exec | -shared | -static ] [ target_name ]

case $# in
   0) set_type analyse
      set_name `basename $PWD`
      ;;
   1) if [ "${1##-*}" = "" ]
      then
         set_type $1
         set_name `basename $PWD`
      else
         set_type analyse
         set_name $1
      fi
      ;;
   2) set_type $1
      set_name $2
      ;;
   *) usage
      ;;
esac

### Set PROJECT_DIR variable:
### If the variable is set, its value will be used. 
### Otherwise if the current directory matches the 
### 'project_dir/src/sub-project_dir' pattern, 
### the 'project_dir' value will be used. 
### Otherwise $HOME directory will be used as PROJECT_DIR.

if [ ${PROJECT_DIR:-PROJECT_DIR_UNDEFINED} == PROJECT_DIR_UNDEFINED ]
then
   if [ $(basename $(dirname $PWD)) = src ]
   then PROJECT_DIR=$(dirname $(dirname $PWD))
   else PROJECT_DIR=$HOME
   fi
fi

### Build the project hierarchy.

# if [ ! -d $PROJECT_DIR/include ]
# then mkdir $PROJECT_DIR/include
# fi
# if [ ! -d $PROJECT_DIR/lib ]
# then mkdir $PROJECT_DIR/lib
# fi
# if [ ! -d $PROJECT_DIR/bin ]
# then mkdir $PROJECT_DIR/bin
# fi
# if [ ! -d $PROJECT_DIR/src ]
# then mkdir $PROJECT_DIR/src
# fi
# if [ ! -d $HOME/include ]
# then mkdir $HOME/include
# fi
# ### Create a simbolic link in $HOME/include directory.
# if [ ! -d $HOME/include/$PROJECT_DIR ]
# then
#    real_thing=$PROJECT_DIR/include
#    symbolic_link=$HOME/include/$TARGET_NAME
#    ln -s $real_thing $symbolic_link 
# fi   

### Build makefile.
(
echo "### Do not edit. Autogenerated makefile."
echo
echo "CC             = CC"
echo "TOOLS_DIR      = $TOOLS_DIR"
echo "PROJECT_DIR    = $PROJECT_DIR"
echo "STATIC_LIBRARY = \$(PROJECT_DIR)/lib/lib$TARGET_NAME.a"
echo "SHARED_LIBRARY = \$(PROJECT_DIR)/lib/lib$TARGET_NAME.so"
echo "EXECUTABLE     = \$(PROJECT_DIR)/bin/$TARGET_NAME"
echo "SOURCES        = $SOURCES"
echo

case $TARGET_TYPE in
   EXECUTABLE) echo 'make: delete $(EXECUTABLE)' ;;
       SHARED) echo 'make: delete $(SHARED_LIBRARY)' ;;
       STATIC) echo 'make: delete $(STATIC_LIBRARY)' ;;
            *) usage ;;
esac

echo
echo 'include $(TOOLS_DIR)/mkmk.inc'
echo

### Build dependencies.

for SOURCE_FILE in $SOURCES
do
#  OBJECT_FILE=$(echo $SOURCE_FILE | sed -e 's/\.[cC][cC]*/\.o/p') # UnixWare
   OBJECT_FILE=$(echo $SOURCE_FILE | sed -e 's/\.[cC][cC]*/\.o/')  # SunOS 5.3
   INCLUDES1=$(sed -n -e 's/^\#include *"\(.*\)".*/\1/p' $SOURCE_FILE)
   INCLUDES2=$(sed -n -e 's/^\#include *<\(.*\)>.*/\1/p' $SOURCE_FILE)
   echo "$OBJECT_FILE:\t$SOURCE_FILE \\"
   search_for_includes $INCLUDES1
   search_for_includes $INCLUDES2
   echo "\t"
done
) > makefile
