//   Sample file that uses the triangulation package.
//   J. David Wendel   April 5, 1997

#include<stdio.h>
#include<conio.h>  // getch()
#include<stdlib.h> //  srand() and rand()
#include<bios.h>  //  time function
#include<graphics.h>
#include"tri.h"

int use_bgi = 1;

int color = 1;

//  Borland BGI stuff.
void init_bgi(void)
{
  int g_driver, g_mode;

  if(registerbgidriver(EGAVGA_driver) < 0)  exit(1);
  detectgraph(&g_driver, &g_mode);
  initgraph(&g_driver, &g_mode, "");

  setbkcolor(BLACK);
  setcolor(WHITE);
}

void main(void)
{

  //  use the bios clock to give a different random seed each
run.
  long tmp2 = 0;
  int btime = int(biostime(0,tmp2) % 10000);
  srand(btime);

  if (use_bgi) init_bgi();

  //  Use a seperate compiler scope for creation vs. search.
  //  This can be broken out to seperate executables.  The
search
  //  is completely independent of the creation.
  {
    triangulation tri;
    //  create the points and give them to the triangulation.
    for (int i=0; i<max_pts; i++) {
      int x = rand() % 400 + 5;
      int y = rand() % 400 + 5;
      int z = rand() % 400 + 5;
      tri.give_vertex(pt(x,y,z));
    }

    tri.create_triangulation();
    //tri.create_nlogn_triangulation();
    tri.save_triangulation("tri.dat");

  } // end of creation scope.

  getch(); 

  //  Search scope.
  {
    run_time run;
    run.load_triangulation("tri.dat");
    for (int i=400; i>0; i--) {
      run.give_position(pt(i+20,i,10));
      run.do_it();
      getch();
    } // end loop

  } // end search scope

  getch();

  if (use_bgi) closegraph();
}




