//   Triangulation file
//   J. David Wendel   April 5, 1997

#include<stdio.h>
#include<math.h>   // acos()
#include<graphics.h>
#include<conio.h>  // getch()
#include"tri.h"

enum boolean {false = 0, true =1};
extern int use_bgi;
extern int color;

//  This is the less-than opperator used in the shell sort of
//  the d_array.  It sorts by first vertex, when the first vertices
//  are equal, then it sorts by angle in a counter-clockwise
direction.
int vector::operator<(vector &v)
{
  if (x[0][0] < v.x[0][0]) return 1;
  if (x[0][0] > v.x[0][0]) return 0;
  if (x[0][1] < v.x[0][1]) return 1;
  if (x[0][1] > v.x[0][1]) return 0;

  //  if execution reaches here then the two vectors share the
same
  //  first vertex.
  //compare the angle of the two vectors with the unit vector.
  vector unit(pt(1.0,0.0,0.0),pt(0.0,0.0,0.0));

  double l_angle = angle(unit, *this);
  double r_angle = angle(unit, v);

  if (l_angle < r_angle) return 1;
  return 0;
}

//  Constructor for the triangulation class.
triangulation::triangulation(void)
{
  a_array_size = 0;
  b_array_size = 0;
  c_array_size = 0;
  d_array_size = 0;
  a_array = new(pt[max_pts]);
  b_array = NULL;
  c_array = NULL;
  d_array = NULL;
  conjugate_idx = NULL;
}

//  Destructor for the triangulation class.
triangulation::~triangulation(void)
{
  delete[](a_array);
  delete[](b_array);
  delete[](c_array);
  delete[](d_array);
  delete[](conjugate_idx);
}

//  This determines whether point lies between low and high. 
 This
//  function is only called if the three points are collinear. 
When
//  it is know that they are collinear the only thing that needs
to
//  be checked is the x coordinates unless all three x
coordinates are
//  the same.  then the compaarison of the y coordinates.
int triangulation::between(pt point, pt low, pt high)
{
  if (low[0] == high[0]) {
    if (low[1] < high[1]) {
      if (point[1] <= low[1]) return false;
      if (point[1] >= high[1]) return false;
      return true;
    } else {
      if (point[1] >= low[1]) return false;
      if (point[1] <= high[1]) return false;
      return true;
    }
  }
  if (low[0] < high[0]) {
    if (point[0] <= low[0]) return false;
    if (point[0] >= high[0]) return false;
    return true;
  } else {
    if (point[0] >= low[0]) return false;
    if (point[0] <= high[0]) return false;
    return true;
  }
}

//  This function determines whether two segments intersect
or not.
//  First we check for conincident end points.  If there are
coincident
//  end points and segments are not parallel, the segments
do not
//  intersect.  If they are parallel we check to see if, for some
reason,
//  the two segments are the same.  If they are then they
intersect.
//  Next we perform two dot product tests to see if one
segment is on
//  one side of the other.  If so then the two segments do not
intersect.
//  Finally if we have passed through all of these tests
without a
//  determination, we have two segments that are not the
same but lie
//  on the same line.  We use the 'between' routine to see if
the two
//  segments overlap in any way.  If so, they intersect, if not,
they don't.
int sgn(double x)
{
  if (abs(x) < mch_error) return 0;
  return (x<0.0) ? -1 : 1;
}
int triangulation::intersect(vector a, segment b)
{
  //  First check for zero or vertical vectors.
  if (eq_2d(a[0],a[1]) || eq_2d(b[0], b[1]))
    return true;

  // Now check that there are not points on top of other
points.
  if ((!(a[0]==b[0]) && eq_2d(a[0],b[0])) ||
      (!(a[0]==b[1]) && eq_2d(a[0],b[1])) ||
      (!(a[1]==b[0]) && eq_2d(a[1],b[0])) ||
      (!(a[1]==b[1]) && eq_2d(a[1],b[1])))
    return true;

  //  Next check if the two vectors are the same.
  if ((eq_2d(a[0],b[0]) && eq_2d(a[1],b[1])) ||
      (eq_2d(a[0],b[1]) && eq_2d(a[1],b[0])))
    return true;

  int test1=sgn(dot_2d(perp_2d(a[1]-a[0]), b[0]-a[0]) *
    dot_2d(perp_2d(a[1]-a[0]), b[1]-a[0]));

  if (test1 > 0) return false;

  int test2=sgn(dot_2d(perp_2d(b[1]-b[0]), a[0]-b[0]) *
    dot_2d(perp_2d(b[1]-b[0]), a[1]-b[0]));

  if (test2 > 0) return false;
  if (test1<0 || test2<0)
    return true;

  //  if execution gets here, there are colinear points.
  //  Check to see if the two vectors are parallel.
  //  If they are not parallel then they share only one end
point and
  //  are considered not to intersect.
  if (sgn(dot_2d(perp_2d(a[1]-a[0]), b[1]-b[0])) != 0) return
false;

  //  if execution reaches here then the segments lie on the
same line.
  //  All that is left is to determine if the two segments
overlap at all.
  if (between(b[0],a[0],a[1]) || between(b[1],a[0],a[1]))
    return true;
  return between(a[0], b[0], b[1]);
}

//  This function returns the angle between two vectors.
//  The angle is measured counterclockwise from the first
edge to the
//  second edge agter both vectors have been translated to
the origin.
//  The function takes the arccos of the dot product of the
two
//  vectors and then goes through a decision matrix to
determine what
//  quadrants the vectors are in.  In order to add the correct
quantities
//  to the arccos to give the true angle between the vectors.
double angle(vector &a, vector &b)
{
  double a_len;
  double b_len;
  a_len = sqrt(sq(a[0][0] - a[1][0]) + sq(a[0][1] - a[1][1]));
  b_len = sqrt(sq(b[0][0] - b[1][0]) + sq(b[0][1] - b[1][1]));

  double dot = dot_2d(a[1]-a[0], b[1]-b[0]) / (a_len * b_len);

  //  deal with machine error.
  if (dot >1.0) dot = 1.0;
  if (dot < -1.0) dot = -1.0;

  double theta = acos(dot);

  int tmp1 = sgn(dot);
  int tmp2 = sgn(dot_2d(perp_2d(a[1]-a[0]),b[1]-b[0]));

  if (tmp2 == 0) {
    if (tmp1 == 1) return 0.0;
    return PI;
  }
  if (tmp2 == 1) return theta;
  return 2.0 * PI - theta;
}

//  Adds the problem-world definition point to the a_array.
void triangulation::give_vertex(pt &p)
{
  a_array[a_array_size] = p;
  ++a_array_size;

  if (use_bgi) {
    putpixel(p[0], p[1], WHITE);
  }
}

//  Shell sort used to sort the b_array from shortest to
longest
//  segment.
void triangulation::shell_sort_b_array(void)
{
  segment tmp;
  int inner_idx, outer_idx;
  int increment = 1;
  while (9 * increment +1 < b_array_size) increment = 3 *
increment + 1;
  while (increment != 0) {
    outer_idx = increment;
    do {
      tmp = b_array[outer_idx];
      inner_idx = outer_idx;
      while (tmp < b_array[inner_idx - increment]) {
        b_array[inner_idx] = b_array[inner_idx - increment];
        inner_idx -= increment;
        if (inner_idx - increment < 0) break;
      }
      b_array[inner_idx] = tmp;
      outer_idx += increment;
    } while (outer_idx < b_array_size);
    increment = (increment -1) / 3;
  }  // end while
}

//  Shell sort used to sort the d_array by first vertex then in a
//  counter-clockwise manner around the vertex.
void triangulation::shell_sort_d_array(void)
{
  vector tmp;
  int inner_idx, outer_idx;
  int increment = 1;
  while (9 * increment +1 < d_array_size) increment = 3 *
increment + 1;
  while (increment != 0) {
    outer_idx = increment;
    do {
      tmp = d_array[outer_idx];
      inner_idx = outer_idx;
      while (tmp < d_array[inner_idx - increment]) {
        d_array[inner_idx] = d_array[inner_idx - increment];
        inner_idx -= increment;
        if (inner_idx - increment < 0) break;
      }
      d_array[inner_idx] = tmp;
      outer_idx += increment;
    } while (outer_idx < d_array_size);
    increment = (increment -1) / 3;
  }  // end while
}

//  This function creates the  optimal triangulation.  The
b_array
//  contains all possible segment between all pairs of
vertices.  The
//  c_array contains the triangulation.  The d_array contains
the
//  triangulation to be sorted and used for the real-time
search.
//  The conjugate_idx contains the indices into the d_array
to find
//  pairs of segments in the d_array.
void triangulation::create_triangulation(void)
{
  int i,j;
  int array_size = a_array_size * (a_array_size +1) / 2; // all
pairs.
  b_array = new(segment[array_size]);
  if (b_array == NULL) {
    printf("b_array out of mem ");
    return;
  }
  array_size = 3 * (a_array_size - 1);  // upper bound.
  c_array = new(vector[array_size]);
  if (c_array == NULL) {
    printf("c_array out of mem ");
    return;
  }
  array_size *= 2;
  d_array = new(vector[array_size]);
  if (d_array == NULL) {
    printf("d_array out of mem ");
    return;
  }
  conjugate_idx = new(int[array_size]);
  if (conjugate_idx == NULL) {
    printf("conj_idx out of mem ");
    return;
  }

  for (i=0; i<a_array_size; i++)
    for (j=i+1; j<a_array_size; j++)
      b_array[b_array_size++] = segment(a_array[i],
a_array[j]);

  //if (use_bgi) printf("sort b_array ");
  shell_sort_b_array();

  vector unit(pt(1.0,0.0,0.0),pt(0.0,0.0,0.0));
  for (i=0; i<b_array_size; i++) {
    for (j=0; j<c_array_size; j++)
      if (intersect(c_array[j], b_array[i])) break;
    if (j == c_array_size) { // no intersections were found.
      c_array[c_array_size] = vector(b_array[i][0],
b_array[i][1]);
      d_array[d_array_size++] = vector(b_array[i][0],
b_array[i][1]);
      d_array[d_array_size++] = vector(b_array[i][1],
b_array[i][0]);
      if (angle(unit, c_array[c_array_size]) >= PI)
        c_array[c_array_size] = vector(b_array[i][1],
b_array[i][0]);
      if (use_bgi) {
        line(b_array[i][0][0], b_array[i][0][1],
            b_array[i][1][0], b_array[i][1][1]);
        getch();
      }
      ++c_array_size;
    }
  } // triangulation is done.

  //if (use_bgi) printf("sort d_array ");
  shell_sort_d_array();

  //  create the conjugate_idx
  for (i=0; i<d_array_size; i++) {
    for (j=0; j<d_array_size; j++) {
      if ((d_array[i][0] == d_array[j][1]) &&
          (d_array[i][1] == d_array[j][0])) {
        conjugate_idx[i] = j;
        break;
      } // end if
    } //  end for j
    if (j == d_array_size) return; //error
  } //  end for i
}

//  This function creates the n*log(n) triangulation.  The
//  c_array contains the triangulation.  The d_array contains
the
//  triangulation to be sorted and used for the real-time
search.
//  The conjugate_idx contains the indices into the d_array
to find
//  pairs of segments in the d_array.
void triangulation::create_nlogn_triangulation(void)
{
  int i,j,k;
  int array_size = 3 * (a_array_size - 1);  // upper bound.
  c_array = new(vector[array_size]);
  if (c_array == NULL) {
    printf("c_array out of mem ");
    return;
  }
  array_size *= 2;
  d_array = new(vector[array_size]);
  if (d_array == NULL) {
    printf("d_array out of mem ");
    return;
  }
  conjugate_idx = new(int[array_size]);
  if (conjugate_idx == NULL) {
    printf("conj_idx out of mem ");
    return;
  }

  segment b_seg;
  vector unit(pt(1.0,0.0,0.0),pt(0.0,0.0,0.0));
  for (i=0; i<a_array_size; i++)
    for (j=i+1; j<a_array_size; j++) {
      b_seg = segment(a_array[i], a_array[j]);
       for (k=0; k<c_array_size; k++)
         if (intersect(c_array[k], b_seg)) break;
       if (k == c_array_size) { // no intersections were found.
         c_array[c_array_size] = vector(b_seg[0], b_seg[1]);
         d_array[d_array_size++] = vector(b_seg[0], b_seg[1]);
         d_array[d_array_size++] = vector(b_seg[1], b_seg[0]);
         if (angle(unit, c_array[c_array_size]) >= PI)
           c_array[c_array_size] = vector(b_seg[1], b_seg[0]);
         if (use_bgi) {
           line(b_seg[0][0], b_seg[0][1],
               b_seg[1][0], b_seg[1][1]);
           getch();
         }
         ++c_array_size;
       }
  } // triangulation is done.

  //if (use_bgi) printf("sort d_array ");
  shell_sort_d_array();

  //  create the conjugate_idx
  for (i=0; i<d_array_size; i++) {
    for (j=0; j<d_array_size; j++) {
      if ((d_array[i][0] == d_array[j][1]) &&
          (d_array[i][1] == d_array[j][0])) {
        conjugate_idx[i] = j;
        break;
      } // end if
    } //  end for j
    if (j == d_array_size) return; //error
  } //  end for i
}

//  This function saves the searchable triangulation to disk.
//  This writes the size of the d_array then it writes the
d_array
//  and then the conjugate_idx array.
void triangulation::save_triangulation(char *filename)
{
  FILE *the_file;
  if ((the_file = fopen(filename, "wb")) == NULL) {
    printf("cannot open file %s\n", filename);
    return;
  }

  fwrite(&d_array_size, 2, 1, the_file);
  fwrite(&d_array[0], sizeof(vector), d_array_size, the_file);
  fwrite(&conjugate_idx[0], sizeof(int), d_array_size, the_file);

  fclose(the_file);
}

//  Constructor for the run-time class.
run_time::run_time(void)
{
  d_array = NULL;
  d_array_size = 0;
  conjugate_idx = NULL;
  idx1 = 0;
  idx2 = 0;
  idx3 = 0;
  height = 0.0;
}

//   Destructor for the run-time class.
run_time::~run_time(void)
{
  delete[](d_array);
  delete[](conjugate_idx);
}

//  Loads the searchable triangulation from disk.  First it
reads the
//  size, allocates the arrays then reads the d_array in and
the
//  conjugate_idx array in.
void run_time::load_triangulation(char *filename)
{
  FILE *the_file;
  if ((the_file = fopen(filename, "rb")) == NULL) {
    printf("cannot open file %s\n", filename);
    return;
  }

  fread(&d_array_size, 2, 1, the_file);
  d_array = new(vector[d_array_size]);
  conjugate_idx = new(int[d_array_size]);
  fread(d_array, sizeof(vector), d_array_size, the_file);
  fread(conjugate_idx, sizeof(int), d_array_size, the_file);

  fclose(the_file);

  if (use_bgi) {
    for (int i=0; i<d_array_size; i++) {
      setcolor(RED);
      line(d_array[i][0][0], d_array[i][0][1],
          d_array[i][1][0], d_array[i][1][1]);
    }
  }
}

//  This procedure returns the index for the edge after the
given
//  edge in d_array.  If there no following edge for the given
//  edge then the index for the first edge sharing the same
end
//  point is found and returned.
int run_time::postfix(int d_idx)
{
  pt tmp = d_array[d_idx][0];

  if (d_idx + 1 < d_array_size)
    if (d_array[d_idx+1][0] == tmp) return d_idx+1;

  for (int j=d_idx-1; j>=0 && d_array[j][0] == tmp; j--);
  
  return j+1;
}

//  This code takes the present vertex and segment and
finds which
//  "wedge" the helicopter is in, then goes to the new vertex
which is
//  the other endpoint of the new segment.
triangle run_time::find_triangle(void)
{
  //  Return the zero triangle if one isn't found.
  triangle result;
  result.x[0] = pt(0,0,0);
  result.x[1] = pt(0,0,0);
  result.x[2] = pt(0,0,0);

  int idx0 = conjugate_idx[idx1];
  int first_idx = idx0;
  int next_idx;

  while (1) {
    //  Find the next segment to check out.
    next_idx = postfix(idx0);
    //  If it's gone all the way around the vertex then
something
    //  is wrong, avoid an infinit loop.
    if (next_idx == first_idx) break;
    //  Check for boundary segments.
    if (angle(d_array[idx0], d_array[next_idx]) > PI) {
      idx0 = next_idx;
      continue;
    }
    // easier reading:
    double x0 = d_array[idx0][0][0];
    double y0 = d_array[idx0][0][1];
    double x1 = d_array[idx0][1][0];
    double y1 = d_array[idx0][1][1];
    double x2 = d_array[next_idx][1][0];
    double y2 = d_array[next_idx][1][1];
    double xh = helo[0];
    double yh = helo[1];
    //  calculate a and b.
    double denominator = (x1-x0)*(y2-y0) - (x2-x0)*(y1-y0);
    if (denominator == 0.0) { //  move on to the next edge.
      idx0 = next_idx;
      continue;
    }

    double a= ((xh-x0)*(y2-y0) - (x2-x0)*(yh-y0)) /
denominator;
    double b= ((x1-x0)*(yh-y0) - (xh-x0)*(y1-y0)) /
denominator;

    //  The helicopter is in the wedge if a and b are positive.
    if (a >= 0.0 && b >= 0.0) break;
    idx0 = next_idx;
  } //  end loop;

  //  Find the other endpoint for next iteration.
  idx1 = conjugate_idx[idx0];
  idx0 = next_idx;

  //  Is it closed in on a triangle?
  if (idx0 == idx3) {
    result.x[0] = d_array[idx0][0];
    result.x[1] = d_array[idx1][0];
    result.x[2] = d_array[idx2][0];
  }

  if (use_bgi) {
    setcolor(color+8);
    ++color %= 8;
        line(d_array[idx0][0][0], d_array[idx0][0][1],
            d_array[idx0][1][0], d_array[idx0][1][1]);
  }

  //  shift the indicies for next time.
  idx3 = idx2;
  idx2 = idx1;
  idx1 = idx0;

  return result;
}

//  This give the position of the helicopter to the search
routine
//  (run_time class) so that the triangle that contains it can
be
//  found.
void run_time::give_position(pt &p)
{
  helo = p;
  if (use_bgi) {
    putpixel(helo[0], helo[1], GREEN);
  }
}

//  This procedure finds the triangle the helipter is in.  Then
given the
//  three vertices of the triangle and the position of the
helicopter,
//  it finds the height of terrain under the helicopter.
double run_time::do_it(void)
{
  pt zero_pt;
  //  find the triangle.
  triangle tri = find_triangle();

  //  Did 'find_triangle' return the zero triangle?
  if (tri.x[0] == zero_pt &&
      tri.x[1] == zero_pt) {  //  triangle hasn't been found.
    return 0.0;
  }

  //  Compute the plane a*x + b*y + c*z = d.
  double a = (tri.x[0][1]-tri.x[1][1]) * (tri.x[0][2]-tri.x[2][2]) -
    (tri.x[0][1]-tri.x[2][1]) * (tri.x[0][2]-tri.x[1][2]);

  double b = (tri.x[0][2]-tri.x[1][2]) * (tri.x[0][0]-tri.x[2][0]) -
    (tri.x[0][0]-tri.x[1][0]) * (tri.x[0][2]-tri.x[2][2]);

  double c = (tri.x[0][0]-tri.x[1][0]) * (tri.x[0][1]-tri.x[2][1]) -
    (tri.x[0][0]-tri.x[2][0]) * (tri.x[0][1]-tri.x[1][1]);

  double d = a * (tri.x[0][0]-helo[0]) + b * (tri.x[0][1]-helo[1]) +
    c * tri.x[0][2];

  if (c == 0.0) {
    //  error veritcal triangle.
    height = 0.0;
  } else {
    height = d / c;
  }

  if (use_bgi) {
    gotoxy(54,18);
    printf("height");
    gotoxy(54,19);
    printf("the vertices, at the pt");
    gotoxy(54,20);
    printf("                         ");
    gotoxy(54,20);
    printf("%i %i %i,  %f",
      (int)tri.x[0][2], (int)tri.x[1][2], (int)tri.x[2][2], height);
  }

  return height;
}

