#include <algorithm>
#include "tls.h"

DWORD TlsBase::flist_slot = MAXDWORD;

TlsBase::TlsBase() {
	if ( flist_slot == MAXDWORD ) {
		flist_slot = TlsAlloc();
		if ( flist_slot == MAXDWORD ) throw GetLastError();
	}
}

void TlsBase::SetFreeList(FreeListVector *flist) {
	if ( !TlsSetValue(flist_slot,flist) ) {
		DWORD ecode = GetLastError();
		if ( flist ) delete flist;
		throw ecode;
	}
}

TlsBase::FreeListVector *TlsBase::GetFreeList() {
	FreeListVector *flist =
		reinterpret_cast<FreeListVector*>(TlsGetValue(flist_slot));
	DWORD ecode = GetLastError();
	if ( ecode ) throw ecode;
	return flist;
}

void TlsBase::AddToFreeList() {
	FreeListVector *flist = GetFreeList();
	if ( flist == NULL ) {
		DWORD ecode = GetLastError();
		flist = new FreeListVector;
		SetFreeList(flist);
		SetLastError(ecode);
	}
	flist->push_back(this);
}

bool TlsBase::DeleteFromFreeList() {
	bool was_deleted = false;
	FreeListVector::iterator it;
	FreeListVector *flist = GetFreeList();
	if ( flist ) {
		int flist_size = flist->size();
		if ( flist_size )
			it = find(flist->begin(),flist->end(),this);
		else
			it = flist->end();
		if ( it != flist->end() ) {
			flist->erase(it);
			if ( flist_size == 1 ) {
				delete flist;
				SetFreeList(NULL);
			}
			was_deleted = true;
		}
	}
	return was_deleted;
}

void TlsBase::Cleanup() {
	FreeListVector::iterator it;
	FreeListVector *flist = GetFreeList();
	if ( flist ) {
		for ( it = flist->begin(); it != flist->end(); ++it ) (*it)->Free();
		delete flist;
	}
}
