#include <iostream>
#include <strstream>
#include "tls.h"

using namespace std;

// add this declaration to your .cpp file of your Thread Class and have
// thread names passed to the Thread Class constructor

ThreadLocalStoragePtr<char> thread_name("main()");

char *SomeLibFnc();
void LaunchThread(void (*routine)());
void thr1();
void thr2();

// NOTE: The constructors for the global variables thread_name and libuf
// are executed before the main() routine is executed.

int main() {
  LaunchThread(thr1);
  LaunchThread(thr2);
  cout << SomeLibFnc() << endl << flush;
  Sleep(2000);
  cout << SomeLibFnc() << endl << flush;	// verify one buf per thread
  // TlsCleanup() not needed here. See NOTE below.
  return 0;
}

// NOTE: The destructors for thread_name and libuf are executed after main()
// and they automatically free any TLS allocated by main() via the
// ThreadLocalStoragePtr class.

void thr1() {
  thread_name = "thr1()";			// add this to your Thread Class
  Sleep(1000);
  cout << SomeLibFnc() << endl << flush;
  TlsCleanup();					// add this to your Thread Class
  ExitThread(0);
}

void thr2() {
  thread_name = "thr2()";			// add this to your Thread Class
  Sleep(1500);
  cout << SomeLibFnc() << endl << flush;
  TlsCleanup();					// add this to your Thread Class
  ExitThread(0);
}

struct LibFncBuffer {
  enum { SIZE=80 };
  char buf[SIZE];
  int Size() { return SIZE; };
};

// SomeLibFnc demonstrates the use of TLS in a thread-safe version of
// the old "function returns a static pointer" trick.

ThreadLocalStoragePtr<LibFncBuffer> libuf;	// TLS buffer for SomeLibFnc

char *SomeLibFnc() {
  LibFncBuffer *mybuf = libuf;			// get a TLS buffer
  strstream strbuf(mybuf->buf,mybuf->Size());	// make a streambuf with it
  strbuf << "Thread " << (char *)thread_name	// format text in it
	 << " using buffer @ " << (void *)mybuf->buf << ends;
  return mybuf->buf;				// return it's pointer
}

inline void LaunchThread(void (*routine)()) {
  DWORD tid;
  CreateThread(NULL,4096,(LPTHREAD_START_ROUTINE)routine,NULL,0,&tid );
}

//output:

Thread main() using buffer @ 004712D0
Thread thr1() using buffer @ 00471510
Thread thr2() using buffer @ 00471600
Thread main() using buffer @ 004712D0


