/* ------------------------------------------------------- */ 
/* scans the bb.out file and prints the zero count blocks  */ 
/*                                                         */ 
/* First I create an index ix from file name and line      */
/* number; Then I create the following arrays:             */             
/*            frequ[ix] = counter                          */
/*            funzi[ix] = function name                    */ 
/*            linea[ix] = line number                      */ 
/*            nomef[ix] = file name                        */ 
/* ------------------------------------------------------- */ 
     
/^[\n \t]+Block / {
  if ( NF == 13 ) {
    v_frequ = $4;
    v_funzi = $9;
    v_linea = $11;
    v_nomef = $13;
     }
              else {
    v_frequ = $5;
    v_funzi = $10;
    v_linea = $12;
    v_nomef = $14;
     }
     
    indice = sprintf( "%-16.16s[%05d]", v_nomef, v_linea );
     
    /* record data */
    funzi[ indice ]  = v_funzi;
    linea[ indice ]  = v_linea;
    nomef[ indice ]  = v_nomef;
    frequ[ indice ] += v_frequ;
     
                  }
     
END {
  /* counts how many blocks are there and how many   */ 
  /* have count 0 in order to print out a percentage */ 
  /* measure                                         */
     
       nzerob  = 0; /* number of blocks never executed */ 
       nblocks = 0; /* total number of blocks          */ 
       nexecb  = 0; /* number of blocks executed       */ 
       for (x in frequ)
  {
    nblocks++;
           if (frequ[x] == 0) 
      {
        nzerob++;
         /* prints out the name of the block */
        printf("%-14.14s line = %05d f= %-16.16s\n", nomef[x], linea[x],
funzi[x] );
      }
      else
        nexecb++;
  }
     
  /* now prints the results */
       perc = nexecb / nblocks * 100.0;
       printf( "%05d blocks out of %05d executed; %3.0f%% coverage\n", 
                nexecb, nblocks, perc );
     
}
     
     
