P /*----------------------------------------------------------------------------*/E /* V01-001	Phil Ottewell,	phil@pottsoft.demon.co.uk	13-Aug-1997   */ = /*			http://www.pottsoft.demon.co.uk/pds/pds.html          */ P /*----------------------------------------------------------------------------*/P /*                                                                            */P /* WHOIS client for VMS and Windows NT                                        */P /*                                                                            */P /* Usage: whois [ -h nic_server ] name_to_find [ > output_file ]              */P /*                                                                            */P /*----------------------------------------------------------------------------*/   /* ANSI C Headers */ #include <stdlib.h>  #include <stdio.h> #include <string.h>    /* Sockets Headers */ 
 #ifdef _WIN32  # include <winsock2.h> #else  # include <in.h> # include <netdb.h>  # include <socket.h> # include <inet.h> # include <unixio.h> # define closesocket close #endif  
 # ifdef __VMS N /* Map "how" codes for shutdown() on VMS so we can use same constants as NT */A /* The SHUT_xxx constants are #define-d in sockets.h under VMS */ I #  define SD_RECEIVE SHUT_RD    /* Disables further receive operations */ F #  define SD_SEND    SHUT_WR    /* Disables further send operations */L #  define SD_BOTH    SHUT_RDWR  /* Disables further send and receive ops. */ # endif /* # ifdef __VMS */    /* Function Prototypes */  int initialize_sockets( void ); > int match_right( const char *string, const char *right_part ); int shutdown_sockets( void ); $ int whois( int argc, char *argv[] );  P /*--- Main program starts here -----------------------------------------------*/" int main( int argc, char *argv[] ) {      int retval;  /*  End of declarations ... */  N /*  VMS DCL doesn't use > for redirecting output so fake it by pre-checking */M /*  command line for > . This is cleaner than redirecting SYS$OUTPUT - PJO */ 1     if ( argc > 2 && !strcmp(argv[argc-2],">")) { 2       if ( freopen( argv[argc-1], "w", stdout) ) {>         fprintf(stderr,"Sending output to %s\n",argv[argc-1]);       } D /*    Remove the "> file" from end so it's not parsed by next bit */       argc -= 2;     }   !     retval = whois( argc, argv );        return( retval );  } # int whois( int argc, char *argv[] )  { M     const short int whois_port = 43; /* Standard WHOIS service port number */      int socket_fd;     int retval;      int msgbytes;      char *nic_server = NULL;     char *node_to_find;      struct sockaddr_in sin;      struct hostent *host_ptr;      char msgbuf[2048]; /*  End of declarations ... */  ! /*  Initialize sockets library */ "     retval = initialize_sockets();  7     if ( argc == 4  &&   strcmp( argv[1], "-h") == 0) {        nic_server = argv[2];        node_to_find = argv[3];      } else if ( argc == 2 ) {        node_to_find = argv[1];      } else {E       fprintf(stderr, "Usage: whois [ -h nic_server ] name_to_find");  #ifdef __VMS,       fprintf(stderr, " [ > output_file ]"); #endif /* # ifdef __VMS */       fprintf(stderr, "\n\n");e       fprintf(stderr, "For a list of whois servers try: whois -h whois.indiana.edu whois-servers\n");        exit( EXIT_SUCCESS );      }   % /*  Node or domain we want to find */   I /*  If server used to find it not explicitly specified on command line */ ) /*  then try and choose a sensible one */      if ( !nic_server ) {1       if ( match_right( node_to_find, ".uk" ) ) {  /*      UK names */ "         nic_server = "ns0.nic.uk";       } else {4         if ( match_right( node_to_find, ".mil" ) ) { /*        US military names */%           nic_server = "nic.ddn.mil";          } else {$ /*        Default fallback server */)           nic_server = "rs.internic.net"; 	         }        }      }   ; /*  Get pointer to network data struct for remote server */ )     host_ptr = gethostbyname(nic_server);      if ( !host_ptr ) {E       fprintf(stderr, "whois: %s: nic server unknown\n", nic_server);        exit( EXIT_FAILURE );      }   "     nic_server = host_ptr->h_name;   /*  Open socket */A     if ( (socket_fd = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP))           < 0) { 0       perror( "whois: unable to create socket");       exit( EXIT_FAILURE );      }   D /*  Fill in the name & address structure for remote server socket */*     sin.sin_family = host_ptr->h_addrtype;%     sin.sin_port = htons(whois_port); A     memcpy( &sin.sin_addr, host_ptr->h_addr, host_ptr->h_length);    /*  Connect to whois server */K     if ( connect( socket_fd, (struct sockaddr *)&sin, sizeof(sin) )  < 0) { 9       perror("whois: unable to connect to WHOIS server");        exit( EXIT_FAILURE );      }   <     printf("Using WHOIS server %s, port %d, to find %s\n\n",/            nic_server,whois_port,node_to_find); -     sprintf( msgbuf, "%s\r\n", node_to_find); 2     send( socket_fd,  msgbuf, strlen(msgbuf), 0 );O     while ( (msgbytes = recv( socket_fd, msgbuf, sizeof(msgbuf)-1, 0))  > 0 ) { /       printf("%*.*s",msgbytes,msgbytes,msgbuf);      }      printf("\n");   L /*  Shut down socket gracefully (other end should have done this already) */.     if ( shutdown( socket_fd, SD_SEND ) == -1)(       perror ("whois: shutdown failed");   /*  Close socket */ #     if ( closesocket( socket_fd ) ) ,       perror ("whois: socket close failed");   /*  Shutdown sockets library */       retval = shutdown_sockets();       return( EXIT_SUCCESS );  }   P /*--- Function returns 1 if right_part is at end of string, 0 otherwise ------*/= int match_right( const char *string, const char *right_part )  {      int retval;      char *suffix_pos;      size_t prefix_len;     size_t string_len; /*  End of declarations ... */       retval = 0; !     if ( string && right_part ) { $       string_len = strlen( string );0       suffix_pos = strstr( string, right_part );       if ( suffix_pos ) { )         prefix_len = suffix_pos - string; >         if ( prefix_len + strlen(right_part) == string_len ) {           retval = 1; 	         }        }      }      return( retval );  }   P /*---- The socket initialization/shutdown functions return 0 if successful ---*/ int initialize_sockets( void ) {      int status; 
 #ifdef _WIN32      WORD wVersionRequested;      WSADATA wsaData;   )     wVersionRequested = MAKEWORD( 2, 0 );    7     status = WSAStartup( wVersionRequested, &wsaData );      if ( status != 0 ) {:         /* Tell the user that we couldn't find a usable */;         /* WinSock DLL.                                  */      }    3     /* Confirm that the WinSock DLL supports 2.0.*/ ;     /* Note that if the DLL supports versions greater    */ ;     /* than 2.0 in addition to 2.0, it will still return */ ;     /* 2.0 in wVersion since that is the version we      */ ;     /* requested.                                        */    +     if ( LOBYTE( wsaData.wVersion ) != 2 || ,          HIBYTE( wsaData.wVersion ) != 0 ) {:         /* Tell the user that we couldn't find a usable */;         /* WinSock DLL.                                  */          WSACleanup( );     }    - /* The WinSock DLL is acceptable. Proceed. */  #endif /* #ifdef _WIN32 */   #ifdef __VMS  //  Don't need to do this in VMS     status = 0;  #endif       return( status );  }    int shutdown_sockets( void ) {      int status;   
 #ifdef _WIN32      status = WSACleanup(); #endif /* #ifdef _WIN32 */   #ifdef __VMS  //  Don't need to do this in VMS     status = 0;  #endif /* #ifdef __VMS */        return( status );  } 