#include "windows.h"
#include "winioctl.h"
#include "stdio.h"
#include "stdlib.h"
/* #include "ioaccess.h" */

typedef LARGE_INTEGER PHYSICAL_ADDRESS;

#include "skeleton_nt.h"


/*
 *----------------------------------------------------------------------
 * main --
 *
 *	Tries to open the Skeleton driver and send it some IOCTLs
 *
 * Results:
 *	None
 *----------------------------------------------------------------------
 */
void __cdecl
main(int argc, char **argv)
{
    HANDLE	hDriver;
    PVOID	pMem;
    DWORD	cbReturned;
    BOOL	ret;
    int		status;

    /*
     * Try to open the device
     */

    hDriver = CreateFile("\\\\.\\SKELETON0", GENERIC_READ | GENERIC_WRITE,
			 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    if (hDriver == INVALID_HANDLE_VALUE) {
        printf ("Can't get a handle to SKELETON0 driver\n");
	exit(1);
    }

    /*
     * Try to map the skeleton memory
     */
    ret = DeviceIoControl(hDriver,
			  (DWORD) IOCTL_SKELETON_MAP_USER_PHYSICAL_MEMORY,
			  NULL, 0,                   /* In buffer */
			  &pMem, sizeof(PVOID), /* Out buffer */
			  &cbReturned,
			  0);
    if (! ret) {
        /*
         * We failed to map, possibly due to resource conflicts (i.e
         * some other driver/device already grabbed the section we
         * wanted).
         */

        printf("DeviceIoControl failed to map the memory\n");
	status = 1;
	goto done;
    }

    if (! pMem) {
	printf ("pMem = NULL\n");
	status = 1;
	goto done;
    }

    /*
     * Unmap the skeleton memory
     */
    DeviceIoControl(hDriver,
		    (DWORD) IOCTL_SKELETON_UNMAP_USER_PHYSICAL_MEMORY,
		    &pMem, sizeof(PVOID),
		    NULL, 0, &cbReturned, 0);

  done:
    CloseHandle(hDriver);
    exit(status);
}
