/*
 * This is the structure for Skeleton device info
 */
typedef struct {
    PVOID FrameBase;		/* Frame buffer address in system memory */
    ULONG FrameMemType;		/* Address space: 0x0 = mem, 0x1 = I/O */

    PKINTERRUPT KIntrObj;	/* Interrrupt object from IoConnectInterrupt */
    ULONG KIntrVector;		/* Mapped system interrupt vector */
    KIRQL KIrql;
    KAFFINITY KIntrAffinity;	/* The processor set this interrupt affects */
    FAST_MUTEX IrpMutex;	/* Ensure 1 dispatch entry at a time */
    KSPIN_LOCK DeviceSpinLock;	/*  */

    ULONG BusId;
    ULONG SlotId;
    PHYSICAL_ADDRESS MemStart;
    ULONG MemLength;
    ULONG IntrLevel;
    ULONG IntrVector;
    ULONG IntrAffinity;

    /* StartIo subroutine fields.  Used by QueryVideo() */
    KDPC StartIoDpc;		/* Used by the query video routine */
    KTIMER StartIoTimer;	/* Timer used in StartIo subroutine */
    ULONG StartIoState;		/* Current state of StartIo subroutine */
    PVOID StartIoBuffer;	/* Current buffer we are using */

    /* Some DMA related fields */
    PADAPTER_OBJECT AdaptorObj;	/* Pointer to DMA adaptor object */
    ULONG DmaMapRegisters;	/* Number of DMA map registers */
    PVOID MapRegisterBase;	/* DMA map register base */
    PVOID VirtualAddress;	/* Virtual address of MDL for DMA transfer */
    KTIMER DeviceCheckTimer;	/* Timer to check that DMA hasn't failed */
    BOOLEAN TimerStarted;	/* Has the timer been started */
    KDPC TimerDpc;		/* The DPC to run on timer trigger */
    BOOLEAN TransferDone;	/* When the timeout occurs, find out if
				 * the tranfer was already done */
    PVOID IrpSystemBuffer;	/* System buffer for the current IRP */
    ULONG IrpBufLen;		/* Buffer length for the current IRP */
    NTSTATUS IrpStatus;		/* The status of the transfer */
    ULONG IrpBytesTransferred;	/* Number of bytes that were transfered */

    CCHAR OperationType;        /* current command (ie IRP_MJ_READ) */
    ULONG TotalTransferLength;	/* length of current transfer */
    BOOLEAN RequestDpc;		/* Set this if the routine wishes to  */
    BOOLEAN DpcRequested;
    ULONG RestoreChannel;	/* Channel was in use and needs restoring */

    ULONG syncParam1;		/* Parameters for the synch routine */
    ULONG syncParam2;
    ULONG syncParam3;
    union {			/* Return value if needed */
	ULONG ULong;
	int Int;
	long Long;
    } syncResult;

} SKELETON_DEVICE, *PSKELETON_DEVICE;

#define offsetof(type, field) ((ULONG) ((char *) &((type *) 0)->field))

#ifdef LITTLE_ENDIAN
#  define LITTLE_ENDIAN_16(x) (x)
#  define LITTLE_ENDIAN_32(x) (x)

static __inline unsigned short BIG_ENDIAN_16(unsigned short x)
{
    return (((x & 0x00FF) << 8) + ((x & 0xFF00) >> 8));
}
static __inline unsigned int BIG_ENDIAN_32(unsigned int x)
{
    return (((x & 0x000000FF) << 24) + ((x & 0x0000FF00) << 8) +
	    ((x & 0x00FF0000) >> 8) + ((x & 0xFF000000) >> 24));
}
#else
#  define BIG_ENDIAN_16(x) (x)
#  define BIG_ENDIAN_32(x) (x)
static __inline unsigned short LITTLE_ENDIAN_16(unsigned short n)
{
   return (((n & 0x00FF) << 8) + ((n & 0xFF00) >> 8));
}

static __inline unsigned int LITTLE_ENDIAN_32(unsigned int n)
{
    return (((n & 0x000000FF) << 24) + ((n & 0x0000FF00) << 8) +
	    ((n & 0x00FF0000) >> 8) + ((n & 0xFF000000) >> 24));
}
#endif

