/*
 *----------------------------------------------------------------------
 * Module Name:
 *	skeleton_nt.h
 *
 * Abstract:
 *	Include file for user and kernel space.
 *
 * Environment:
 *	Kernel and user modes
 *
 * Revision History:
 *
 *----------------------------------------------------------------------
 */

/*
 * Define the various device type values.  Note that values used by Microsoft
 * Corporation are in the range 0-32767, and 32768-65535 are reserved for use
 * by customers.
 */

#define FILE_DEVICE_SKELETON  0x0000CBFC


/*
 * Macro definition for defining IOCTL and FSCTL function control codes.  Note
 * that function codes 0-2047 are reserved for Microsoft Corporation, and
 * 2048-4095 are reserved for customers.
 */

#define SKELETON_IOCTL_BASE  0x800

/*
 * Define the Skeleton IOCTLs.  There are two forms for these defines:
 * the NT ioctl name and the Skeleton ioctl name.  The Skeleton ioctl
 * names come from pvioctl.h
 */

#define IOCTL_SKELETON_NNN(offset, method, access) \
    (ULONG) CTL_CODE(FILE_DEVICE_SKELETON, SKELETON_IOCTL_BASE + (offset), \
		     (method), (access))

#define IOCTL_SKELETON_MAP_USER_PHYSICAL_MEMORY \
    IOCTL_SKELETON_NNN(0, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_SKELETON_UNMAP_USER_PHYSICAL_MEMORY \
    IOCTL_SKELETON_NNN(1, METHOD_BUFFERED, FILE_ANY_ACCESS)
