// wdjsrvc.c

#include <windows.h>
#include <stdio.h>
#include "wdjsrvc.h"

// private prototypes
BOOL NotifySCM(DWORD, DWORD, DWORD);
VOID WINAPI ServiceMain(DWORD, LPTSTR *);
VOID WINAPI ServiceHandler(DWORD);
DWORD WINAPI MainServiceThread(LPDWORD);
BOOL CALLBACK ServiceDlgProc(HWND, UINT, WPARAM, LPARAM);

HANDLE  hDoneEvent = NULL, hThread = NULL;
DWORD   dwCurrentState;
SERVICE_STATUS_HANDLE  hService;

//--------------------------------------------------------------
void main(void)
{
   SERVICE_TABLE_ENTRY ServiceTable[] = {
      {TEXT("WDJSrvc"), (LPSERVICE_MAIN_FUNCTION)ServiceMain},
      {NULL, NULL}
   };

   // connect to  the service control manager
   StartServiceCtrlDispatcher(ServiceTable);
}

//--------------------------------------------------------------
#ifdef __BORLANDC__
#   pragma argsused
#endif
VOID WINAPI ServiceMain(DWORD dwArgc, LPTSTR *lpszArgv)
{
   DWORD   ThreadId;

   if (0 == (hService = RegisterServiceCtrlHandler(TEXT("WDJSrvc"),
         (LPHANDLER_FUNCTION)ServiceHandler))) {
       return;
   }

   NotifySCM(SERVICE_START_PENDING, 0, 1);

   if (0 == (hDoneEvent = CreateEvent(NULL, FALSE, FALSE, NULL))) {
       return;
   }

   NotifySCM(SERVICE_START_PENDING, 0, 2);

   if (0 == (hThread = CreateThread(0, 0,
         (LPTHREAD_START_ROUTINE)MainServiceThread, 0, 0,
         &ThreadId))) {
      CloseHandle(hDoneEvent);
      return;
   }

   NotifySCM(SERVICE_RUNNING, 0, 0);

   WaitForSingleObject(hDoneEvent, INFINITE);

   CloseHandle(hThread);
   CloseHandle(hDoneEvent);
   return;
}

//--------------------------------------------------------------
VOID WINAPI ServiceHandler(DWORD fdwControl)
{
   switch(fdwControl) {

      case SERVICE_CONTROL_STOP:
         NotifySCM(SERVICE_STOP_PENDING, 0, 1);
         SetEvent(hDoneEvent);
         NotifySCM(SERVICE_STOPPED, 0, 0);
         break;

      case SERVICE_CONTROL_INTERROGATE:
         NotifySCM(dwCurrentState, 0, 0);
         break;

      case SERVICE_CONTROL_SHUTDOWN:
         break;
   }
}

//-------------------------------------------------------------------
BOOL NotifySCM(DWORD dwState, DWORD dwWin32ExitCode, DWORD dwProgress)
{
   SERVICE_STATUS ServiceStatus;

   ServiceStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
   ServiceStatus.dwCurrentState = dwCurrentState = dwState;
   ServiceStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP |
      SERVICE_ACCEPT_SHUTDOWN;
   ServiceStatus.dwWin32ExitCode = dwWin32ExitCode;
   ServiceStatus.dwServiceSpecificExitCode = 0;
   ServiceStatus.dwCheckPoint = dwProgress;
   ServiceStatus.dwWaitHint = 5000;

   return SetServiceStatus(hService, &ServiceStatus);
}

//-------------------------------------------------------------------
#ifdef __BORLANDC__
#   pragma argsused
#endif
DWORD WINAPI MainServiceThread(LPDWORD ThreadParam)
{
   OutputDebugString("--> WDJSRVC: In MainServiceThread\n");

   DialogBox(GetModuleHandle(NULL),
         MAKEINTRESOURCE(SERVICE_DIALOG), NULL, ServiceDlgProc);

   OutputDebugString("--> WDJSRVC: DialogBox closed\n");

   while (TRUE) {
      //
      // this is where the service would actually do something
      //
      Sleep(10000);
   }
   return TRUE;
}

//-------------------------------------------------------------------
#ifdef __BORLANDC__
#   pragma argsused
#endif
BOOL CALLBACK ServiceDlgProc(HWND hDlg, UINT msg,
   WPARAM wParam, LPARAM lParam)
{
   switch (msg) {
      case WM_COMMAND:
         switch(LOWORD(wParam)) {
             case IDOK:
               EndDialog(hDlg, TRUE);
               return TRUE;
      }
      break;
   }
   return FALSE;
}


