
// __________________________________________________________
//
//                        ComSpyUI.c
//      Serial Communication Spy User Interface V1.00
//                11-16-1996 Sven B. Schreiber
//                 100557.177@compuserve.com
// __________________________________________________________

#include <windows.h>
#include <cuistart.h>

// =================================================================
// MACROS
// =================================================================

#define CTL_CODE(DeviceType, Function, Method, Access) \
        (((DeviceType) << 16) | \
         ((Access)     << 14) | \
         ((Function)    << 2) | \
         ((Method)          ))

// =================================================================
// CONSTANTS
// =================================================================

#define IO_BUFFER_SIZE 0x0100

#define FILE_DEVICE_COMSPY_CONTROL 0x8000

#define FILE_ANY_ACCESS   0
#define FILE_READ_ACCESS  1
#define FILE_WRITE_ACCESS 2

#define METHOD_BUFFERED   0
#define METHOD_IN_DIRECT  1
#define METHOD_OUT_DIRECT 2
#define METHOD_NEITHER    3

#define IOCTL_INFO  CTL_CODE (FILE_DEVICE_COMSPY_CONTROL, \
                              0x0800, \
                              METHOD_BUFFERED, \
                              FILE_READ_ACCESS)

#define IOCTL_RESET CTL_CODE (FILE_DEVICE_COMSPY_CONTROL, \
                              0x0801, \
                              METHOD_BUFFERED, \
                              FILE_WRITE_ACCESS)

#define IOCTL_READ  CTL_CODE (FILE_DEVICE_COMSPY_CONTROL, \
                              0x0802, \
                              METHOD_BUFFERED, \
                              FILE_READ_ACCESS)

#define IOCTL_WRITE CTL_CODE (FILE_DEVICE_COMSPY_CONTROL, \
                              0x0803, \
                              METHOD_BUFFERED, \
                              FILE_WRITE_ACCESS)

// =================================================================
// DATA TYPES
// =================================================================

typedef struct _FILTER_INFO
    {
    DWORD dMajorVersion;
    DWORD dMinorVersion;
    DWORD dYear;
    DWORD dMonth;
    DWORD dDay;
    char  sDescription [50];
    char  sAuthor      [50];
    char  sEmail       [50];
    }
    FILTER_INFO, *PFILTER_INFO;

// =================================================================
// GLOBAL VARIABLES
// =================================================================

char sDeviceName [] = "\\\\.\\ComSpy";

// =================================================================
// AUXILIARY ROUTINES
// =================================================================

BOOL ReadDeviceInfo (HANDLE       hDevice,
                     PFILTER_INFO pFilterInfo)
    {
    DWORD dBytesReturned;

    return DeviceIoControl (hDevice,
                            (DWORD) IOCTL_INFO,
                            NULL,
                            0,
                            pFilterInfo,
                            sizeof (FILTER_INFO),
                            &dBytesReturned,
                            NULL);
    }

// -----------------------------------------------------------------

BOOL ResetDevice (HANDLE hDevice)
    {
    DWORD dBytesReturned;

    return DeviceIoControl (hDevice,
                            (DWORD) IOCTL_RESET,
                            NULL,
                            0,
                            NULL,
                            0,
                            &dBytesReturned,
                            NULL);
    }

// -----------------------------------------------------------------

BOOL WriteToDevice (HANDLE hDevice,
                    PSTR   psData)
    {
    DWORD dBytesReturned;

    return DeviceIoControl (hDevice,
                            (DWORD) IOCTL_WRITE,
                            psData,
                            lstrlen (psData),
                            NULL,
                            0,
                            &dBytesReturned,
                            NULL);
    }

// -----------------------------------------------------------------

DWORD ReadFromDevice (HANDLE hDevice,
                      PSTR   psData,
                      DWORD  dSize)
    {
    DWORD dBytesReturned;

    dBytesReturned = 0;
    if (dSize)
        {
        if (!DeviceIoControl (hDevice,
                              (DWORD) IOCTL_READ,
                              NULL,
                              0,
                              psData,
                              dSize-1,
                              &dBytesReturned,
                              NULL))
            {
            dBytesReturned = 0;
            }
        psData [dBytesReturned] = 0;
        }
    return dBytesReturned;
    }

// =================================================================
// MAIN PROGRAM
// =================================================================

void main (int argc, char *argv [], char *envp [])
    {
    HANDLE      hDevice;
    FILTER_INFO FilterInfo;
    char        sData [IO_BUFFER_SIZE+1];
    WORD        wKeyCode;
    int         i;

    printf ("\n   Opening the spy device ... ");
    hDevice = CreateFile (sDeviceName,
                          GENERIC_READ | GENERIC_WRITE,
                          FILE_SHARE_READ | FILE_SHARE_WRITE,
                          NULL,
                          OPEN_EXISTING,
                          FILE_ATTRIBUTE_NORMAL,
                          NULL);

    if (hDevice != INVALID_HANDLE_VALUE)
        {
        printf ("OK\n");
        if (ReadDeviceInfo (hDevice, &FilterInfo))
            {
            printf ("\n// %s V%lu.%02lu"
                    "\n// %02lu-%02lu-%04lu %s"
                    "\n// %s\n",
                    FilterInfo.sDescription,
                    FilterInfo.dMajorVersion,
                    FilterInfo.dMinorVersion,
                    FilterInfo.dMonth,
                    FilterInfo.dDay,
                    FilterInfo.dYear,
                    FilterInfo.sAuthor,
                    FilterInfo.sEmail);
            }
        if (argc > 1)
            {
            WriteToDevice (hDevice, "\n");
            for (i = 1; i < argc; i++)
                {
                WriteToDevice (hDevice, argv [i]);
                WriteToDevice (hDevice, "\n");
                }
            }
        printf ("\nHit Esc to quit this program"
                "\nHit Enter to clear the protocol buffer"
                "\nHit any key to start ... ");
        while (!KeyPressed ());

        printf ("\n\n"
                "-- [BEGIN] -----------------------------"
                "---------------------------------------\n");
        
        while (TRUE)
            {
            wKeyCode = KeyPressed ();
            if (wKeyCode == VK_ESCAPE) break;
            if (wKeyCode == VK_RETURN) ResetDevice (hDevice);

            if (ReadFromDevice (hDevice, sData, IO_BUFFER_SIZE))
                {
                printf ("%s", sData);
                }
            }
        printf ("\n"
                "-- [END] -------------------------------"
                "---------------------------------------\n");
        
        printf ("\n   Closing the spy device ... ");
        if (CloseHandle (hDevice))
            {
            printf ("OK");
            }
        else
            {
            printf ("ERROR 0x%08X", GetLastError ());
            }
        }
    else
        {
        printf ("ERROR 0x%08X", GetLastError ());
        }
    printf ("\n");
    return;
    }

// =================================================================
// END OF PROGRAM
// =================================================================
