/*
 * $Header: /usr/local/src/getethers/RCS/defs.h,v 1.6 1994/08/26 19:58:02 davy Exp $
 *
 * Definitions for getethers.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * davy@ecn.purdue.edu
 * November, 1991
 *
 * $Log: defs.h,v $
 * Revision 1.6  1994/08/26  19:58:02  davy
 * Applied Solaris patches from Steven Bellenot (sfb@entropy.math.fsu.edu).
 *
 * Revision 1.5  1992/05/08  14:18:38  davy
 * Fix from David Ferbrache (ferbrache@ajaz.rsre.mod.uk) for passing over
 * non-Ethernet links.
 *
 * Revision 1.4  92/05/08  14:15:57  davy
 * Made portable to 4.3BSD, from Peter Shipley (shipley@tfs.com).
 * 
 * Revision 1.3  92/05/08  13:06:33  davy
 * Added vendor name printing from Peter Shipley (shipley@tfs.com).
 * 
 * Revision 1.2  92/05/08  10:54:43  davy
 * Added changes to dump Sniffer format files from Ric Anderson,
 * ric@cs.arizona.edu.
 * 
 * Revision 1.1  91/11/27  10:56:28  davy
 * Initial revision
 * 
 */
#define VERSION		1.6

#define MAXHOST		256		/* max number of hosts to check	*/
#define MINADDR		1		/* minimum host number		*/
#define MAXADDR		254		/* maximum host number		*/
#define MAXPING		3		/* max number of pings to send	*/
#define PACKWAIT	1		/* min time to wait for packet	*/
#define MAXPACKET	4096		/* max packet size for ping	*/
#define FILESIZE	2584		/* size of lanalyzer file	*/

/*
 * Analyzer file output types.
 */
#define EXCELAN		1
#define SNIFFER		2

/*
 * Record for a host.
 */
typedef struct {
	char	*hl_name;		/* host name			*/
	char	*hl_inet;		/* internet address		*/
	char	*hl_ether;		/* ethernet address		*/
	char	*hl_vname;		/* vendor name			*/
} HostInfo;

#ifdef NEED_ENTOA
struct ether_addr {
        u_char  ether_addr_octet[6];
};

char	*ether_ntoa();
#endif

#ifdef NEED_STRDUP
char	*strdup();
#endif

#ifdef SOLARIS
#define bcopy(src,dst,len)		memmove(dst,src,len)
#define bzero(dst,len)			memset(dst,0,len)
#define index				strchr
#endif
