#ifndef lint
static char *RCSid = "$Header: /usr/local/src/getethers/RCS/if.c,v 1.5 1994/08/26 19:58:02 davy Exp $";
#endif

/*
 * if.c - routines to check a system's ethernet interfaces.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * davy@ecn.purdue.edu
 * November, 1991
 *
 * $Log: if.c,v $
 * Revision 1.5  1994/08/26  19:58:02  davy
 * Applied Solaris patches from Steven Bellenot (sfb@entropy.math.fsu.edu).
 *
 * Revision 1.4  1992/05/08  14:19:29  davy
 * Fix from David Ferbrache (ferbrache@ajaz.rsre.mod.uk) for passing over
 * non-Ethernet links.
 *
 * Revision 1.3  92/05/08  14:15:58  davy
 * Made portable to 4.3BSD, from Peter Shipley (shipley@tfs.com).
 * 
 * Revision 1.2  92/05/08  13:06:36  davy
 * Added vendor name printing from Peter Shipley (shipley@tfs.com).
 * 
 * Revision 1.1  91/11/27  10:56:31  davy
 * Initial revision
 * 
 */
#if defined(sun) && !defined(SOLARIS)

#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/file.h>
#include <net/if.h>
#include <net/nit_if.h>
#include <netinet/if_ether.h>
#include <string.h>
#include <stdio.h>
#include "defs.h"

/*
 * check_if - check our ethernet interfaces and find the one that's attached
 *	      to the network in addr.
 */
check_if(addr, hosts)
struct in_addr addr;
HostInfo *hosts;
{
	int n, s, lna;
	char buf[BUFSIZ];
	struct ifreq ifr;
	struct ifconf ifc;
	char *vendor_name();
	struct sockaddr *sad;
	struct sockaddr_in *sin;
	register struct ifreq *ifrp;

	/*
	 * Need a socket...
	 */
	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		error("socket");
		return(-1);
	}

	ifc.ifc_buf = buf;
	ifc.ifc_len = sizeof(buf);

	/*
	 * Get the list of configured interfaces.
	 */
	if (ioctl(s, SIOCGIFCONF, (char *) &ifc) < 0) {
		error("ioctl: SIOCGIFCONF");
		close(s);

		return(-1);
	}

	close(s);

	/*
	 * For each interface...
	 */
	ifrp = ifc.ifc_req;
	for (n = ifc.ifc_len/sizeof(struct ifreq); n > 0; n--, ifrp++) {
		bcopy((char *) ifrp, (char *) &ifr, sizeof(struct ifreq));

		/*
		 * Need a new socket.
		 */
		if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
			error("socket");
			return(-1);
		}

		/*
		 * Get the address of this interface.
		 */
		if (ioctl(s, SIOCGIFADDR, (char *) &ifr) < 0) {
			error("ioctl: SIOCGIFADDR");
			close(s);
			
			continue;
		}

		close(s);

		sin = (struct sockaddr_in *) &ifr.ifr_addr;

		/*
		 * If it's not the one we need, bag it.
		 */
		if ((sin->sin_addr.s_addr & addr.s_addr) != addr.s_addr)
			continue;

		/*
		 * Save the internet address, and keep the host byte.
		 * We are assuming a netmask of 255.255.255.0 here.
		 */
		lna = inet_lnaof(sin->sin_addr) & 0xff;
		hosts[lna].hl_inet = strdup(inet_ntoa(sin->sin_addr));

		/*
		 * Now we need the NIT, to get the ethernet address.
		 */
		if ((s = open("/dev/nit", O_RDONLY)) < 0) {
			error("open: /dev/nit");
			return(-1);
		}

		/*
		 * Bind the nit to this interface.
		 */
		if (ioctl(s, NIOCBIND, (char *) ifrp) < 0) {
			error("ioctl: NIOCBIND");
			close(s);

			return(-1);
		}

		/*
		 * Get the address.
		 */
		if (ioctl(s, SIOCGIFADDR, (char *) ifrp) < 0) {
			error("ioctl: SIOCGIFADDR");
			close(s);

			continue;
		}

		close(s);

		/*
		 * Save the ethernet address.
		 */
		sad = (struct sockaddr *) &ifrp->ifr_addr;
		hosts[lna].hl_ether = strdup(ether_ntoa((struct ether_addr *)
							sad->sa_data));
		hosts[lna].hl_vname = vendor_name((struct ether_addr *)
						  sad->sa_data);

		return(lna);
	}

	return(-1);
}

#else

#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include "defs.h"

check_if(addr, hosts)
struct in_addr addr;
HostInfo *hosts;
{
	int lna;
	char hn[256];
	struct hostent *hp;
	extern char *strdup();

	(void) gethostname(hn, sizeof(hn));

	hp = gethostbyname(hn);

	lna = inet_lnaof(hp->h_addr) & 0xff;
	hosts[lna].hl_inet = strdup(inet_ntoa(hp->h_addr));
	hosts[lna].hl_name = strdup(hp->h_name);
	hosts[lna].hl_ether = "???";
	hosts[lna].hl_vname = "???";
	return(0);
}

#endif
