#ifndef lint
static char *RCSid = "$Header: /usr/src/ecn/getethers/RCS/vendors.c,v 1.3 1993/03/08 18:07:24 davy Exp $";
#endif
/*
 * vendors.c - print ethernet vendor codes
 *
 * Peter Shipley
 * shipley@tfs.com
 *
 * More vendors added, code rearranged by D. Curry.
 *
 * $Log: vendors.c,v $
 * Revision 1.3  1993/03/08  18:07:24  davy
 * Updated list of vendors.
 *
 * Revision 1.2  1992/05/08  14:16:03  davy
 * Made portable to 4.3BSD, from Peter Shipley (shipley@tfs.com).
 *
 * Revision 1.1  92/05/08  13:06:39  davy
 * Initial revision
 * 
 */
#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#ifdef sun
#include <net/if_arp.h>
#endif
#include <netinet/if_ether.h>
#include <stdio.h>
#include "defs.h"

#define VENDOR_NUMS_MASK	0xFFFFFF00
#define VEN_MAX		(sizeof(Vendor_nums) / sizeof(struct _vendor_nums))

static struct _vendor_nums  {
    unsigned long addr;
    char *name;
} Vendor_nums[] = { 
    0x00000200, "BBN (internal, no longer used)",
    0x00000C00, "Cisco Systems",
    0x00000E00, "Fujitsu",
    0x00000F00, "NeXT",
    0x00001000, "Hughes LAN Systems (formerly Sytek)",
    0x00001100, "Tektronix",
    0x00001500, "Datapoint Corporation",
    0x00001800, "Webster Computer Corporation (Appletalk/Ethernet Gateway)",
    0x00001A00, "AMD (?)",
    0x00001B00, "Novell",
    0x00001D00, "Cabletron",
    0x00002000, "Data Industrier AB (DIAB)",
    0x00002100, "SC&C",
    0x00002200, "Visual Technology",
    0x00002300,	"ABB Automation AB, Dept. Q",
    0x00002900, "IMC",
    0x00002A00, "TRW",
    0x00003C00, "Auspex",
    0x00003D00, "AT&T",
    0x00004400, "Castelle",
    0x00004600, "ISC-Bunker Ramo (an Olivetti company)",
    0x00004900, "Apricot Ltd.",
    0x00004B00, "APT (AppleTalk WAN Router)",
    0x00004F00, "Logicraft (386-Ware PC Emulator)",
    0x00005100,	"Hob Electronic GmbH & Co. KG",
    0x00005200, "ODS",
    0x00005500, "AT&T",
    0x00005A00, "Schneider & Koch/Syskonnect",
    0x00005D00, "RCE",
    0x00005E00, "US Dept. of Defense (IANA)",
    0x00005F00, "Sumitomo (?)",
    0x00006100, "Gateway Communications",
    0x00006200, "Honeywell",
    0x00006500, "Network General",
    0x00006900, "Silicon Graphics (?)",
    0x00006B00, "MIPS",
    0x00006E00, "Artisoft, Inc.",
    0x00007700, "Interphase (used in MIPS, Motorola)",
    0x00007800,	"Labtam Australia",
    0x00007900, "Net Ware (?)",
    0x00007A00, "Ardent",
    0x00007B00, "Research Machines",
    0x00007D00, "Cray Research Superservers, Inc. (also Harris (3M) (old))",
    0x00007F00, "Linotronic",
    0x00008000, "Dowty Network Services",
    0x00008100, "Synoptics",
    0x00008400, "Aquila (?), ADI Systems, Inc. (?)",
    0x00008600, "Gateway (?), Megahertz Corp. (?)",
    0x00008900, "Cayman Systems (Gatorbox)",
    0x00008A00,	"Datahouse Information Systems",
    0x00008E00, "Jupiter (?), Solbourne (?)",
    0x00009300, "Proteon",
    0x00009400, "Asante (MAC)",
    0x00009500, "Sony/Tektronix",
    0x00009700, "Epoch",
    0x00009800, "Cross Com",
    0x00009F00, "Ameristar Technology",
    0x0000A000, "Sanyo Electronics",
    0x0000A200, "Wellfleet",
    0x0000A300, "Network Application Technology",
    0x0000A400, "Acorn",
    0x0000A500, "Compatible Systems Corporation",
    0x0000A600, "Network General (internal)",
    0x0000A700, "Network Computing Devices (NCD) (X terminals)",
    0x0000A800, "Stratus Computer, Inc.",
    0x0000A900, "Network Systems Corp. (NSC)",
    0x0000AA00, "Xerox (Xerox machines)",
    0x0000AC00, "Apollo",
    0x0000AF00, "Nuclear Data (Acquisition Interface Modules)",
    0x0000B000, "RAD Network Devices (RND)",
    0x0000B300, "CIMLinc",
    0x0000B400,	"Edimax",
    0x0000B500, "Datability (terminal servers)",
    0x0000B700, "Dove (Fastnet)",
    0x0000BB00, "??? (AppleTalk?)",
    0x0000BC00, "Allen-Bradley",
    0x0000C000, "Standard Microsystems Corp. (SMC) (formerly Western Digital)",
    0x0000C600, "HP Intelligent Networks Operation (formerly Eon Systems)",
    0x0000C800, "Altos",
    0x0000C900, "Emulex (terminal servers)",
    0x0000CC00,	"Densan Co., Ltd.",
    0x0000D000, "Develcon Electronics Ltd.",
    0x0000D100, "Adaptec, Inc. (Nodem)",
    0x0000D400,	"PureData",
    0x0000D700, "Dartmouth College (NED router)",
    0x0000D800, "3Com? Novell? (IBM PS/2)",
    0x0000DD00, "Gould",
    0x0000DE00, "Unigraph",
    0x0000E200, "Acer Counterpoint",
    0x0000E300,	"Integrated Micro Products Ltd.",
    0x0000E600,	"Aptor Produits De Comm Indust",
    0x0000E800, "Accton Technology Corporation",
    0x0000E900,	"ISICAD, Inc.",
    0x0000ED00,	"April",
    0x0000EE00, "Network Designers Limited (?)",
    0x0000EF00, "Alantec",
    0x0000F000, "Samsung",
    0x0000F300, "Gandalf",
    0x0000F400, "Allied Telesis, Inc.",
    0x0000F600, "Applied Microsystems Corp. (AMC)",
    0x0000F800,	"Digital Equipment Corp. (?)",
    0x0000FD00, "High Level Hardware (Orion, UK)",
    0x00010200, "BBN (internal)",
    0x00014300, "IEEE 802",
    0x00016300, "National Datacomm Corporation",
    0x00016800, "Wandel & Goltermann",
    0x0001C800, "Thomas Conrad Corp.",
    0x00085200,	"Technically Elite Concepts",
    0x00085500,	"Fermilab",
    0x00170000, "Kabel",
    0x00400B00,	"Crescendo (?)",
    0x00400C00,	"General Micro Systems, Inc.",
    0x00400D00,	"LANNET Data Communications",
    0x00401000,	"Sonic (Mac ethernet interfaces)",
    0x00401400,	"Comsoft GmbH",
    0x00401500,	"Ascom (?)",
    0x00401F00,	"Colorgraph Ltd.",
    0x00402700,	"Sigma (?)",
    0x00402A00,	"Canoga-Perkins",
    0x00402B00, "TriGem",
    0x00402F00,	"XDI (?)",
    0x00403000,	"GK Computer",
    0x00403300,	"Addtron Technology Co., Ltd.",
    0x00403C00,	"Forks, Inc.",
    0x00404100,	"Fujikura Ltd.",
    0x00404C00,	"Hypertec Pty Ltd.",
    0x00405000,	"Ironics, Inc.",
    0x00405B00,	"Funasset Ltd.",
    0x00406600,	"Hitachi Cable Ltd.",
    0x00406800,	"Extended Systems",
    0x00406E00,	"Corollary, Inc.",
    0x00407400,	"Cable and Wireless",
    0x00407600,	"AMP Inc.",
    0x00407F00,	"Agema Infrared Systems AB",
    0x00408C00,	"Axis Communications AB",
    0x00408E00,	"CXR/Digilog",
    0x00409200,	"ASP Computer Products, Inc.",
    0x00409500,	"Eagle Technologies",
    0x00409D00,	"DigiBoard (Ethernet-ISDN bridges)",
    0x00409E00,	"Concurrent Technologies Ltd.",
    0x0040A600,	"Cray Research, Inc.",
    0x0040AE00,	"Delta Controls, Inc.",
    0x0040B400,	"3Com K.K.",
    0x0040B600,	"Computerm Corporation",
    0x0040C100,	"Bizerba-Werke Wilheim Kraut",
    0x0040C200,	"Applied Computing Devices",
    0x0040C300,	"Fisher and Porter Co.",
    0x0040C500, "Micom Communications Corp.",
    0x0040C600,	"Fibernet Research, Inc.",
    0x0040C800, "Milan Technology Corp.",
    0x0040D400,	"Gage Talker Corp.",
    0x0040DF00,	"Digalog Systems, Inc.",
    0x0040E700,	"Arnos Instruments & Computer",
    0x0040E900,	"Accord Systems, Inc.",
    0x0040F100,	"Chuo Electronics Co., Ltd.",
    0x0040F400,	"Cameo Communications, Inc.",
    0x0040F900,	"Combinet",
    0x0040FB00,	"Cascade Communications, Inc.",
    0x00608C00, "3Com (1990 onwards)",
    0x00800400,	"Antlow Computers Ltd.",
    0x00800500,	"Cactus Computer, Inc.",
    0x00800600,	"Compuadd Corp.",
    0x00800700,	"Dlog NC-Systeme",
    0x00800F00, "Standard Microsystems Corp. (SMC)",
    0x00801000, "Commodore",
    0x00801700, "PFU",
    0x00801900, "Dayna Communications (Etherprint)",
    0x00801A00,	"Bell Atlantic",
    0x00801B00, "Kodiak Technology",
    0x00802100, "Newbridge Networks Corporation",
    0x00802300,	"Integrated Business Networks",
    0x00802400,	"Kalpana",
    0x00802900, "Microdyne Corporation",
    0x00802D00, "Xylogics, Inc. (Annex terminal servers)",
    0x00802E00, "Plexcom, Inc.",
    0x00803300,	"Formation (?)",
    0x00803400, "SMT-Goupil",
    0x00803500, "Technology Works",
    0x00803700,	"Ericsson Business Communications",
    0x00803800,	"Data Research & Applications",
    0x00803B00,	"APT Communications, Inc.",
    0x00803E00,	"Synernetics",
    0x00803F00,	"Hyundai Electronics",
    0x00804200,	"Force Computers",
    0x00804C00,	"Contec Co., Ltd.",
    0x00804D00,	"Cyclone Microsystems, Inc.",
    0x00805100, "ADC Fibermux",
    0x00805200, "Network Professor",
    0x00805B00,	"Condor Systems, Inc.",
    0x00805C00, "Agilis (?)",
    0x00806000,	"Network Interface Corporation",
    0x00806200,	"Interface Co.",
    0x00806900,	"Computone Systems",
    0x00806A00,	"Empac Research, Inc.",
    0x00806C00,	"Cegelec Projects Ltd.",
    0x00806D00,	"Century Systems Corp.",
    0x00807400,	"Fisher Controls",
    0x00807B00,	"Artel Communications Corp.",
    0x00807C00, "FiberCom",
    0x00808600,	"Computer Generation, Inc.",
    0x00808700, "Okidata",
    0x00808A00,	"Summit (?)",
    0x00808B00,	"Dacoll Limited",
    0x00808C00, "Frontier Software Development",
    0x00809200,	"Japan Computer Industry, Inc.",
    0x00809600, "Human Designed Systems (HDS) (X terminals)",
    0x00809D00,	"Datacraft Manufacturing Pty Ltd.",
    0x00809F00,	"Alcatel Business Systems",
    0x0080A100, "Microtest",
    0x0080A300, "Lantronix",
    0x0080AD00,	"Telebit",
    0x0080AE00,	"Hughes Network Systems",
    0x0080AF00,	"Allumer Co., Ltd.",
    0x0080B200, "Network Equipment Technologies",
    0x0080C000,	"Penril (?)",
    0x0080C200,	"IEEE 802.1 Committee",
    0x0080C700, "Xircom, Inc.",
    0x0080C800, "D-Link, Solectek Pocket Adapters",
    0x0080C900,	"Alberta Microelectronic Centre",
    0x0080CE00,	"Broadcast Television Systems",
    0x0080D000, "Computer Products International",
    0x0080D300, "Shiva (Fastpath)",
    0x0080D400, "Chase Limited",
    0x0080D600,	"Apple (Mac portable) (?)",
    0x0080D700,	"Fantum Electronics",
    0x0080D800, "Network Perihperals",
    0x0080DA00,	"Bruel & Kjaer",
    0x0080E300,	"Coral (?)",
    0x0080F100, "Opus",
    0x0080F700,	"Zenith Communications Products",
    0x0080FB00,	"BVM Limited",
    0x00AA0000, "Intel",
    0x00B0D000, "Computer Products International",
    0x00C00100,	"Diatek Patient Managment",
    0x00C00400,	"Japan Business Computer Co., Ltd.",
    0x00C01600,	"Electronic Theatre Controls",
    0x00C01A00,	"Corometrics Medical Systems",
    0x00C01C00,	"Interlink Communications Ltd.",
    0x00C01D00,	"Grand Junction Networks, Inc.",
    0x00C02000,	"Arco Electronic Control Ltd.",
    0x00C02400,	"Eden Sistemas De Computacao SA",
    0x00C02500,	"Dataproducts Corporation",
    0x00C02700,	"Cipher Systems, Inc.",
    0x00C02800,	"Jasco Corporation",
    0x00C02B00,	"Gerloff Gesellschaft Fur",
    0x00C02C00,	"Centrum Communications, Inc.",
    0x00C02D00,	"Fuji Photo Film Co., Ltd.",
    0x00C03000,	"Integrated Engineering B. V.",
    0x00C03100,	"Design Research Systems, Inc.",
    0x00C03200,	"I-Cubed Limited",
    0x00C03400,	"Dale Computer Corporation",
    0x00C04000,	"ECCI",
    0x00C04200,	"Datalux Corp.",
    0x00C04400,	"Emcom Corporation",
    0x00C04800,	"Bay Technical Associates",
    0x00C04E00,	"Comtrol Corporation",
    0x00C05100,	"Advanced Integration Research",
    0x00C05C00,	"Elonex PLC",
    0x00C06600,	"Docupoint, Inc.",
    0x00C06D00,	"Boca Research, Inc.",
    0x00C07100,	"Areanex Communications, Inc.",
    0x00C07800,	"Computer Systems Engineering",
    0x00C09100,	"Jabil Circuit, Inc.",
    0x00C09300,	"Alta Research Corp.",
    0x00C09700,	"Archipel SA",
    0x00C09800,	"Chuntex Electronic Co., Ltd.",
    0x00C09D00,	"Distributed Systems Int'l, Inc",
    0x00C0A000,	"Advance Micro Research, Inc.",
    0x00C0A200,	"Intermedium A/S",
    0x00C0A800,	"GVC Corporation",
    0x00C0AC00,	"Gambit Computer Communications",
    0x00C0AD00,	"Computer Communication Systems",
    0x00C0B000,	"GCC Technologies,Inc.",
    0x00C0B800,	"Fraser's Hill Ltd.",
    0x00C0BD00,	"Inex Technologies, Inc.",
    0x00C0BE00,	"Alcatel - Sel",
    0x00C0C200,	"Infinite Networks Ltd.",
    0x00C0C400,	"Computer Operational",
    0x00C0CA00,	"Alfa, Inc.",
    0x00C0CB00,	"Control Technology Corporation",
    0x00C0D100,	"Comtree Technology Corporation",
    0x00C0D600,	"J1 Systems, Inc.",
    0x00C0DC00,	"EOS Technologies, Inc.",
    0x00C0E200,	"Calcomp, Inc.",
    0x00C0E700,	"Fiberdata AB",
    0x00C0EA00,	"Array Technology Ltd.",
    0x00C0EC00,	"Dauphin Technology",
    0x00C0EF00,	"Abit Corporation",
    0x00C0F400,	"Interlink System Co., Ltd.",
    0x00C0F600,	"Celan Technology Inc.",
    0x00C0F700,	"Engage Communication, Inc.",
    0x00C0F800,	"About Computing, Inc.",
    0x00C0FB00,	"Advanced Technology Labs",
    0x00DD0000, "Ungermann-Bass (IBM RT)",
    0x00DD0100, "Ungermann-Bass",
    0x00DD0800,	"Ungermann-Bass",
    0x00EFE500, "3Com (IBM Microchannel card)",
    0x02040600, "BBN (internal)",
    0x02070100, "MICOM/Interlan (UNIBUS/QBUS/Apollo/Cisco)",
    0x02606000, "3Com",
    0x02608600, "Satelcom MegaPac (UK)",
    0x02608C00, "3Com (IBM-PC/Imagen/Valid/Cisco/Macintosh)",
    0x02CF1F00, "CMC (Masscomp/Silicon Graphics)",
    0x02E6D300, "Bus-Tech, Inc. (IBM mainframes)",
    0x08000100, "Computer Vision",
    0x08000200, "3Com (formerly Bridge)",
    0x08000300, "Advanced Computer Communications (ACC)",
    0x08000500, "Symbolics (LISP machines)",
    0x08000600,	"Siemens Nixdorf (PC clones)",
    0x08000700, "Apple",
    0x08000800, "BBN",
    0x08000900, "Hewlett-Packard",
    0x08000A00, "Nestar Systems",
    0x08000B00, "Unisys",
    0x08000D00, "International Computers, Ltd. (ICL)",
    0x08000E00, "NCR/AT&T",
    0x08000F00, "Standard Microsystems Corporation (SMC)",
    0x08001000, "AT&T",
    0x08001100, "Tektronix, Inc.",
    0x08001400, "Excelan (BBN Butterfly/Masscomp/Silicon Graphics)",
    0x08001700, "National Semiconductor Corp. (NSC)",
    0x08001A00, "Data General",
    0x08001B00, "Data General",
    0x08001E00, "Apollo",
    0x08001F00, "Sharp",
    0x08002000, "Sun Microsystems, Inc.",
    0x08002200, "NBI",
    0x08002300, "Matsushita Denso",
    0x08002500, "CDC",
    0x08002600, "Norsk Data",
    0x08002700, "PCS Computer Systems GmbH",
    0x08002800, "TI (Explorer)",
    0x08002B00, "Digital Equipment Corp.",
    0x08002E00, "Metaphor",
    0x08002F00, "Prime Computer (50-series LHC300)",
    0x08003000,	"CERN",
    0x08003600, "Intergraph",
    0x08003700, "Fujitsu-Xerox",
    0x08003800, "Bull",
    0x08003900, "Spider Systems",
    0x08003B00, "Torus Systems",
    0x08003E00, "Motorola (VME bus processor modules)",
    0x08004100, "Digital Comm. Association (DCA)",
    0x08004400, "DAVID Systems, Inc. (DSI)",
    0x08004500, "Xylogics (? - maybe; they claim no knowledge of this number)",
    0x08004600, "Sony",
    0x08004700, "Sequent",
    0x08004800,	"Eurotherm Gauging Systems",
    0x08004900, "Univation",
    0x08004C00, "Encore",
    0x08004E00, "BICC",
    0x08005100, "Experdata",
    0x08005600, "Stanford University",
    0x08005700, "Evans & Sutherland (?)",
    0x08005800, "??? (DECsystem-20)",
    0x08005A00, "IBM",
    0x08005D00, "Gould",
    0x08006700, "Comdesign",
    0x08006800, "Ridge",
    0x08006900, "Silicon Graphics",
    0x08006A00, "ATTst (?)",
    0x08006E00, "Excelan",
    0x08007000, "Mitsubishi",
    0x08007400, "Casio",
    0x08007500, "Danish Data Elektronik A/S (DDE)",
    0x08007700, "Retix, Inc. (formerly TSL)",
    0x08007900, "Silicon Graphics",
    0x08007C00, "Vitalink (TransLAN III)",
    0x08008000, "XIOS",
    0x08008100, "Crosfield Electronics",
    0x08008300, "Seiko Denshi",
    0x08008600, "Imagen/QMS",
    0x08008700, "Xyplex",
    0x08008900, "Kinetics",
    0x08008B00, "Pyramid",
    0x08008D00, "XyVision",
    0x08008E00, "Tandem",
    0x08008F00,	"Chipcom Corp.",
    0x08009000, "Retix, Inc.",
    0x10005A00,	"IBM (RS/6000s, X terminals)",
    0x1000D400,	"Digital Equipment Corp.",
    0x1000E000,	"Apple (A/UX modified addrs for licensing)",
    0x40000300,	"Net Ware (?)",
    0x47544300,	"GTC (this number is a multicast!)",
    0x48445300,	"HDS (?)",
    0x80001000,	"AT&T (3b line?)",
    0xAA000000,	"Digital Equipment Corp. (obsolete)",
    0xAA000100,	"Digital Equipment Corp. (obsolete)",
    0xAA000200,	"Digital Equipment Corp. (obsolete)",
    0xAA000300,	"Digital Equipment Corp. (global physaddr for some machines)",
    0xAA000400,	"Digital Equipment Corp. (DECNET local logical address)",
    0xC0000000,	"Western Digital (?)",
    0xEC100000,	"Enance Source Co., Ltd. (PC clones?)",
};

char *
vendor_name(ea)
struct ether_addr *ea;
{
	int ether_num;
	int i;

	ether_num = 0;
	ether_num =
		(ea->ether_addr_octet[0] << 24 ) |
		(ea->ether_addr_octet[1] << 16 ) |
		(ea->ether_addr_octet[2] << 8 );

	/* I should install a binary search */
	for (i=0; i < VEN_MAX; i++) {
		if ((ether_num & VENDOR_NUMS_MASK) ==
		    (Vendor_nums[i].addr & VENDOR_NUMS_MASK)) {
			return(Vendor_nums[i].name);
		}
	}

	return("???");
}
