#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/mbuf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/errno.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include <net/if.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_pcb.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>

#include "if_vsr.h"

#include <arpa/inet.h>

main(argc, argv)
int argc;
char **argv;
{
	int fd, len;

	optarr_t oa;
	struct in_addr src, hop, dst;

	if (argc < 3) {
	  printf("usage: %s /dev/vsr? HOP1 HOP2 ... HOPn\n", argv[0]);
	  exit(-1);
	}

        if ((fd = open(argv[1], O_RDWR)) < 0) {
	  perror("vsr");
	  exit(-1);
	}

	bzero(oa, sizeof(oa));
	hop.s_addr = inet_addr(argv[2]);
	bcopy(&hop, &oa[0], 4);

	oa[4] = 131;
	oa[6] = 4;

	len = 7;

	argv++; argc--;
	argv++; argc--;
	argv++; argc--;

	while(argc--) {
		hop.s_addr = inet_addr(*argv++);
		bcopy(&hop, &oa[len], 4);
		len += 4;
	}

	oa[5] = len;

	oa[len] = 0;
	oa[len+1] = 0;
	oa[len+2] = 0;
	oa[len+3] = 0;
	oa[len+4] = 0;

	if (ioctl(fd, VSRCSETROUTE, oa) < 0)
	  perror("ioctl");
}

