
/*
 * Modloadable wrapper for the virtual interface.
 * Code stolen from the 4.1.3 AnswerBook, the modloadable cslip-2.6
 * patches, and by observing system files (so that it would work with
 * sun4m machines.
 */

#include <sys/types.h>
#include <sys/conf.h>
#include <sys/buf.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sundev/mbvar.h>
#include <sun/autoconf.h>
#include <sun/vddrv.h>
#if defined(sun4c) || defined(sun4m)
#include <sun/openprom.h>
#endif

extern int vsropen(), vsrclose(), vsrioctl();
extern int nulldev();

struct cdevsw vsrdevsw = 
{
	vsropen,	/* open */
	vsrclose,	/* close */
	nulldev,	/* read */
	nulldev,	/* write */
	vsrioctl,	/* ioctl */
	nulldev,	/* reset */
	nulldev,	/* select */
	nulldev,	/* mmap */
	0,		/* STREAMS tab ? */
	nulldev,	/* segmap */
};


#ifdef sun4m
struct vdldrv vd = 
{
	VDMAGIC_PSEUDO,
	"vsr",
	NULL,
	NULL,
	&vsrdevsw,
	0,
	0,
	NULL,
	NULL,
	NULL,
	0,
	1,
};
#else /* sun4m */
struct vdldrv vd =
{
	VDMAGIC_PSEUDO,
	"vsr",
#ifdef sun4c
	NULL,
#else
	NULL,
	NULL,
	NULL,
	0,
	1,
#endif /* sun4c */
	NULL,
	&vsrdevsw,
	0,
	0,
};
#endif /* sun4m */

xxxinit(fc, vdp, vdi, vds)
	unsigned int fc;
	struct vddrv *vdp;
	addr_t vdi;
	struct vdstat *vds;
{
	switch (fc)
	{
	      case VDLOAD:
		vdp->vdd_vdtab = (struct vdlinkage *)&vd;
		return vsrattach(0);
		
	      case VDUNLOAD:
		return unload(vdp, vdi);
		
	      case VDSTAT:
		return 0;

	      default:
		return EIO;
	}
}

static unload(vdp, vdi)
	struct vddrv *vdp;
	struct vdioctl_unload  *vdi;
{
	int err = vsrdetach();
	if (err)
		printf("vsr: Cannot unload vsr interface\n");
	return err;
}

