/* YP security checker. Meant as an addition to COPS. */

#include <stdio.h>
#include <rpc/rpc.h>
#include <rpcsvc/yp_prot.h>
#include "nhost.h"
#ifndef lint
static char *copyright = "@(#)yp-check.c 1.0 92/05/10 Rob J. Nauta\n";
#endif

char *get_smname();
char *defaultdomain, *programname;

CLIENT *
rpc_yp_client(arg, thisport)
char *arg;
int thisport;
{
	char myhost[100];
	struct sockaddr_in *server_addr;
	int sock = RPC_ANYSOCK, klad = 0;
	CLIENT *client;

	if (gethostname(myhost, 100))	/* Get our own hostname */
		perror(programname);
	server_addr = getsock(arg);	/* Get adress info */
	if (server_addr == NULL)
		return (NULL);
	server_addr->sin_port = thisport;	/* Normally 0 (= portmapper) */

	if ((client = clnttcp_create(server_addr, YPPROG, YPVERS,
				     &sock, 0, 0)) == NULL) {
		clnt_pcreateerror(programname);
		return (NULL);	/* Failure */
	}
	client->cl_auth = authunix_create(myhost, 0, 0, 1, &klad);
	return (client);	/* Success */
}

main(argc, argv)
int argc;
char *argv[];
{
	int c;
	int debug = 0, errflg = 0;
	int thisport = 0;
	char *hostname;
	char which[256];
	FILE *P;
	extern int optind;
	extern char *optarg;
	CLIENT *client;		/* Client pointer */

	programname = argv[0];
	while ((c = getopt(argc, argv, "d?")) != EOF)
		switch (c) {
		    case 'd':	/* debug */
			debug++;
			break;
		    case '?':	/* help */
		    default:
			errflg++;
			break;
		}
	if (optind > argc)
		errflg++;
	if (errflg) {
		fprintf(stderr, "Usage:	%s [-d]  [domainname ...]\n",
			programname);
		exit(1);
	}
	yp_get_default_domain(&defaultdomain);
	if (debug)
		fprintf(stderr, "The default domainname is: %s\n",
			defaultdomain);

	if ((P = popen("ypwhich", "r")) == NULL) {
		perror(argv[0]);
		exit(1);
	}
	fscanf(P, "%s", which);
	if (strcmp(which, "ypwhich:") == NULL) {
		/* Very ugly kludge, but this is to keep it simple */
		fprintf(stderr, "%s: Error running ypwhich.\n", argv[0]);
		exit(1);
	}
	if (debug)
		fprintf(stderr, "The current NIS server is: %s\n", which);
	client = rpc_yp_client(which, thisport);
	if (client == NULL)
		exit(2);	/* Host not found, or no ypserv */
	hostname = get_smname(which, debug);
	if (debug)
		fprintf(stderr, "Sendmail on that machine says its hostname is: %s\n", hostname);

	/* Now test whether the domainname is too obvious */
	if (strstr(which, defaultdomain)) {
		printf("Warning!  The NIS domainname (%s)\n	  is part of the NIS server's hostname (%s) !\n", defaultdomain, which);
		return (0);
	}
	if (strstr(hostname, defaultdomain)) {
		printf("Warning!  The NIS domainname (%s)\n	  is part of the NIS server's hostname (%s) !\n", defaultdomain, hostname);
		return (0);
	}
	auth_destroy(client->cl_auth);	/* Free authorization struct */
	clnt_destroy(client);	/* Free client structure */
	return (0);
}
