/* ypx 2.1 (c) Copyright 1991,1992 by Rob J. Nauta. All rights reserved. */
#include <stdio.h>
#include <rpc/rpc.h>
#include "nhost.h"
#include "ypx-add.h"
#ifndef lint
static char *copyright = "@(#)ypx-main.c 2.2 92/05/09 Rob J. Nauta\n";
#endif

extern CLIENT *rpc_yp_client();
char *ypdomain, *programname;

main(argc, argv)
int argc;
char *argv[];
{
	int c;
	int debug = 0, errflg = 0, guessing = 0, toafile = 0, sendmail = 0;
	int thisport = 0;
	char *mapname = "passwd.byname";
	FILE *outputfile;
	extern int optind;
	extern char *optarg;
	CLIENT *client;		/* Client pointer */

	programname = argv[0];
	outputfile = stdout;
	tablec = 0;
	while ((c = getopt(argc, argv, "dgm:o:p:s")) != EOF)
		switch (c) {
		    case 'd':	/* debug */
			debug++;
			break;
		    case 'g':	/* guessing */
			guessing++;
			break;
		    case 'm':	/* mapname */
			mapname = optarg;
			break;
		    case 'o':	/* redirect output */
			outputfile = fopen(optarg, "w");
			toafile++;
			break;
		    case 'p':	/* go directly to port thisport */
			thisport = atoi(optarg);
			break;
		    case 's':	/* try sendmail */
			sendmail++;
			break;
		    case '?':	/* help */
		    default:
			errflg++;
			break;
		}
	if (optind >= argc)
		errflg++;
	if (errflg) {
		fprintf(stderr, "Usage:	%s [-dgs] [-m mapname] [-o outputfile] [-p portnumber]\n	hostname [domainname ...]\n",
			programname);
		exit(1);
	}
	client = rpc_yp_client(argv[optind], thisport);
	if (client == NULL)
		exit(2);	/* Host not found, or no ypserv */
	if (guessing)
		parse(argv[optind]);	/* build name table */
	if (sendmail)		/* Add sendmail hostname */
		parse(get_smname(argv[optind], debug));
	while (optind < argc)
		add(argv[optind++]);	/* just add arg to table */

	if ((trymap(client, mapname, debug, outputfile) == 0) && debug)
		fprintf(stderr, "YP map transfer successfull.\n");
	auth_destroy(client->cl_auth);	/* Free authorization struct */
	clnt_destroy(client);	/* Free client structure */
	return (0);
}
