/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Filename: findip.c
 * Created : Nov. 10th 1995 @ 4:30pm
 * Author  : SrfRoG (srfrog@itek.net)
 * Descrip.: This cute little program will attempt to resolve
 *   an IP address to its hostname. Then prints the results
 *   to standard output.
 * ---------------------------------------------------------------------
 * To compile this program:
 * Linux:	gcc -O2 -m486 -s -o findip findip.c
 * AIX, BSD:	gcc -O2 -s -o findip findip.c
 * SunOS:	gcc -O2 -lnsl -s -o findip findip.c
 * Other:	cc -o findip findip.c
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

int main(argc, argv)
int argc;
char **argv;
{  
	struct hostent *ip;
	unsigned long hostname;

	if (argc != 2)
	{
		printf("Need to specify an IP address.\n");
		exit(1);
	} 
	if ((hostname = inet_addr(argv[1])) == -1)
	{
		printf("Could not find %s\n", argv[1]);
		exit(1);
	}
	if ((ip = gethostbyaddr((char *)&hostname, sizeof(long), AF_INET)) != NULL)
		printf("%s is %s\n", argv[1], ip->h_name);
	else
		printf("Could not resolve %s\n", argv[1]);
	return 0;
}
