UTMP(5V)                  FILE FORMATS                   UTMP(5V)



NAME
     utmp, wtmp, lastlog - login records

SYNOPSIS
     #include <utmp.h>
     #include <lastlog.h>

DESCRIPTION
  utmp file
     The utmp file records information  about  who  is  currently
     using  the system.  The file is a sequence of utmp structure
     entries.  That structure is defined in  <utmp.h>,  and  con-
     tains the following members:

          ut_line     Character array containing the name of  the
                      terminal on which the user logged in.
          ut_name     Character array containing the name of  the
                      user who logged in.

          ut_host     Character array containing the name of  the
                      host  from  which  the user remotely logged
                      in, if they logged in  from  another  host;
                      otherwise, a null string.

          ut_time     long containing the time at which the  user
                      logged  in,  in  seconds  since  00:00 GMT,
                      January 1, 1970.

     Whenever a user logs in, login(1)  fills  in  the  entry  in
     /etc/utmp  for  the  terminal  on  which the user logged in.
     When they log out, init(8)  clears  that  entry  by  setting
     ut_name  and ut_host to null strings and ut_time to the time
     at which the user logged out.

     Some window systems will make entries in utmp  for  terminal
     emulation  windows  running shells, so that library routines
     such as getlogin will work correctly in that window.   These
     entries  do not directly represent logged-in users; they are
     associated with a user who has already logged into the  sys-
     tem  on  another  terminal.   These entries generally have a
     ut_line field  that  refers  to  a  pseudo-terminal,  and  a
     ut_host  field  that  is  a null string.  The macro nonuser,
     defined in <utmp.h>, takes a pointer to a utmp structure  as
     an  argument  and,  if  the  entry  has a ut_line field that
     refers to a pseudo-terminal, and a ut_host field that  is  a
     null  string,  will  return  1; otherwise, it will return 0.
     This can be used by programs that  print  information  about
     logged-in  users  if  they  should not list entries made for
     logged-in users' additional windows.

UTMP(5V)                  FILE FORMATS                   UTMP(5V)

  wtmp file
     The wtmp file records all logins and logouts.  It also  con-
     sists of a sequence of utmp entries.

     Whenever a user logs in, login appends a record identical to
     the  record  it  placed in utmp to the end of /var/adm/wtmp.
     Whenever a user logs out, init appends a record with ut_line
     equal  to  the  terminal  that  the  user  was logged in on,
     ut_name and ut_host null, and ut_time equal to the  time  at
     which the user logged out.

     When the system is shut down, init appends a record  with  a
     ut_line  of  ~, a ut_name of shutdown, a null ut_host, and a
     ut_time equal to the time at which  the  shutdown  occurred.
     When  the  system  is rebooted, init appends a record with a
     ut_line of ~, a ut_name of reboot, a  null  ut_host,  and  a
     ut_time equal to the time at which init wrote the record.

     When  the  date  command  is  used  to  change  the  system-
     maintained  time, date appends a record with a ut_line of |,
     ut_name and ut_host null, and ut_time equal  to  the  system
     time  before  the  change,  and then appends a record with a
     ut_line of {, ut_name and ut_host null, and ut_time equal to
     the system time after the change.

     None of the programs that maintain wtmp create the file,  so
     that  if record-keeping is to be enabled, it must be created
     by hand as  a  zero-length  file,  and  if  it  is  removed,
     record-keeping is turned off.  It is summarized by ac(8).

     As wtmp is appended to whenever a user logs in  or  out,  it
     should be truncated periodically so that it does not consume
     all the disk space on its file system.

  lastlog file
     The lastlog file records  the  most  recent  login-date  for
     every  user  logged  in.   The file is a sequence of lastlog
     structure   entries.    That   structure   is   defined   in
     <lastlog.h>, and contains the following members:

          ll_time     long containing the time at which the  user
                      logged  in,  in  seconds  since  00:00 GMT,
                      January 1, 1970.

          ll_line     Character array containing the name of  the
                      terminal on which the user logged in.

          ll_host     Character array containing the name of  the
                      host  from  which  the user remotely logged
                      in, if they logged in  from  another  host;
                      otherwise, a null string.

UTMP(5V)                  FILE FORMATS                   UTMP(5V)

     When reporting (and updating) the most  recent  login  date,
     login   performs   an   lseek(2V)   to   a   byte-offset  in
     /var/adm/lastlog corresponding to the userid.   Because  the
     count  of  userids  may  be  high, whereas the number actual
     users may be small within a network environment, the bulk of
     this  file  may  never  be allocated by the file system even
     though an offset may appear  to  be  quite  large.  Although
     ls(1V)  may  show it to be large, chances are that this file
     need not be  truncated.   du(1V)  will  report  the  correct
     (smaller) amount of space actually allocated to it.

SYSTEM V DESCRIPTION
     For XPG2 conformance, the XPG2  private  utmp  structure  is
     preserved  for  use  by compliant applications that specifi-
     cally use the utmp structure. The structure  is  defined  in
     /usr/xpg2include/utmp.h.   Note:  this  structure definition
     was removed in XPG3, and will be removed in a  future  SunOS
     release.  Applications using the XPG2 utmp structure must do
     so on an application private basis.

FILES
     /etc/utmp
     /var/adm/wtmp
     /var/adm/lastlog

SEE ALSO
     login(1), who(1), ac(8), init(8)
