/*  scrap.c --- a linux loadable module that changes a machine's hardware 
                address
    Copyright (C) 1995 by Louis P. Kruger <lpkruger@cs.princeton.edu> and
                          Andrew C. Myers <acmyers@cs.princeton.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    To receive a copy of the GNU General Public Licent, write to the 
    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
    USA.

*/


#include <linux/sched.h>
#include <linux/errno.h>
#include <linux/major.h>
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/autoconf.h>
#include <linux/module.h>
#include <linux/mm.h>
#include <linux/ioport.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>


/* int bad_user_access_length(void) {} */

unsigned int addr[MAX_ADDR_LEN]={0,0,0,0,0,0};
char *name = "eth0";

static unsigned int old_addr[MAX_ADDR_LEN]={0,0,0,0,0,0};
static struct device *the_dev = NULL;

static struct device *my_dev_get(void)
{
  struct device *d;
  const char *a, *b;

  for (d = dev_base; d != NULL; d = d->next)
    {
      a = d->name; 
      b = name;
      for ( ; *a != '\0' && *b != '\0'; a++, b++)
       if (*a != *b) goto hack;
      return d;
    hack:
    }
  return NULL;
}


static void set_address(struct device *dev)
{
  int i;

  for (i = 0; i < MAX_ADDR_LEN; i++) {
    old_addr[i] = dev->dev_addr[i];
    dev->dev_addr[i] = (unsigned char)addr[i];
  }
}

int init_module(void)
{
  struct device *d;

  printk("Just started spoofing hardware address\n");
  d = my_dev_get();
  the_dev = d;
  if (d == NULL)
    {
      printk("Captain, I can't find any ethernet device named %s!\n", name);
      return 1;
    }
  set_address(d);
  return 0;
}

void cleanup_module(void) 
{
  int i;

  for (i = 0; i < MAX_ADDR_LEN; i++) {
    the_dev->dev_addr[i] = (unsigned char)old_addr[i];
  }
  printk("Just stopped spoofing hardware address\n");
}

