/****
 * socketio.c
 *  - This file contains code for socket I/O.
 *    Things like opening up the socket, and I/O on the socket.
 ****/
#include <stdio.h>
#include <varargs.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "socdefs.h"
#include "socketio.h"

int                socket_address_family;
int                socket_type;
int                socket_protocol;
int                socket_descriptor;
int                socket_rc;
struct sockaddr_in server_address;
struct sockaddr_in client_address;
int                client_descriptor;

/*
 * soc_fprintf()
 *   - variable argument length routine that acts exactly like fprintf,
 *     except that if the variable 'silent_mode' is set, then output
 *     will be suppressed.
*/
void soc_fprintf(sd_stream, sd_format, va_alist)
FILE *sd_stream;
char *sd_format;
va_dcl
{
  va_list args;

   va_start(args);
   if (silent_mode == false) {
      vfprintf(sd_stream, sd_format, args);
   }
   va_end(args);
}

/*
 * soc_write()
 *   - writes message 'out_msg' of 'msg_len' characters to socket
 *     descriptor 'soc_des'. Not the weird usage of the write()
 *     call. This is because sockets act differently that file
 *     descriptors depending on the protocol in use.
 *   - This routine from Stevens.
*/
void soc_write(soc_des, out_msg, msg_len)
register int   soc_des;
register char *out_msg;
register int   msg_len;
{
 int num_written;
 int num_left;

   num_left = msg_len;

   while(num_left > 0) {
      num_written = write(soc_des, out_msg, msg_len);
      if (num_written < 0) {
         soc_fprintf(stderr,
                     "ERROR(%d): Write on internet socket failed [%d].\n",
                     SOCKET_WRITE_FAILED, errno);
         return;
      }
      num_left -= num_written;
      out_msg  += num_written;
   }
}

/*
 * tell_user()
 *   - This routine does formated output on the internet socket.
*/
void tell_user(soc_des, sd_format, va_alist)
int   soc_des;
char *sd_format;
va_dcl
{
  va_list args;
  char out_msg[MAX_OUTPUT_LEN];
  int  out_msg_len;

   va_start(args);
   vsprintf(out_msg, sd_format, args);
   va_end(args);
   out_msg_len = strlen(out_msg);
   soc_write(soc_des,out_msg,out_msg_len);
}

/*
 * soc_read()
 *   - reads a string from the socket descriptor soc_des,
 *     up until a newline, or msg_len charaters have been
 *     read in.
 *   - This routine from Stevens.
*/
int soc_read(soc_des, in_msg, msg_len)
register int   soc_des;
register char *in_msg;
register int   msg_len;
{
 int i;
 int read_rc;
 char c;
 int any_chars = false;

   for (i=1;i<msg_len;i++) {
      if ((read_rc = read(soc_des, &c, 1)) == 1) {
         if ((c == ' ')&&(!any_chars))
            continue;

         any_chars = true;
         *in_msg++ = c;
         if (c == '\n') {
            break;
         }
      } else if (read_rc == 0) {
         if (i==1) {
            return 0;
         } else {
            break;
         }
      } else {
         return(-1);
      }
   }
   *in_msg = 0;
   return(i);
}

