/************************************************************************/
/* ypdump001.c by Arny - arny@geek.org.uk				*/
/************************************************************************/
/* (c) copyright 1996 R.T.Arnold.  All rights reserved.  Permission is	*/
/* given for strictly non-profit personal educational use only.		*/
/************************************************************************/
/* ypdump is currently part of ypghost, which is available free of	*/
/* charge from the "unix/net/hack" page at:				*/
/*			http://www.unix.geek.org.uk/~arny/	(U.K.)	*/
/*			http://www.unix.geek.net/~arny/		(U.S.)	*/
/************************************************************************/

#include<sys/types.h>
#include<netinet/in.h>
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<errno.h>
#include<signal.h>
#include<pcap.h>

#ifndef INADDR_NONE
#define INADDR_NONE	0xffffffff
#endif

#define USAGE		"usage: %s [-Ocr] [-i interface] [-s snaplength] [-t timeout] [-f 'filter string']\n"

#define MAXLINELENGTH	1024	/* as defined by YPMAXRECORD in yp.x	*/
#define MAXNAMELENGTH	64	/* as defined by YPMAXDOMAIN/YPMAXMAP "	*/

#define FILTLEN		1024	/* size of filter string buffer		*/
#define DEFAULTSNAP	512	/* in bytes, big means slow		*/
#define DEFAULTTIMEOUT	1024	/* in milliseconds			*/
#define PROMISC		1	/* 1 means yes, 0 means no		*/

#define PADDING(x) (3-((x+3)%4))

void pcaptoip(u_char*,struct pcap_pkthdr*,const u_char*);

void mainbit(u_char*,int);
void displaystuff(u_char*);
int displaymatchcall(u_char*,int);
void displaymatchreply(u_char*);
void printxdrstring(u_char *,u_long);
void theend(int);

u_short cptos(u_char*);
u_long cptol(u_char*);
u_char *scptocp(u_char*,u_char*);
u_char *lcptocp(u_char*,u_char*);
u_char *stocp(u_char*,u_short);
u_char *ltocp(u_char*,u_long);


union shortunion
        {
        u_short s;
        u_char c[2];
        };

union longunion
        {
        u_long l;
        u_char c[4];
        };


int dontshowcall;
int dontshowreply;

extern int optind;	/* needed for getopt(3), not quite sure why....	*/
extern char *optarg;	/*          ...these are not always in unistd.h	*/

/* you can delete the next line if you want, though on some systems 	*/
/* it wont compile if you do.  Does anybody know why?????????		*/

int fddipad;

pcap_t *pcd=NULL;
int offset;


main(int argc,char **argv)
{
int i;
char *filt=NULL;
char errbuf[PCAP_ERRBUF_SIZE];
char *interface=NULL;
int snaplength=DEFAULTSNAP;
int timeout=DEFAULTTIMEOUT;
int optimise=1;
u_long network,netmask;
struct bpf_program prog;

printf("\nypdump version 0.01 (c) copyright 1996 Arny - arny@geek.org.uk\n\n");

if((sizeof(u_char)!=1)||(sizeof(u_short)!=2)||(sizeof(u_long)!=4))
	{
	fprintf(stderr,"error: u_char, u_short, or u_long aren't the right size!!!\n");
	exit(1);
	};

while((i=getopt(argc,argv,"Ocri:s:t:f:"))!= -1)
	switch(i)
		{
		case 'O' :	optimise=0;
				break;
		case 'c' :	dontshowcall=1;
				break;
		case 'r' :	dontshowreply=1;
				break;
		case 'i' :	interface=optarg;
				break;
		case 's' :	snaplength=atoi(optarg);
				break;
		case 't' :	timeout=atoi(optarg);
				break;
		case 'f' :	filt=optarg;
				break;
		case '?' :	fprintf(stderr,USAGE,*argv);
				exit(1);
		default :	fprintf(stderr,"????? error processing command line arguments\n");
				exit(1);
		};

if((argc-optind)!=0)
	{
	fprintf(stderr,USAGE,*argv);
	exit(1);
	};

if(dontshowcall&&dontshowreply) fprintf(stderr,"warning: both -c and -r specified, NOTHING will be shown!\n");

/****************** libpcap stuff starts here ***************************/

if(interface==NULL) if((interface=pcap_lookupdev(errbuf))==NULL)
	{
	fprintf(stderr,"pcap_lookupdev: %s\n",errbuf);
	exit(1);
	};
if(pcap_lookupnet(interface,&network,&netmask,errbuf)== -1)
	{
	fprintf(stderr,"pcap_lookupnet: %s\n",errbuf);
	exit(1);
	};
printf("interface=%s, network=%08lx, netmask=%08lx, snaplength=%d, timeout=%d\n",interface,ntohl(network),ntohl(netmask),snaplength,timeout);
if(!optimise) fprintf(stderr,"packet matching code optimiser turned off, do you suspect a bug in the code?\n");

if((pcd=pcap_open_live(interface,snaplength,PROMISC,timeout,errbuf))==NULL)
	{
	fprintf(stderr,"pcap_open_live: %s\n",errbuf);
	exit(1);
	};

switch(pcap_datalink(pcd))
	{
	case DLT_EN10MB :	offset=14;
				break;
	case DLT_NULL :		offset=0;
				break;
	default :		fprintf(stderr,"error: unsupported link layer type\n");
				exit(1);
	};

if(filt!=NULL)
	{
	if(pcap_compile(pcd,&prog,filt,optimise,netmask)<0)
		{
		pcap_perror(pcd,"pcap_compile");
		exit(1);
		};
	if(pcap_setfilter(pcd,&prog)<0)
		{
		pcap_perror(pcd,"pcap_setfilter");
		exit(1);
		};
	};

if(signal(SIGINT,theend)==SIG_ERR) fprintf(stderr,"odd!  SIG_ERR returned by signal()\n");
if(signal(SIGTERM,theend)==SIG_ERR) fprintf(stderr,"odd!  SIG_ERR returned by signal()\n");

putchar('\n');

if(pcap_loop(pcd,0,(pcap_handler)pcaptoip,NULL)== -1)
	{
	pcap_perror(pcd,"pcap_loop");
	exit(1);
	};

fprintf(stderr,"odd!  pcap_loop has returned without an error?\n");
exit(1);
}


void pcaptoip(u_char *user,struct pcap_pkthdr* pchdr,const u_char *stuff)
{

/* libpcap lengths shouldn't be relied on.  Sure they may work fine on	*/
/* *YOUR* system.							*/

if(pchdr->caplen<pchdr->len) return;

mainbit((u_char*)stuff+offset,(pchdr->len)-offset);

}


/****************** libpcap stuff ends here *****************************/


void mainbit(u_char *ippkt,int size)
{
register u_long c;
int iplen;

if(size<60) return;
if((iplen=(int)ntohs(cptos(ippkt+2)))<60) return;
if(size<iplen) return;

if(ippkt[0]!=0x45) return;
if(ippkt[9]!=0x11) return;

switch(ntohl(cptol(ippkt+32)))
	{
	case 0x00000000 :
		if(dontshowcall) return;
		if(iplen<80) return;
		if(ntohl(cptol(ippkt+36))!=0x00000002) return;
		if(ntohl(cptol(ippkt+40))!=0x000186a4) return;
		if(ntohl(cptol(ippkt+44))!=0x00000002) return;
		displaystuff(ippkt);
		for(c=52;c<68;c++) if(ippkt[c]!=0)
			{
			printf("possibly a NIS call, but AUTH_NULL not used\n\n");
			return;
			};
		printf("NIS call: ");
		switch(ntohl(cptol(ippkt+48)))
			{
			case 0x00000000 : printf("YPPROC_NULL\n"); break;
			case 0x00000001 : printf("YPPROC_DOMAIN\n"); break;
			case 0x00000002 : printf("YPPROC_DOMAIN_NONACK\n"); break;
			case 0x00000003 : printf("YPPROC_MATCH\n"); if(displaymatchcall(ippkt+68,iplen-68)) printf("error interepting ypreq_key\n"); break;
			case 0x00000004 : printf("YPPROC_FIRST\n"); break;
			case 0x00000005 : printf("YPPROC_NEXT\n"); break;
			case 0x00000006 : printf("YPPROC_XFR\n"); break;
			case 0x00000007 : printf("YPPROC_CLEAR\n"); break;
			case 0x00000008 : printf("YPPROC_ALL\n"); break;
			case 0x00000009 : printf("YPPROC_MASTER\n"); break;
			case 0x00000010 : printf("YPPROC_ORDER\n"); break;
			case 0x00000011 : printf("YPPROC_MAPLIST\n"); break;
			default : printf("unrecognised function!\n");
			};
		break;

	case 0x00000001 :
		if(dontshowreply) return;
		for(c=36;c<52;c++) if(ippkt[c]!=0) return;
		if((c=ntohl(cptol(ippkt+52)))&0xfffffff0) if((~c)&0xfffffff0) return;
		c=ntohl(cptol(ippkt+56));
		if((c+PADDING(c)+60)!=iplen) return;
		displaystuff(ippkt);
		displaymatchreply(ippkt+52);
		break;

	default : return;
	};
			
putchar('\n');
}

void displaystuff(u_char *ippkt)
{
printf("from %u.%u.%u.%u:%hu\tto %u.%u.%u.%u:%hu\tlength=%hu\txid=%lu\n",
	ippkt[12],ippkt[13],ippkt[14],ippkt[15],
	ntohs(cptos(ippkt+20)),
	ippkt[16],ippkt[17],ippkt[18],ippkt[19],
	ntohs(cptos(ippkt+22)),
	ntohs(cptos(ippkt+2)),
	ntohl(cptol(ippkt+28)));
}


int displaymatchcall(u_char *domainlen,int size)
{
static u_char *domain,*map,*key;
static u_char *maplen,*keylen;
static u_long dlen,mlen,klen;
static u_long a,b;

dlen=ntohl(cptol(domainlen));
if(dlen>MAXNAMELENGTH) return(-1);
domain=(((u_char*)domainlen)+4);
mlen=ntohl(cptol(maplen=(domain+(a=dlen+PADDING(dlen)))));
if(mlen>MAXNAMELENGTH) return(-1);
map=maplen+4;
klen=ntohl(cptol(keylen=(map+(b=mlen+PADDING(mlen)))));
if(klen>MAXLINELENGTH) return(-1);
key=keylen+4;
if(((int)(12+a+b+klen+PADDING(klen)))>size) return(-1);

printf("domain=");
printxdrstring(domain,dlen);
printf("\tmap=");
printxdrstring(map,mlen);
printf("\tkey=");
printxdrstring(key,klen);
putchar('\n');

return(0);
}


void displaymatchreply(u_char *stat)
{
printf("NIS reply: YPPROC_MATCH stat=");
switch(ntohl(cptol(stat)))
	{
	case 1 :	printf("YP_TRUE\n"); printxdrstring(stat+8,ntohl(cptol(stat+4))); putchar('\n'); break;
	case 2 :	printf("YP_NOMORE\n"); break;
	case 0 :	printf("YP_FALSE\n"); break;
	case -1 :	printf("YP_NOMAP\n"); break;
	case -2 :	printf("YP_NODOM\n"); break;
	case -3 :	printf("YP_NOKEY\n"); break;
	case -4 :	printf("YP_BADOP\n"); break;
	case -5 :	printf("YP_BADDB\n"); break;
	case -6 :	printf("YP_YPERR\n"); break;
	case -7 :	printf("YP_BADARGS\n"); break;
	case -8 :	printf("YP_VERS\n"); break;
	default :	printf("unknown ypstat value (%ld)\n",ntohl(cptol(stat)));
	};
}


void printxdrstring(u_char *xdrdata,u_long length)
{
register u_long c;
for(c=0;c<length;c++) putchar(xdrdata[c]);
}


void theend(int sig)
{
struct pcap_stat pstat;
putchar('\n');
fflush(stdout);
fflush(stderr);
psignal(sig,"signal received");
if(pcd!=NULL)
	{
	if(pcap_stats(pcd,&pstat)) pcap_perror(pcd,"pcap_stats"); else
		printf("packets received=%d, packets dropped=%d\n",pstat.ps_recv,pstat.ps_drop);
	};
exit(0);
}


/******* here we have some functions to convert between types etc *******/


u_short cptos(u_char *cp)
{
static union shortunion s;
s.c[0]=cp[0];
s.c[1]=cp[1];
return(s.s);
}


u_long cptol(u_char *cp)
{
static union longunion l;
l.c[0]=cp[0];
l.c[1]=cp[1];
l.c[2]=cp[2];
l.c[3]=cp[3];
return(l.l);
}


u_char *scptocp(u_char *dest,u_char *src)
{
dest[0]=src[0];
dest[1]=src[1];
return(dest);
}


u_char *lcptocp(u_char *dest,u_char *src)
{
dest[0]=src[0];
dest[1]=src[1];
dest[2]=src[2];
dest[3]=src[3];
return(dest);
}


u_char *stocp(u_char *cp,u_short us)
{
static union shortunion s;
s.s=us;
cp[0]=s.c[0];
cp[1]=s.c[1];
return(cp);
}


u_char *ltocp(u_char *cp,u_long ul)
{
static union longunion l;
l.l=ul;
cp[0]=l.c[0];
cp[1]=l.c[1];
cp[2]=l.c[2];
cp[3]=l.c[3];
return(cp);
}

