#ifndef _SOCDEMON_H_
#define _SOCDEMON_H_

#include <stdio.h>
/* #include <pwd.h> */
/* #include <grp.h> */
#include <errno.h>
#include <signal.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "socdefs.h"

/* now the text it spits back at you */
static char *out_table[] = {
  "Input line too long. Exiting!\n",
  "The following commands are valid:\n",
  "Command complete\n",
  "WARNING: Bad port number specified, using default.\n",
#ifdef LOG_TO_DEATH
  "WARNING: No log file specified, using default.\n",
  "WARNING: No command log file specified, using default.\n",
#endif
  "WARNING: Command did not execute successfully.\n",
  "Unable to execute command.\n",
  "Unrecognized command.\n",
  "CD command successful.\n",
  "Goodbye!\n"
};

typedef enum {
   input_too_long,
   valid_commands,
   command_complete,
   bad_port_use_def,
#ifdef LOG_TO_DEATH
   no_log_use_def,
   no_cmd_log_use_def,
#endif
   command_failed,
   didnt_execute,
   unknown_command,
   cd_successful,
   goodbye_str
} t_out_str;

/* now some constants */
static char *parm_table[] = {
   "-h",        "print this screen",
   "-help",     "as above",
   "-p",        "activate on port (-p <PORT>)",
   "-port",     "as above",
   "-d",        "debug mode",
   "-debug",    "as above",
#ifdef LOG_TO_DEATH
   "-l",        "log all connects to file (-l <FILE>)",
   "-log",      "as above",
   "-c",        "log all commands to file (-c <FILE>)",
   "-command",  "as above",
#endif
   "-s",        "supress output (silent mode)",
   "-silent",   "as above",
   "-nil",      "do nothing"
};

typedef enum {
   parm_help1,   help1_description,
   parm_help2,   help2_description,
   parm_port1,   help1_port,
   parm_port2,   help2_port,
   parm_debug1,  help1_debug,
   parm_debug2,  help2_debug,
#ifdef LOG_TO_DEATH
   parm_log1,    help1_log,
   parm_log2,    help2_log,
   parm_cmds1,   help1_cmds,
   parm_cmds2,   help2_cmds,
#endif
   parm_silent1, silent1_description,
   parm_silent2, silent2_description,
   parm_nil,     nil_description            /* this must be last */
} t_parms;

static char *command_table[] = {
   "?",     "Help on commands",
   "HELP",  "Help on commands",
   "VER",   "Report Program Version",
   "CMD",   "Execute a unix command",
   "SHELL", "Start a unix shell",
   "CREATE", "Create a new file",
   "PWD",   "Print current directory",
   "CD",    "Change directory",
   "LS",    "List files",
   "CP",    "Copy file(s)",
   "RM",    "Erase file(s)",
   "MV",    "Move file(s)",
   "CAT",   "Display a files contents",
   "CHMOD", "Change file(s) attributes",
   "CHOWN", "Change ownership of file(s)",
   "CHGRP", "Change group of file(s)",
   "W",     "Print active processes",
   "PS",    "Print all processes",
   "WHO",   "List users logged in",
   "WHOAMI", "Print username and id",
   "ID",    "Print Real and Effective User IDs",
   "UNAME", "Print Machine Information",
   "DIE",   "Terminate program (client and server)",
   "QUIT",  "Exit",
   "BYE",   "Exit",
   "NOOP",  "Do nothing"
};

typedef enum {
   cmd_qstn,     cmd_qstn_desc,
   cmd_help,     cmd_help_desc,
   cmd_ver,      cmd_ver_desc,
   cmd_cmd,      cmd_cmd_desc,
   cmd_shell,    cmd_shell_desc,
   cmd_create,   cmd_create_desc,
   cmd_pwd,      cmd_pwd_desc,
   cmd_cd,       cmd_cd_desc,
   cmd_ls,       cmd_ls_desc,
   cmd_cp,       cmd_cp_desc,
   cmd_rm,       cmd_rm_desc,
   cmd_mv,       cmd_mv_desc,
   cmd_cat,      cmd_cat_desc,
   cmd_chmod,    cmd_chmod_desc,
   cmd_chown,    cmd_chown_desc,
   cmd_chgrp,    cmd_chgrp_desc,
   cmd_w,        cmd_w_desc,
   cmd_ps,       cmd_ps_desc,
   cmd_who,      cmd_who_desc,
   cmd_whoami,   cmd_whoami_desc,
   cmd_id,       cmd_id_desc,
   cmd_uname,    cmd_uname_desc,
   cmd_die,      cmd_die_desc,
   cmd_quit,     cmd_quit_desc,
   cmd_bye,      cmd_bye_desc,
   cmd_nil,      cmd_nil_desc               /* this must be last  */
} t_cmds;

#endif
