#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/conf.h>
#include <sun/vddrv.h>

extern int nodev();
extern int vif_open(), vif_close(), vif_read(), vif_write(), vif_ioctl(), vif_select();

struct cdevsw vif_cdevsw = {
	vif_open,	vif_close,	vif_read,	vif_write,
	vif_ioctl,	nodev,		vif_select,	0,
	0,		0,
};

#ifdef sun4m
struct vdldrv vif_drv = {
	VDMAGIC_PSEUDO,
	"vif",
	NULL,
	NULL,
	&vif_cdevsw,
	0,
	0,
	NULL,
	NULL,
	NULL,
	0,
	0
};
#else /* sun4m */
struct vdldrv vif_drv = {
	VDMAGIC_PSEUDO,
	"vif",
#ifdef sun4c
	NULL,
#else
	NULL,
	NULL,
	NULL,
	0,
	0,
#endif
	NULL,
	&vif_cdevsw,
	0,
	0
};
#endif /* sun4m */

/* ARGSUSED */
vif_vdcmd(cmd, vdp, vdi, vds)
int cmd;
struct vddrv *vdp;
struct vdioctl_load *vdi;
struct vdstat *vds;
{
	int status = 0;

	switch (cmd) {
	case VDLOAD:
		vdp->vdd_vdtab = (struct vdlinkage *) &vif_drv;
		break;
	case VDUNLOAD:
#ifdef DETACH
		vifdetach();
#endif /* DETACH */
		break;
	case VDSTAT:
		break;
	default:
		status = EINVAL;
		break;
	}
	return status;
}
