/* Copyright (C) 1995, 1996, 1997 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* iminst.h */
/* Definition of interpreter instance */
#include "imain.h"

/*
 * Define the structure of a search path.  Currently there is only one,
 * but there might be more someday.
 *
 *	container - an array large enough to hold the specified maximum
 * number of directories.  Both the array and all the strings in it are
 * in the 'foreign' VM space.
 *	list - the initial interval of container that defines the actual
 * search list.
 *	env - the contents of an environment variable, implicitly added
 * at the end of the list; may be 0.
 *	final - the final set of directories specified in the makefile;
 * may be 0.
 *	count - the number of elements in the list, excluding a possible
 * initial '.', env, and final.
 */
typedef struct gs_file_path_s {
	ref container;
	ref list;
	const char *env;
	const char *final;
	uint count;
} gs_file_path;

/*
 * Here is where we actually define the structure of interpreter instances.
 * Clients should not reference any of the members.
 */
struct gs_main_instance_s {
		/* The following are set during initialization. */
	FILE *fstdin;
	FILE *fstdout;
	FILE *fstderr;
	uint memory_chunk_size;		/* 'wholesale' allocation unit */
	ulong name_table_size;
	int init_done;			/* highest init done so far */
	int user_errors;		/* define what to do with errors */
	bool search_here_first;		/* if true, make '.' first lib dir */
	bool run_start;			/* if true, run 'start' after */
					/* processing command line */
	gs_file_path lib_path;		/* library search list (GS_LIB) */
};
/*
 * Note that any file that uses the following definition of default values
 * must include gconfig.h, because of SEARCH_HERE_FIRST.
 */
#define gs_main_instance_default_init_values\
 0, 0, 0, 20000, 0, -1, 0, SEARCH_HERE_FIRST, 1
extern const gs_main_instance gs_main_instance_init_values;
